/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde;

import com.tssap.selena.gde.ModelElementEditPart;
import com.tssap.selena.gde.ModelPropertyInplaceApplier;
import com.tssap.selena.gde.internal.Messages;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.enum.PropertyEnumeration;
import java.util.StringTokenizer;

public class MultipleModelPropertyInplaceApplier
extends ModelPropertyInplaceApplier {
    private static final char SEPARATOR = ',';
    private static final String SEPARATOR_STR = ",";

    public MultipleModelPropertyInplaceApplier(Element element, String propertyName) {
        super(element, propertyName);
    }

    public MultipleModelPropertyInplaceApplier(ModelElementEditPart element, String propertyName) {
        super(element, propertyName);
    }

    public String getInitialValue() {
        String value = "";
        if (this.getPropertyName() == null) {
            return value;
        }
        PropertyEnumeration properties = this.getElement().properties(this.getPropertyName());
        while (properties.hasMoreElements()) {
            String property = properties.next().getValue();
            if (property != null) {
                value = value + property;
            }
            if (!properties.hasMoreElements()) continue;
            value = value + ',';
        }
        return value;
    }

    public void applyValue(Object value) {
        if (!(value instanceof String) || this.getElement() == null || this.getPropertyName() == null) {
            return;
        }
        String stringValue = (String)value;
        Element element = this.getElement().setPropertyValue(this.getPropertyName(), null).getElement();
        StringTokenizer tokens = new StringTokenizer(stringValue, SEPARATOR_STR);
        while (tokens.hasMoreTokens()) {
            String property = tokens.nextToken();
            if (property.trim().length() == 0) continue;
            element = element.addProperty(this.getPropertyName(), property).getElement();
        }
        this.setChangedElement(element);
    }

    public String canApplyValue(Object value) {
        if (!(value instanceof String)) {
            return Messages.getString("ModelPropertyInplaceApplier.InvalidInplaceValue");
        }
        String stringValue = (String)value;
        if (stringValue.trim().length() == 0) {
            return ModelPropertyInplaceApplier.VALID;
        }
        StringTokenizer tokens = new StringTokenizer(stringValue, SEPARATOR_STR);
        while (tokens.hasMoreTokens()) {
            String property = tokens.nextToken();
            if (property.trim().length() == 0) continue;
            return ModelPropertyInplaceApplier.VALID;
        }
        return ModelPropertyInplaceApplier.VALID;
    }
}

