/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde;

import com.tssap.selena.gde.EditPartElementWrapper;
import com.tssap.selena.gde.IInplaceEditorApplier;
import com.tssap.selena.gde.ModelElementEditPart;
import com.tssap.selena.gde.internal.Messages;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;

public class ModelPropertyInplaceApplier
implements IInplaceEditorApplier {
    private String myPropertyName;
    private Element myElement;
    protected static final String VALID = null;
    private Element myChangedElement = null;

    public ModelPropertyInplaceApplier(Element element, String propertyName) {
        this.myElement = element;
        this.myChangedElement = element;
        this.myPropertyName = propertyName;
    }

    public ModelPropertyInplaceApplier(ModelElementEditPart editPart, String propertyName) {
        this.myElement = new EditPartElementWrapper(editPart).getResolvedElement();
        this.myPropertyName = propertyName;
    }

    public String getInitialValue() {
        if (this.myElement != null) {
            return this.myElement.getPropertyValue(this.myPropertyName);
        }
        return "";
    }

    public void applyValue(Object value) {
        if (this.myElement != null) {
            Property resultProperty = this.myElement.setPropertyValue(this.myPropertyName, (String)value);
            this.myChangedElement = resultProperty == null ? null : resultProperty.getElement();
        }
    }

    public String isValid(Object value) {
        return VALID;
    }

    public String canApplyValue(Object value) {
        if (this.myElement == null) {
            return "";
        }
        if (!(value instanceof String)) {
            return Messages.getString("ModelPropertyInplaceApplier.InvalidInplaceValue");
        }
        String stringValue = (String)value;
        if (!this.myElement.canSetPropertyValue(this.myPropertyName, stringValue)) {
            return Messages.getString("can_not_set_value___1") + value;
        }
        return VALID;
    }

    public Object getChangedElement() {
        return this.myChangedElement;
    }

    public void setChangedElement(Element element) {
        this.myChangedElement = element;
    }

    protected Element getElement() {
        return this.myElement;
    }

    protected String getPropertyName() {
        return this.myPropertyName;
    }
}

