/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.gde;

import com.tssap.selena.gde.IDiagramLayoutManager;
import com.tssap.selena.gde.IDiagramLayoutManagerProvider;
import com.tssap.selena.gde.internal.GdePlugin;
import com.tssap.selena.model.update.diagram.IDiagram;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;

public class DiagramLayouts {
    private static HashSet myProviders = new HashSet();
    private static HashMap myProvidersMap = new HashMap();
    private static IDiagramLayoutManagerProvider ourDefaultProvider;
    private static final String GDE_PLUGIN_ID = "com.tssap.selena.gde";
    private static final String LAYOUT_EXTENSIONPOINT_ID = "diagram-layouts";
    private static final String LAYOUT_EXTENSION_TAG = "layout";
    private static final String DEFAULT_LAYOUT_ATTR = "default";

    public static IDiagramLayoutManager getLayoutManager(IDiagram diagram) {
        String metaclass = diagram.getContent().getPropertyValue("$metaclass");
        Object o = myProvidersMap.get(metaclass);
        if (o instanceof IDiagramLayoutManager) {
            return (IDiagramLayoutManager)o;
        }
        IDiagramLayoutManager layoutManager = DiagramLayouts.lookupExtentions(diagram, metaclass);
        if (layoutManager == null) {
            System.err.println("Can not find layout for diagram with metaclass: " + metaclass);
            layoutManager = IDiagramLayoutManager.NULL_LAYOUT;
        }
        myProvidersMap.put(metaclass, layoutManager);
        return layoutManager;
    }

    private static IDiagramLayoutManager lookupExtentions(IDiagram diagram, String metaclass) {
        Iterator it = myProviders.iterator();
        while (it.hasNext()) {
            IDiagramLayoutManagerProvider layoutProvider = (IDiagramLayoutManagerProvider)it.next();
            if (!layoutProvider.isApplicable(diagram)) continue;
            return layoutProvider.createDiagramLayoutManager();
        }
        if (ourDefaultProvider != null && ourDefaultProvider.isApplicable(diagram)) {
            return ourDefaultProvider.createDiagramLayoutManager();
        }
        return null;
    }

    public static void parseExtensions() {
        IPluginDescriptor pluginDescriptor = GdePlugin.getDefault().getDescriptor();
        IExtensionPoint point = pluginDescriptor.getExtensionPoint(LAYOUT_EXTENSIONPOINT_ID);
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                IConfigurationElement layoutProviderElement = elements[j];
                if (layoutProviderElement.getName().equals(LAYOUT_EXTENSION_TAG)) {
                    try {
                        Object layoutProvider = layoutProviderElement.createExecutableExtension("class");
                        if (layoutProvider instanceof IDiagramLayoutManagerProvider) {
                            if (ourDefaultProvider == null && layoutProviderElement.getAttribute(DEFAULT_LAYOUT_ATTR) != null) {
                                ourDefaultProvider = (IDiagramLayoutManagerProvider)layoutProvider;
                            } else {
                                myProviders.add(layoutProvider);
                            }
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    catch (NoClassDefFoundError e) {
                        e.printStackTrace();
                    }
                }
                ++j;
            }
            ++i;
        }
    }
}

