/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.types;

public abstract class CommonTypes {
    public static final int ARRAY = 2003;
    public static final int BIGINT = -5;
    public static final int BINARY = -2;
    public static final int BIT = -7;
    public static final int BLOB = 2004;
    public static final int CHAR = 1;
    public static final int CLOB = 2005;
    public static final int DATE = 91;
    public static final int DECIMAL = 3;
    public static final int DISTINCT = 2001;
    public static final int DOUBLE = 8;
    public static final int FLOAT = 6;
    public static final int INTEGER = 4;
    public static final int JAVA_OBJECT = 2000;
    public static final int LONGVARBINARY = -4;
    public static final int LONGVARCHAR = -1;
    public static final int NULL = 0;
    public static final int NUMERIC = 2;
    public static final int OTHER = 1111;
    public static final int REAL = 7;
    public static final int REF = 2006;
    public static final int SMALLINT = 5;
    public static final int STRUCT = 2002;
    public static final int TIME = 92;
    public static final int TIMESTAMP = 93;
    public static final int TINYINT = -6;
    public static final int VARBINARY = -3;
    public static final int VARCHAR = 12;
    private static final String jdbcARRAY = "ARRAY";
    private static final String jdbcBIGINT = "BIGINT";
    private static final String jdbcBINARY = "BINARY";
    private static final String jdbcBIT = "BIT";
    private static final String jdbcBLOB = "BLOB";
    private static final String jdbcCHAR = "CHAR";
    private static final String jdbcCLOB = "CLOB";
    private static final String jdbcDATE = "DATE";
    private static final String jdbcDECIMAL = "DECIMAL";
    private static final String jdbcDISTINCT = "DISTINCT";
    private static final String jdbcDOUBLE = "DOUBLE";
    private static final String jdbcFLOAT = "FLOAT";
    private static final String jdbcINTEGER = "INTEGER";
    private static final String jdbcJAVA_OBJECT = "JAVA_OBJECT";
    private static final String jdbcLONGVARBINARY = "LONGVARBINARY";
    private static final String jdbcLONGVARCHAR = "LONGVARCHAR";
    private static final String jdbcNULL = "NULL";
    private static final String jdbcNUMERIC = "NUMERIC";
    private static final String jdbcOTHER = "OTHER";
    private static final String jdbcREAL = "REAL";
    private static final String jdbcREF = "REF";
    private static final String jdbcSMALLINT = "SMALLINT";
    private static final String jdbcSTRUCT = "STRUCT";
    private static final String jdbcTIME = "TIME";
    private static final String jdbcTIMESTAMP = "TIMESTAMP";
    private static final String jdbcTINYINT = "TINYINT";
    private static final String jdbcVARBINARY = "VARBINARY";
    private static final String jdbcVARCHAR = "VARCHAR";
    private static final Class[] characterTypeMap = new Class[]{class$java$lang$String == null ? (class$java$lang$String = CommonTypes.class$("java.lang.String")) : class$java$lang$String, class$java$io$Reader == null ? (class$java$io$Reader = CommonTypes.class$("java.io.Reader")) : class$java$io$Reader};
    private static final Class[] clobTypeMap = new Class[]{class$java$sql$Clob == null ? (class$java$sql$Clob = CommonTypes.class$("java.sql.Clob")) : class$java$sql$Clob, class$java$lang$String == null ? (class$java$lang$String = CommonTypes.class$("java.lang.String")) : class$java$lang$String, class$java$io$Reader == null ? (class$java$io$Reader = CommonTypes.class$("java.io.Reader")) : class$java$io$Reader};
    private static final Class[] binaryTypeMap = new Class[]{array$B == null ? (array$B = CommonTypes.class$("[B")) : array$B, class$java$io$InputStream == null ? (class$java$io$InputStream = CommonTypes.class$("java.io.InputStream")) : class$java$io$InputStream};
    private static final Class[] blobTypeMap = new Class[]{class$java$sql$Blob == null ? (class$java$sql$Blob = CommonTypes.class$("java.sql.Blob")) : class$java$sql$Blob, array$B == null ? (array$B = CommonTypes.class$("[B")) : array$B, class$java$io$InputStream == null ? (class$java$io$InputStream = CommonTypes.class$("java.io.InputStream")) : class$java$io$InputStream};
    private static final Class[] smallintTypeMap = new Class[]{Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = CommonTypes.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, class$java$lang$Short == null ? (class$java$lang$Short = CommonTypes.class$("java.lang.Short")) : class$java$lang$Short, class$java$lang$Integer == null ? (class$java$lang$Integer = CommonTypes.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Long == null ? (class$java$lang$Long = CommonTypes.class$("java.lang.Long")) : class$java$lang$Long, class$java$lang$Float == null ? (class$java$lang$Float = CommonTypes.class$("java.lang.Float")) : class$java$lang$Float, class$java$lang$Double == null ? (class$java$lang$Double = CommonTypes.class$("java.lang.Double")) : class$java$lang$Double};
    private static final Class[] intTypeMap = new Class[]{Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = CommonTypes.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, class$java$lang$Integer == null ? (class$java$lang$Integer = CommonTypes.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Long == null ? (class$java$lang$Long = CommonTypes.class$("java.lang.Long")) : class$java$lang$Long, class$java$lang$Float == null ? (class$java$lang$Float = CommonTypes.class$("java.lang.Float")) : class$java$lang$Float, class$java$lang$Double == null ? (class$java$lang$Double = CommonTypes.class$("java.lang.Double")) : class$java$lang$Double};
    private static final Class[] bigintTypeMap = new Class[]{Long.TYPE, Float.TYPE, Double.TYPE, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = CommonTypes.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, class$java$lang$Long == null ? (class$java$lang$Long = CommonTypes.class$("java.lang.Long")) : class$java$lang$Long, class$java$lang$Float == null ? (class$java$lang$Float = CommonTypes.class$("java.lang.Float")) : class$java$lang$Float, class$java$lang$Double == null ? (class$java$lang$Double = CommonTypes.class$("java.lang.Double")) : class$java$lang$Double};
    private static final Class[] floatTypeMap = new Class[]{Float.TYPE, Double.TYPE, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = CommonTypes.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, class$java$lang$Float == null ? (class$java$lang$Float = CommonTypes.class$("java.lang.Float")) : class$java$lang$Float, class$java$lang$Double == null ? (class$java$lang$Double = CommonTypes.class$("java.lang.Double")) : class$java$lang$Double};
    private static final Class[] doubleTypeMap = new Class[]{Double.TYPE, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = CommonTypes.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, class$java$lang$Double == null ? (class$java$lang$Double = CommonTypes.class$("java.lang.Double")) : class$java$lang$Double};
    private static final Class[] decimalTypeMap = new Class[]{class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = CommonTypes.class$("java.math.BigDecimal")) : class$java$math$BigDecimal};
    private static final Class[] dateTypeMap = new Class[]{class$java$sql$Date == null ? (class$java$sql$Date = CommonTypes.class$("java.sql.Date")) : class$java$sql$Date};
    private static final Class[] timeTypeMap = new Class[]{class$java$sql$Time == null ? (class$java$sql$Time = CommonTypes.class$("java.sql.Time")) : class$java$sql$Time};
    private static final Class[] timestampTypeMap = new Class[]{class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = CommonTypes.class$("java.sql.Timestamp")) : class$java$sql$Timestamp};
    private static final Class[] bitTypeMap = new Class[]{Boolean.TYPE, class$java$lang$Boolean == null ? (class$java$lang$Boolean = CommonTypes.class$("java.lang.Boolean")) : class$java$lang$Boolean};
    private static final int[] javaStringTypeMap = new int[]{12, 1, -1, 2005};
    private static final int[] javaByteArrayTypeMap = new int[]{-3, -2, -4, 2004};
    private static final int[] javaBooleanTypeMap = new int[]{-7};
    private static final int[] javaByteTypeMap = new int[]{0, 5, 4, -5, 8, 3, 7, 6, 2};
    private static final int[] javaShortTypeMap = new int[]{5, 4, -5, 8, 3, 7, 6, 2};
    private static final int[] javaIntegerTypeMap = new int[]{4, -5, 8, 3, 7, 6, 2};
    private static final int[] javaLongTypeMap = new int[]{-5, 8, 3, 7, 6, 2};
    private static final int[] javaFloatTypeMap = new int[]{7, 8, 3, 6, 2};
    private static final int[] javaDoubleTypeMap = new int[]{8, 3, 6, 2};
    private static final int[] javaBigDecimalTypeMap = new int[]{3, 2};
    private static final int[] javaDateTypeMap = new int[]{91};
    private static final int[] javaTimeTypeMap = new int[]{92};
    private static final int[] javaTimestampTypeMap = new int[]{93};
    private static final int[] javaClobTypeMap = new int[]{2005};
    private static final int[] javaBlobTypeMap = new int[]{2004};
    private static final int[] javaReaderTypeMap = new int[]{0, 12, 1, -1, 2005};
    private static final int[] javaInputStreamTypeMap = new int[]{0, -3, -2, -4, 2004};
    private static final int[] javaNotSupportedTypeMap = new int[]{0};
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$Reader;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$sql$Clob;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$sql$Blob;
    static /* synthetic */ Class class$java$lang$Boolean;

    public static final String getJdbcTypeName(int jdbcType) {
        switch (jdbcType) {
            case 2003: {
                return jdbcARRAY;
            }
            case -5: {
                return jdbcBIGINT;
            }
            case -2: {
                return jdbcBINARY;
            }
            case -7: {
                return jdbcBIT;
            }
            case 2004: {
                return jdbcBLOB;
            }
            case 1: {
                return jdbcCHAR;
            }
            case 2005: {
                return jdbcCLOB;
            }
            case 91: {
                return jdbcDATE;
            }
            case 3: {
                return jdbcDECIMAL;
            }
            case 2001: {
                return jdbcDISTINCT;
            }
            case 8: {
                return jdbcDOUBLE;
            }
            case 6: {
                return jdbcFLOAT;
            }
            case 4: {
                return jdbcINTEGER;
            }
            case 2000: {
                return jdbcJAVA_OBJECT;
            }
            case -4: {
                return jdbcLONGVARBINARY;
            }
            case -1: {
                return jdbcLONGVARCHAR;
            }
            case 0: {
                return jdbcNULL;
            }
            case 2: {
                return jdbcNUMERIC;
            }
            case 1111: {
                return jdbcOTHER;
            }
            case 7: {
                return jdbcREAL;
            }
            case 2006: {
                return jdbcREF;
            }
            case 5: {
                return jdbcSMALLINT;
            }
            case 2002: {
                return jdbcSTRUCT;
            }
            case 92: {
                return jdbcTIME;
            }
            case 93: {
                return jdbcTIMESTAMP;
            }
            case -6: {
                return jdbcTINYINT;
            }
            case -3: {
                return jdbcVARBINARY;
            }
            case 12: {
                return jdbcVARCHAR;
            }
        }
        return null;
    }

    public static final boolean isApproxNumeric(int jdbcType) {
        return jdbcType == 6 || jdbcType == 8 || jdbcType == 7;
    }

    public static final boolean isExactNumeric(int jdbcType) {
        return jdbcType == 2 || jdbcType == 3 || jdbcType == -6 || jdbcType == 5 || jdbcType == 4 || jdbcType == -5;
    }

    public static final boolean isNumeric(int jdbcType) {
        return CommonTypes.isApproxNumeric(jdbcType) || CommonTypes.isExactNumeric(jdbcType);
    }

    public static final boolean isNumeric(Class javaClass) {
        if (javaClass.equals(Byte.TYPE) || javaClass.equals(class$java$lang$Byte == null ? (class$java$lang$Byte = CommonTypes.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return true;
        }
        if (javaClass.equals(Short.TYPE) || javaClass.equals(class$java$lang$Short == null ? (class$java$lang$Short = CommonTypes.class$("java.lang.Short")) : class$java$lang$Short)) {
            return true;
        }
        if (javaClass.equals(Integer.TYPE) || javaClass.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = CommonTypes.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return true;
        }
        if (javaClass.equals(Long.TYPE) || javaClass.equals(class$java$lang$Long == null ? (class$java$lang$Long = CommonTypes.class$("java.lang.Long")) : class$java$lang$Long)) {
            return true;
        }
        if (javaClass.equals(Float.TYPE) || javaClass.equals(class$java$lang$Float == null ? (class$java$lang$Float = CommonTypes.class$("java.lang.Float")) : class$java$lang$Float)) {
            return true;
        }
        if (javaClass.equals(Double.TYPE) || javaClass.equals(class$java$lang$Double == null ? (class$java$lang$Double = CommonTypes.class$("java.lang.Double")) : class$java$lang$Double)) {
            return true;
        }
        return (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = CommonTypes.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).isAssignableFrom(javaClass);
    }

    public static final boolean isCharacterLike(int jdbcType) {
        return jdbcType == 1 || jdbcType == 12 || jdbcType == -1;
    }

    public static final boolean isCharacterLike(Class javaClass) {
        return javaClass.equals(class$java$lang$String == null ? (class$java$lang$String = CommonTypes.class$("java.lang.String")) : class$java$lang$String) || (class$java$io$Reader == null ? (class$java$io$Reader = CommonTypes.class$("java.io.Reader")) : class$java$io$Reader).isAssignableFrom(javaClass);
    }

    public static final boolean isDatetimeLike(int jdbcType) {
        return jdbcType == 91 || jdbcType == 92 || jdbcType == 93;
    }

    public static final boolean isDatetimeLike(Class javaClass) {
        return javaClass.isAssignableFrom(class$java$sql$Date == null ? (class$java$sql$Date = CommonTypes.class$("java.sql.Date")) : class$java$sql$Date) || javaClass.isAssignableFrom(class$java$sql$Time == null ? (class$java$sql$Time = CommonTypes.class$("java.sql.Time")) : class$java$sql$Time) || javaClass.isAssignableFrom(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = CommonTypes.class$("java.sql.Timestamp")) : class$java$sql$Timestamp);
    }

    public static final boolean isBinary(int jdbcType) {
        return jdbcType == -2 || jdbcType == -3 || jdbcType == -4;
    }

    public static final boolean isFullySupported(int jdbcType) {
        return jdbcType == 12 || jdbcType == -2 || jdbcType == -1 || jdbcType == -4 || jdbcType == 5 || jdbcType == 4 || jdbcType == -5 || jdbcType == 7 || jdbcType == 8 || jdbcType == 3 || jdbcType == 91 || jdbcType == 92 || jdbcType == 93 || jdbcType == 2005 || jdbcType == 2004;
    }

    public static final boolean isSupported(int jdbcType) {
        return CommonTypes.isFullySupported(jdbcType) || jdbcType == 1 || jdbcType == -3 || jdbcType == 6 || jdbcType == 2 || jdbcType == -7;
    }

    public static final boolean isValid(int jdbcType) {
        return CommonTypes.isSupported(jdbcType) || jdbcType == 0 || jdbcType == -6 || jdbcType == 2003 || jdbcType == 2000 || jdbcType == 2001 || jdbcType == 1111 || jdbcType == 2006 || jdbcType == 2002;
    }

    public static final boolean isLargeObject(int jdbcType) {
        return 2004 == jdbcType || 2005 == jdbcType || -1 == jdbcType || -4 == jdbcType;
    }

    public static final boolean isComparable(int jdbcType) {
        return CommonTypes.isSupported(jdbcType) && !CommonTypes.isLargeObject(jdbcType) && jdbcType != -3;
    }

    public static final boolean isComparableWith(int lhs, int rhs) {
        if (!CommonTypes.isComparable(lhs)) {
            return false;
        }
        if (lhs == rhs) {
            return true;
        }
        if (!CommonTypes.isComparable(rhs)) {
            return false;
        }
        if (CommonTypes.isNumeric(lhs)) {
            return CommonTypes.isNumeric(rhs);
        }
        if (CommonTypes.isCharacterLike(lhs)) {
            return CommonTypes.isCharacterLike(rhs);
        }
        return false;
    }

    public static final boolean isAssignableFrom(int target, int source) {
        if (CommonTypes.isNumeric(target)) {
            return CommonTypes.isNumeric(source);
        }
        if (CommonTypes.isCharacterLike(target)) {
            return CommonTypes.isCharacterLike(source);
        }
        return target == source;
    }

    public static final Class defaultMapping(int jdbcType) {
        Class[] allowedMap = CommonTypes.getableInto(jdbcType);
        if (null != allowedMap) {
            return allowedMap[0];
        }
        return null;
    }

    public static final int defaultMapping(Class javaClass) {
        int[] allowedMap = CommonTypes.setableFrom(javaClass);
        return allowedMap[0];
    }

    public static final Class[] getableInto(int jdbcType) {
        switch (jdbcType) {
            case -1: 
            case 1: 
            case 12: {
                return characterTypeMap;
            }
            case 2005: {
                return clobTypeMap;
            }
            case -4: 
            case -3: 
            case -2: {
                return binaryTypeMap;
            }
            case 2004: {
                return blobTypeMap;
            }
            case 5: {
                return smallintTypeMap;
            }
            case 4: {
                return intTypeMap;
            }
            case -5: {
                return bigintTypeMap;
            }
            case 7: {
                return floatTypeMap;
            }
            case 6: 
            case 8: {
                return doubleTypeMap;
            }
            case 2: 
            case 3: {
                return decimalTypeMap;
            }
            case 91: {
                return dateTypeMap;
            }
            case 92: {
                return timeTypeMap;
            }
            case 93: {
                return timestampTypeMap;
            }
            case -7: {
                return bitTypeMap;
            }
        }
        return null;
    }

    public static final int[] setableFrom(Class javaClass) {
        if (javaClass == null) {
            return null;
        }
        if ((class$java$lang$String == null ? (class$java$lang$String = CommonTypes.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(javaClass)) {
            return javaStringTypeMap;
        }
        if (javaClass.equals(array$B == null ? (array$B = CommonTypes.class$("[B")) : array$B)) {
            return javaByteArrayTypeMap;
        }
        if (javaClass.equals(Boolean.TYPE) || (class$java$lang$Boolean == null ? (class$java$lang$Boolean = CommonTypes.class$("java.lang.Boolean")) : class$java$lang$Boolean).isAssignableFrom(javaClass)) {
            return javaBooleanTypeMap;
        }
        if (javaClass.equals(Byte.TYPE) || (class$java$lang$Byte == null ? (class$java$lang$Byte = CommonTypes.class$("java.lang.Byte")) : class$java$lang$Byte).isAssignableFrom(javaClass)) {
            return javaByteTypeMap;
        }
        if (javaClass.equals(Short.TYPE) || (class$java$lang$Short == null ? (class$java$lang$Short = CommonTypes.class$("java.lang.Short")) : class$java$lang$Short).isAssignableFrom(javaClass)) {
            return javaShortTypeMap;
        }
        if (javaClass.equals(Integer.TYPE) || (class$java$lang$Integer == null ? (class$java$lang$Integer = CommonTypes.class$("java.lang.Integer")) : class$java$lang$Integer).isAssignableFrom(javaClass)) {
            return javaIntegerTypeMap;
        }
        if (javaClass.equals(Long.TYPE) || (class$java$lang$Long == null ? (class$java$lang$Long = CommonTypes.class$("java.lang.Long")) : class$java$lang$Long).isAssignableFrom(javaClass)) {
            return javaLongTypeMap;
        }
        if (javaClass.equals(Float.TYPE) || (class$java$lang$Float == null ? (class$java$lang$Float = CommonTypes.class$("java.lang.Float")) : class$java$lang$Float).isAssignableFrom(javaClass)) {
            return javaFloatTypeMap;
        }
        if (javaClass.equals(Double.TYPE) || (class$java$lang$Double == null ? (class$java$lang$Double = CommonTypes.class$("java.lang.Double")) : class$java$lang$Double).isAssignableFrom(javaClass)) {
            return javaDoubleTypeMap;
        }
        if ((class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = CommonTypes.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).isAssignableFrom(javaClass)) {
            return javaBigDecimalTypeMap;
        }
        if ((class$java$sql$Date == null ? (class$java$sql$Date = CommonTypes.class$("java.sql.Date")) : class$java$sql$Date).isAssignableFrom(javaClass)) {
            return javaDateTypeMap;
        }
        if ((class$java$sql$Time == null ? (class$java$sql$Time = CommonTypes.class$("java.sql.Time")) : class$java$sql$Time).isAssignableFrom(javaClass)) {
            return javaTimeTypeMap;
        }
        if ((class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = CommonTypes.class$("java.sql.Timestamp")) : class$java$sql$Timestamp).isAssignableFrom(javaClass)) {
            return javaTimestampTypeMap;
        }
        if ((class$java$sql$Clob == null ? (class$java$sql$Clob = CommonTypes.class$("java.sql.Clob")) : class$java$sql$Clob).isAssignableFrom(javaClass)) {
            return javaClobTypeMap;
        }
        if ((class$java$sql$Blob == null ? (class$java$sql$Blob = CommonTypes.class$("java.sql.Blob")) : class$java$sql$Blob).isAssignableFrom(javaClass)) {
            return javaBlobTypeMap;
        }
        if ((class$java$io$Reader == null ? (class$java$io$Reader = CommonTypes.class$("java.io.Reader")) : class$java$io$Reader).isAssignableFrom(javaClass)) {
            return javaReaderTypeMap;
        }
        if ((class$java$io$InputStream == null ? (class$java$io$InputStream = CommonTypes.class$("java.io.InputStream")) : class$java$io$InputStream).isAssignableFrom(javaClass)) {
            return javaInputStreamTypeMap;
        }
        return javaNotSupportedTypeMap;
    }

    public static final int jdbcTypeArithmeticExpression(int lhs, int rhs) {
        if (!CommonTypes.isNumeric(lhs) || !CommonTypes.isNumeric(rhs)) {
            throw new IllegalArgumentException("arguments not numeric");
        }
        if (CommonTypes.isApproxNumeric(lhs) || CommonTypes.isApproxNumeric(rhs)) {
            if (8 == lhs || 8 == rhs || 6 == lhs || 6 == rhs) {
                return 8;
            }
            return 7;
        }
        if (3 == lhs || 3 == rhs || 2 == lhs || 2 == rhs) {
            return 3;
        }
        if (-5 == lhs || -5 == rhs) {
            return -5;
        }
        if (4 == lhs || 4 == rhs) {
            return 4;
        }
        return 5;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

