/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.tree;

import com.sap.sql.tree.GeneralSelectStatement;
import com.sap.sql.tree.Query;
import com.sap.sql.tree.SQLVisitor;
import com.sap.sql.tree.SortSpecification;
import com.sap.sql.tree.SqlTextExpert;

public class SelectStatement
extends GeneralSelectStatement {
    private SortSpecification[] orderByList = null;
    private boolean hintBypassingBuffer;

    public SelectStatement(Query aQuery, SortSpecification[] anOrderByList) {
        super(aQuery);
        this.orderByList = anOrderByList;
    }

    public SelectStatement(Query aQuery) {
        super(aQuery);
    }

    public void setOrderByList(SortSpecification[] anOrderByList) {
        this.orderByList = anOrderByList;
    }

    public void accept(SQLVisitor visitor) {
        visitor.setStatemntType(this.getStatementType());
        visitor.visitSelectStatementBefore(this);
        if (this.orderByList != null) {
            int i = 0;
            while (i < this.orderByList.length) {
                if (this.orderByList[i] != null) {
                    this.orderByList[i].accept(visitor);
                }
                ++i;
            }
        }
        this.query.accept(visitor);
        visitor.visitSelectStatement(this);
    }

    public SortSpecification[] getOrderByList() {
        return this.orderByList;
    }

    void toSqlTxt(SqlTextExpert expert, StringBuffer strBuf) {
        this.query.toSqlTxt(expert, strBuf);
        if (this.orderByList != null && this.orderByList.length > 0) {
            strBuf.append(" ORDER BY ");
            this.orderByList[0].toSqlTxt(expert, strBuf);
            int i = 1;
            while (i < this.orderByList.length) {
                strBuf.append(",");
                this.orderByList[i].toSqlTxt(expert, strBuf);
                ++i;
            }
        }
    }

    public boolean getHintBypassingBuffer() {
        return this.hintBypassingBuffer;
    }

    public void setBufferable(boolean bufferable) {
        this.hintBypassingBuffer = !bufferable;
    }

    public int getStatementType() {
        return 2;
    }
}

