/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.tree;

import com.sap.sql.tree.ColumnReference;
import com.sap.sql.tree.Hint;
import com.sap.sql.tree.Query;
import com.sap.sql.tree.SQLVisitor;
import com.sap.sql.tree.SearchCondition;
import com.sap.sql.tree.SelectSublist;
import com.sap.sql.tree.SqlTextExpert;

public class QuerySpecification
extends Query {
    private boolean distinct = false;
    private SelectSublist[] selectList;
    private Query[] fromClause;
    private SearchCondition whereClause;
    private ColumnReference[] groupByList = null;
    private SearchCondition havingClause = null;
    private Hint[] hints;

    public QuerySpecification(SelectSublist[] aSelectList, Query[] aFromClause, SearchCondition aWhereClause) {
        this.selectList = aSelectList;
        this.fromClause = aFromClause;
        this.whereClause = aWhereClause;
    }

    public QuerySpecification(boolean isDistinct, SelectSublist[] aSelectList, Query[] aFromClause, SearchCondition aWhereClause, ColumnReference[] aGroupByList, SearchCondition aHavingClause) {
        this.distinct = isDistinct;
        this.selectList = aSelectList;
        this.fromClause = aFromClause;
        this.whereClause = aWhereClause;
        this.groupByList = aGroupByList;
        this.havingClause = aHavingClause;
    }

    public void accept(SQLVisitor visitor) {
        int i;
        visitor.visitQuerySpecificationBefore(this);
        if (this.selectList != null) {
            i = 0;
            while (i < this.selectList.length) {
                if (this.selectList[i] != null) {
                    this.selectList[i].accept(visitor);
                }
                ++i;
            }
        }
        if (this.fromClause != null) {
            i = 0;
            while (i < this.fromClause.length) {
                if (this.fromClause[i] != null) {
                    this.fromClause[i].accept(visitor);
                }
                ++i;
            }
        }
        if (this.whereClause != null) {
            this.whereClause.accept(visitor);
        }
        if (this.groupByList != null) {
            i = 0;
            while (i < this.groupByList.length) {
                if (this.groupByList[i] != null) {
                    this.groupByList[i].accept(visitor);
                }
                ++i;
            }
        }
        if (this.havingClause != null) {
            this.havingClause.accept(visitor);
        }
        visitor.visitQuerySpecification(this);
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public SelectSublist[] getSelectList() {
        return this.selectList;
    }

    public Query[] getFromClause() {
        return this.fromClause;
    }

    public SearchCondition getWhereClause() {
        return this.whereClause;
    }

    public ColumnReference[] getGroupByList() {
        return this.groupByList;
    }

    public SearchCondition getHavingClause() {
        return this.havingClause;
    }

    public void setWhereClause(SearchCondition sc) {
        this.whereClause = sc;
    }

    public void setSelectList(SelectSublist[] ssl) {
        this.selectList = ssl;
    }

    public void toSqlTxt(SqlTextExpert expert, StringBuffer strBuf) {
        int i;
        strBuf.append("SELECT ");
        if (this.distinct) {
            strBuf.append("DISTINCT ");
        }
        if (this.selectList == null || this.selectList.length == 0) {
            strBuf.append("*");
        } else {
            this.selectList[0].toSqlTxt(expert, strBuf);
            i = 1;
            while (i < this.selectList.length) {
                strBuf.append(",");
                this.selectList[i].toSqlTxt(expert, strBuf);
                ++i;
            }
        }
        strBuf.append(" FROM ");
        this.fromClause[0].toSqlTxt(expert, strBuf);
        i = 1;
        while (i < this.fromClause.length) {
            strBuf.append(", ");
            this.fromClause[i].toSqlTxt(expert, strBuf);
            ++i;
        }
        if (this.whereClause != null) {
            strBuf.append(" WHERE ");
            this.whereClause.toSqlTxt(expert, strBuf);
        }
        if (this.groupByList != null) {
            strBuf.append(" GROUP BY ");
            this.groupByList[0].toSqlTxt(expert, strBuf);
            int i2 = 1;
            while (i2 < this.groupByList.length) {
                strBuf.append(", ");
                this.groupByList[i2].toSqlTxt(expert, strBuf);
                ++i2;
            }
        }
        if (this.havingClause != null) {
            strBuf.append(" HAVING ");
            this.havingClause.toSqlTxt(expert, strBuf);
        }
    }

    public void setHints(Hint[] hints) {
        this.hints = hints;
    }
}

