/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.tree;

import com.sap.sql.tree.SelectSublist;
import com.sap.sql.tree.SqlTextExpert;
import com.sap.sql.tree.StringLiteral;

public class OracleSqlTextExpert
extends SqlTextExpert {
    private boolean inSelectSublist = false;

    public void selectSublistToText(SelectSublist sqlNode, StringBuffer textBuffer) {
        this.inSelectSublist = true;
        super.selectSublistToText(sqlNode, textBuffer);
        this.inSelectSublist = false;
    }

    public void stringLiteralToText(StringLiteral sqlNode, StringBuffer textBuffer) {
        String value = sqlNode.getValue();
        StringBuffer result = new StringBuffer(value.length());
        boolean useUnistr = this.inSelectSublist;
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            if (c <= '\u007f' && c != '\\') {
                if (c == '\'') {
                    result.append(c);
                }
                result.append(c);
            } else {
                result.append(this.getUCCodepoint(c));
                useUnistr = true;
            }
            ++i;
        }
        if (useUnistr) {
            textBuffer.append("UNISTR('");
            textBuffer.append((Object)result);
            textBuffer.append("')");
        } else {
            textBuffer.append('\'');
            textBuffer.append((Object)result);
            textBuffer.append('\'');
        }
    }

    private char[] getUCCodepoint(char c) {
        char[] res = new char[]{'\\', '0', '0', '0', '0'};
        String s = Integer.toHexString(c);
        int j = 4;
        int i = s.length() - 1;
        while (i >= 0 && j >= 1) {
            res[j] = s.charAt(i);
            --i;
            --j;
        }
        return res;
    }
}

