/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.tree;

import com.sap.sql.tree.HostVariableValues;
import com.sap.sql.tree.SQLVisitor;
import com.sap.sql.tree.SearchCondition;
import com.sap.sql.tree.SqlTextExpert;
import com.sap.sql.tree.ValueExpression;
import java.sql.ResultSet;
import java.sql.SQLException;

public class LikePredicate
extends SearchCondition {
    private ValueExpression matchValue;
    private ValueExpression patternValue;
    private ValueExpression escapeValue;
    private boolean notLike;

    public LikePredicate(ValueExpression aMatchValue, ValueExpression aPatternValue, ValueExpression anEscapeValue) {
        this.matchValue = aMatchValue;
        this.patternValue = aPatternValue;
        this.escapeValue = anEscapeValue;
    }

    public LikePredicate(ValueExpression aMatchValue, ValueExpression aPatternValue, ValueExpression anEscapeValue, boolean isNotLike) {
        this.matchValue = aMatchValue;
        this.patternValue = aPatternValue;
        this.escapeValue = anEscapeValue;
        this.notLike = isNotLike;
    }

    public void accept(SQLVisitor visitor) {
        visitor.visitLikePredicateBefore(this);
        if (this.matchValue != null) {
            this.matchValue.accept(visitor);
        }
        if (this.patternValue != null) {
            this.patternValue.accept(visitor);
        }
        if (this.escapeValue != null) {
            this.escapeValue.accept(visitor);
        }
        visitor.visitLikePredicate(this);
    }

    public ValueExpression getMatchValue() {
        return this.matchValue;
    }

    public ValueExpression getPatternValue() {
        return this.patternValue;
    }

    public ValueExpression getEscapeValue() {
        return this.escapeValue;
    }

    public boolean isNotLike() {
        return this.notLike;
    }

    public void toSqlTxt(SqlTextExpert expert, StringBuffer strBuf) {
        this.matchValue.toSqlTxt(expert, strBuf);
        if (this.notLike) {
            strBuf.append(" NOT");
        }
        strBuf.append(" LIKE ");
        this.patternValue.toSqlTxt(expert, strBuf);
        if (this.escapeValue != null) {
            strBuf.append(" ESCAPE ");
            this.escapeValue.toSqlTxt(expert, strBuf);
        }
    }

    public boolean evaluate(HostVariableValues values, ResultSet rs) throws SQLException {
        throw new SQLException("tmp");
    }

    public boolean supportsEvaluation() {
        return false;
    }
}

