/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.tree;

import com.sap.sql.tree.HostVariableValues;
import com.sap.sql.tree.RowValue;
import com.sap.sql.tree.SQLVisitor;
import com.sap.sql.tree.SearchCondition;
import com.sap.sql.tree.SqlTextExpert;
import java.sql.ResultSet;
import java.sql.SQLException;

public class BetweenPredicate
extends SearchCondition {
    private boolean notBetween = false;
    private RowValue value;
    private RowValue lowValue;
    private RowValue highValue;

    public BetweenPredicate(RowValue aValue, RowValue theLowValue, RowValue theHighValue) {
        this.value = aValue;
        this.lowValue = theLowValue;
        this.highValue = theHighValue;
    }

    public BetweenPredicate(RowValue aValue, RowValue theLowValue, RowValue theHighValue, boolean isNotBetween) {
        this.value = aValue;
        this.lowValue = theLowValue;
        this.highValue = theHighValue;
        this.notBetween = isNotBetween;
    }

    public void accept(SQLVisitor visitor) {
        visitor.visitBetweenPredicateBefore(this);
        if (this.value != null) {
            this.value.accept(visitor);
        }
        if (this.lowValue != null) {
            this.lowValue.accept(visitor);
        }
        if (this.highValue != null) {
            this.highValue.accept(visitor);
        }
        visitor.visitBetweenPredicate(this);
    }

    public RowValue getHighValue() {
        return this.highValue;
    }

    public RowValue getLowValue() {
        return this.lowValue;
    }

    public RowValue getValue() {
        return this.value;
    }

    public boolean isNotBetween() {
        return this.notBetween;
    }

    public void toSqlTxt(SqlTextExpert expert, StringBuffer strBuf) {
        this.value.toSqlTxt(expert, strBuf);
        if (this.notBetween) {
            strBuf.append(" NOT");
        }
        strBuf.append(" BETWEEN ");
        this.lowValue.toSqlTxt(expert, strBuf);
        strBuf.append(" AND ");
        this.highValue.toSqlTxt(expert, strBuf);
    }

    public boolean evaluate(HostVariableValues values, ResultSet rs) throws SQLException {
        throw new SQLException("tmp");
    }

    public boolean supportsEvaluation() {
        return false;
    }
}

