/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.trace;

import com.sap.sql.trace.TraceContext;
import java.util.Iterator;
import java.util.Set;

public class Utils {
    public static final String EOL = System.getProperty("line.separator");
    private static final String ADDINFO_B = "<add_info>";
    private static final String ADDINFO_E = "</add_info>";
    private static final String LINE_B = "<line>";
    private static final String LINE_E = "</line>";
    private static final String TABLES_B = "<tables>";
    private static final String TABLES_E = "</tables>";
    private static final String TABLE_B = "<table>";
    private static final String TABLE_E = "</table>";
    private static final String PROGRAM_B = "<program>";
    private static final String PROGRAM_E = "</program>";
    private static final String GENERATIONTIME_B = "<generation_time>";
    private static final String GENERATIONTIME_E = "</generation_time>";
    protected static char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String escape(String s) {
        StringBuffer buf = new StringBuffer(s);
        int len = s.length();
        int i = 0;
        while (i < len) {
            switch (buf.charAt(i)) {
                case '<': {
                    buf.replace(i, i + 1, "&lt;");
                    len += 3;
                    i += 3;
                    break;
                }
                case '>': {
                    buf.replace(i, i + 1, "&gt;");
                    len += 3;
                    i += 3;
                    break;
                }
                case '&': {
                    buf.replace(i, i + 1, "&amp;");
                    len += 4;
                    i += 4;
                    break;
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static String formatContext(TraceContext context) {
        long l;
        int i;
        String tmp;
        if (context == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("    <add_info>" + EOL);
        Set tabNameSet = context.getTableNames();
        if (tabNameSet != null && !tabNameSet.isEmpty()) {
            sb.append("      <tables>" + EOL);
            Iterator it = tabNameSet.iterator();
            while (it.hasNext()) {
                sb.append("        <table>" + Utils.escape((String)it.next()) + TABLE_E + EOL);
            }
            sb.append("      </tables>" + EOL);
        }
        if ((tmp = context.getProgramName()) != null || !"".equals(tmp)) {
            sb.append("      ");
            sb.append(PROGRAM_B);
            sb.append(Utils.escape(tmp));
            sb.append(PROGRAM_E + EOL);
        }
        if ((i = context.getLineNumber()) != -1 || i != 0) {
            sb.append("      ");
            sb.append(LINE_B);
            sb.append(Utils.escape("" + i));
            sb.append(LINE_E + EOL);
        }
        if ((l = context.getGenerationTimeMillis()) != -1L || l != 0L) {
            sb.append("      ");
            sb.append(GENERATIONTIME_B);
            sb.append(Utils.escape("" + l));
            sb.append(GENERATIONTIME_E + EOL);
        }
        sb.append("    </add_info>" + EOL);
        return sb.toString();
    }

    public static String ByteArrayToHexString(byte[] b, int maxLength) {
        if (b == null) {
            return "null";
        }
        boolean isTruncated = false;
        int length = b.length;
        if (length > maxLength) {
            length = maxLength;
            isTruncated = true;
        }
        StringBuffer sb = new StringBuffer(length * 2 + 3);
        int i = 0;
        while (i < length) {
            sb.append(hexChar[(b[i] & 0xF0) >>> 4]);
            sb.append(hexChar[b[i] & 0xF]);
            ++i;
        }
        if (isTruncated) {
            sb.append("...");
        }
        return sb.toString();
    }

    public static String processStackTrace(String stack) {
        if (stack == null) {
            return "null";
        }
        int pos = stack.lastIndexOf("com.sap.sql.jdbc.direct");
        if (pos == -1) {
            return stack;
        }
        if ((pos = (stack = stack.substring(pos)).indexOf("\t")) == -1 && (pos = stack.indexOf(EOL)) == -1) {
            return stack;
        }
        stack = stack.substring(pos + 1);
        stack = stack.trim();
        return stack;
    }
}

