/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.trace;

import com.sap.sql.log.Syslog;
import com.sap.sql.trace.Format;
import com.sap.sql.trace.SQLTrace;
import com.sap.sql.trace.SQLTraceLogRecord;
import com.sap.sql.trace.SQLTraceParser;
import com.sap.sql.trace.TraceContext;
import com.sap.sql.trace.Utils;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.LogRecord;
import com.sap.tc.logging.XMLFormatter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class SQLTraceXMLFormatter
extends XMLFormatter {
    private static final String EOL = System.getProperty("line.separator");
    private static final int INITIAL_CAPACITY = 512;
    private static Location TRACE = Location.getLocation((Class)(class$com$sap$sql$trace$SQLTraceXMLFormatter == null ? (class$com$sap$sql$trace$SQLTraceXMLFormatter = SQLTraceXMLFormatter.class$("com.sap.sql.trace.SQLTraceXMLFormatter")) : class$com$sap$sql$trace$SQLTraceXMLFormatter));
    private static Category SYSLOG = Syslog.getLogger(class$com$sap$sql$trace$SQLTraceXMLFormatter == null ? (class$com$sap$sql$trace$SQLTraceXMLFormatter = SQLTraceXMLFormatter.class$("com.sap.sql.trace.SQLTraceXMLFormatter")) : class$com$sap$sql$trace$SQLTraceXMLFormatter);
    private String CONTEXT_CLASS_NAME = "com.sap.sql.trace.TraceContext";
    static /* synthetic */ Class class$com$sap$sql$trace$SQLTraceXMLFormatter;

    public synchronized String format(LogRecord rec) {
        StringBuffer res = new StringBuffer(512);
        StringBuffer esc = new StringBuffer();
        res.append("  <record>");
        res.append(EOL);
        res.append("    <id>");
        res.append(rec.getId());
        res.append("</id>");
        res.append(EOL);
        res.append("    <thread>");
        res.append((Object)this.escape(rec.getThreadName(), esc));
        res.append("</thread>");
        res.append(EOL);
        if (rec.getUser() != null && !rec.getUser().equals("")) {
            res.append("    <user>");
            res.append((Object)this.escape(rec.getUser(), esc));
            res.append("</user>");
            res.append(EOL);
        }
        if (rec.getDsrTransaction() != null && !rec.getDsrTransaction().equals("")) {
            res.append("    <dsrtransaction>");
            res.append((Object)this.escape(rec.getDsrTransaction(), esc));
            res.append("</dsrtransaction>");
            res.append(EOL);
        }
        if (rec.getSession() != null && !rec.getSession().equals("")) {
            res.append("    <session>");
            res.append((Object)this.escape(rec.getSession(), esc));
            res.append("</session>");
            res.append(EOL);
        }
        if (rec.getTransaction() != null && !rec.getTransaction().equals("")) {
            res.append("    <transaction>");
            res.append((Object)this.escape(rec.getTransaction(), esc));
            res.append("</transaction>");
            res.append(EOL);
        }
        if (rec.getApplication() != null && !rec.getApplication().equals("")) {
            res.append("    <application>");
            res.append((Object)this.escape(rec.getApplication(), esc));
            res.append("</application>");
            res.append(EOL);
        }
        if (rec.getMsgClear() != null) {
            res.append("    <msg-clear>");
            res.append((Object)this.escape(rec.getMsgClear(), esc));
            res.append("</msg-clear>");
            res.append(EOL);
        }
        switch (rec.getMsgType()) {
            case 0: {
                break;
            }
            case 1: {
                List args = rec.getArgObjs();
                if (args == null || args.size() <= 0) break;
                int i = 0;
                while (i < args.size()) {
                    Object arg = args.get(i);
                    if (arg != null) {
                        if (arg instanceof Format) {
                            res.append(((Format)arg).toXML());
                        } else if (arg instanceof TraceContext) {
                            res.append(Utils.formatContext((TraceContext)arg));
                        } else {
                            String sTmp = arg.getClass().getName();
                            if (sTmp.indexOf(this.CONTEXT_CLASS_NAME) != -1) {
                                res.append(Utils.formatContext((TraceContext)arg));
                            } else {
                                sTmp = this.callToXML(arg);
                                if (sTmp != null) {
                                    res.append(sTmp);
                                } else {
                                    SYSLOG.warningT(TRACE, "Don't know how to format " + arg + ".");
                                }
                            }
                        }
                    }
                    ++i;
                }
                break;
            }
        }
        res.append("  </record>");
        res.append(EOL);
        return res.toString();
    }

    public String getHeader(Log log) {
        String enc = log.getEncoding();
        String clusterId = SQLTrace.getClusterId();
        String res = "<?xml version=\"1.0\"";
        if (enc != null) {
            res = res + " encoding=\"" + enc + "\"";
        }
        res = res + "?>" + EOL + EOL + "<log";
        if (clusterId != null) {
            res = res + " clusterId=\"" + clusterId + "\"";
        }
        res = res + ">" + EOL;
        return res;
    }

    public String getFooter(Log log) {
        return "</log>" + EOL;
    }

    public boolean isParsable() {
        return true;
    }

    public boolean isStartMessage(String msg) {
        return (msg = msg.trim()).startsWith("<record>");
    }

    public boolean isCompleteMessage(String msg) {
        return (msg = msg.trim()).endsWith("</record>");
    }

    public LogRecord parseMsg(String completeMsgData) {
        SQLTraceLogRecord rec = null;
        if (completeMsgData == null) {
            return null;
        }
        Map recMap = SQLTraceParser.parseFromString(completeMsgData);
        Date date = null;
        String id = (String)recMap.get("id");
        String tmp = (String)recMap.get("starttime");
        if (tmp == null) {
            SYSLOG.errorT(TRACE, "No starttime found for trace is " + id + ".");
        } else {
            try {
                Long lDate = new Long(tmp);
                date = new Date(lDate);
            }
            catch (NumberFormatException e) {
                SYSLOG.errorT(TRACE, "Can not convert date '" + tmp + "' into Long " + "for trace id" + id + ".");
                TRACE.catching((Throwable)e);
            }
        }
        long duration = -1L;
        tmp = (String)recMap.get("duration");
        if (tmp == null) {
            SYSLOG.errorT(TRACE, "No duration found for trace is " + id + ".");
        } else {
            try {
                duration = new Long(tmp);
            }
            catch (NumberFormatException e) {
                SYSLOG.errorT(TRACE, "Can not convert duration '" + tmp + "' into Long " + "for trace id" + id + ".");
                TRACE.catching((Throwable)e);
            }
        }
        int varsPerBatch = 0;
        tmp = (String)recMap.get("vars_per_batch");
        if (tmp != null) {
            try {
                varsPerBatch = new Integer(tmp);
            }
            catch (NumberFormatException e) {
                SYSLOG.errorT(TRACE, "Can not convert duration '" + tmp + "' into Long " + "for trace id" + id + ".");
                TRACE.catching((Throwable)e);
            }
        }
        List lTmp = (List)recMap.get("in");
        String inParams = null;
        if (lTmp != null) {
            inParams = lTmp.toString();
        }
        rec = new SQLTraceLogRecord(id, date, (String)recMap.get("location"), (String)recMap.get("thread"), (String)recMap.get("msg-clear"), (String)recMap.get("application"), (String)recMap.get("user"), (String)recMap.get("session"), (String)recMap.get("transaction"), duration, (String)recMap.get("dbid"), inParams, (ArrayList)recMap.get("param"), (String)recMap.get("result"), (String)recMap.get("rsid"), (String)recMap.get("pstmtid"), (String)recMap.get("errcode"), (String)recMap.get("sqlstate"), varsPerBatch, (ArrayList)recMap.get("table"), (String)recMap.get("program"), (String)recMap.get("line"), (String)recMap.get("generation_time"), (String)recMap.get("dsrtransaction"));
        return rec;
    }

    private String callToXML(Object o) {
        Class<?> clazz = o.getClass();
        try {
            Method m = clazz.getMethod("toXML", null);
            return (String)m.invoke(o, null);
        }
        catch (Exception e) {
            TRACE.catching((Throwable)e);
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

