/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.trace;

import com.sap.sql.jdbc.ContextFactory;
import com.sap.sql.jdbc.VMContext;
import com.sap.sql.log.Syslog;
import com.sap.sql.trace.OnlySqlTraceFiles;
import com.sap.sql.trace.SQLTraceXMLFormatter;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import java.io.File;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;

public class SQLTrace {
    public static final String EXCEPTION = "SQL_EXCEPTION";
    public static String traceFilePath = "./log/sqltrace/";
    public static final String className = "com.sap.sql.trace.SQLTrace";
    public static final String LOGGER_NAME = "SQLTraceLogger";
    public static final Location sqlTraceLogger = Location.getLocation((String)"SQLTraceLogger");
    private static final int MIN_SIZE = 10000;
    private static final int MAX_SIZE = 1000000000;
    private static final int MIN_FILES = 5;
    private static final int MAX_FILES = 1000;
    private static final String SAT_LOG_NAME = "SAT_SQLTRACE_FILELOG";
    private static final String SAT_LOG_DESCRIPTION = "SQLTrace Log File for Single Activity Trace Records";
    private static final String LOG_NAME = "SQLTRACE_FILELOG";
    private static final String LOG_DESCRIPTION = "SQLTrace Log File";
    private static final String OLD_LOG_NAME = "OLD_SQLTRACE_FILELOG";
    private static final String OLD_LOG_DESCRIPTION = "SQLTrace Log File for Traces taken before last restart.";
    private static FileLog satFileLog = null;
    private static final Category SYSLOG = Syslog.getLogger(class$com$sap$sql$trace$SQLTrace == null ? (class$com$sap$sql$trace$SQLTrace = SQLTrace.class$("com.sap.sql.trace.SQLTrace")) : class$com$sap$sql$trace$SQLTrace);
    private static final Location TRACE = Location.getLocation((String)"com.sap.sql.trace.SQLTrace");
    private static Date lastOn = null;
    private static Date lastOff = null;
    private static String lastPrefix;
    private static String clusterId;
    private static int nrFilePerTrace;
    private static int sizeLimit;
    private static SimpleDateFormat dateFormatter;
    private static String filePattern;
    private static SQLTraceXMLFormatter formatter;
    static final String FILSEP;
    private static boolean isStackTrace;
    private static String methodPattern;
    private static int stacktraceThreshold;
    private static final String SATPREFIX = "sat_sqltrace";
    private static final String SATPATTERN = "sat_sqltrace.%g.xml";
    static /* synthetic */ Class class$com$sap$sql$trace$SQLTrace;

    private SQLTrace() {
        TRACE.pathT("Entering constructor SQLTrace()");
        SQLTrace.getLogger().setEffectiveSeverity(701);
        TRACE.pathT("Leaving constructor SQLTrace()");
    }

    public static Location getLogger() {
        return sqlTraceLogger;
    }

    public static String getLoggerName() {
        return LOGGER_NAME;
    }

    public static void setFilePattern(String filePattern) {
        TRACE.pathT("Entering setFilePattern(" + filePattern + ").");
        SQLTrace.filePattern = filePattern;
        TRACE.pathT("Leaving setFilePattern(" + filePattern + ").");
    }

    public static void on() {
        TRACE.pathT("Entering SQLTrace.on()");
        lastOn = new Date();
        SQLTrace.getLogger().removeLogs();
        SQLTrace.getLogger().setEffectiveSeverity(200);
        SQLTrace.getLogger().addLog((Log)new FileLog(filePattern, (Formatter)formatter));
        TRACE.pathT("Leaving SQLTrace.on()");
    }

    public static String onJ2ee() {
        TRACE.pathT("Entering onJ2ee().");
        lastOn = new Date();
        String prefix = dateFormatter.format(lastOn);
        String filePattern = traceFilePath + prefix + ".%g.xml";
        SQLTrace.getLogger().setEffectiveSeverity(200);
        FileLog log = new FileLog(filePattern, sizeLimit, nrFilePerTrace, (Formatter)formatter);
        log.setName(LOG_NAME);
        log.setDescription(LOG_DESCRIPTION);
        SQLTrace.getLogger().addLog((Log)log);
        lastPrefix = prefix;
        TRACE.debugT("Prefix is: " + prefix);
        TRACE.debugT("traceFilePath is " + traceFilePath);
        TRACE.pathT("Exiting onJ2ee().");
        return prefix;
    }

    public static String onJ2eeWithStackTrace(String methodPattern, int stacktraceThreshold) {
        TRACE.pathT("Entering SQLTrace.onJ2eeWithStackTrace(" + methodPattern + "," + stacktraceThreshold + ")");
        isStackTrace = true;
        SQLTrace.methodPattern = methodPattern;
        if (stacktraceThreshold > 0) {
            SQLTrace.stacktraceThreshold = stacktraceThreshold;
        }
        return SQLTrace.onJ2ee();
    }

    public static void off() {
        TRACE.pathT("Entering off().");
        isStackTrace = false;
        methodPattern = null;
        stacktraceThreshold = 0;
        lastOff = new Date();
        SQLTrace.getLogger().setEffectiveSeverity(701);
        SQLTrace.closeAndFlushLogs();
        TRACE.pathT("Exiting off()");
    }

    public static boolean isOn() {
        return SQLTrace.getLogger().bePath();
    }

    public static Date getLastOn() {
        return lastOn;
    }

    public static Date getLastOff() {
        return lastOff;
    }

    public static String getLastPrefix() {
        return lastPrefix;
    }

    public static void setClusterId(String clusterId) {
        SQLTrace.clusterId = clusterId;
    }

    public static String getClusterId() {
        return clusterId;
    }

    public static boolean getIsStackTrace() {
        return isStackTrace;
    }

    public static String getMethodPattern() {
        return methodPattern;
    }

    public static int getStacktraceThreshold() {
        return stacktraceThreshold;
    }

    public static void registerOldLogs() {
        TRACE.pathT("Entering registerOldLogs().");
        String[] fileNames = null;
        TRACE.debugT("TaceFilePath is: " + traceFilePath);
        try {
            fileNames = new File(traceFilePath).list(new OnlySqlTraceFiles(true));
        }
        catch (Exception e) {
            SYSLOG.logThrowableT(300, TRACE, "Could not create File object for SQLTrace files in" + traceFilePath, (Throwable)e);
            return;
        }
        if (fileNames == null) {
            return;
        }
        if (!traceFilePath.endsWith(FILSEP)) {
            traceFilePath = traceFilePath + FILSEP;
        }
        int i = 0;
        while (i < fileNames.length) {
            String prefix = fileNames[i].substring(0, fileNames[i].indexOf(46));
            TRACE.debugT("Processing prefix: " + prefix + ".");
            String fileToAdd = traceFilePath + prefix + ".%g.xml";
            FileLog log = new FileLog(fileToAdd, sizeLimit, nrFilePerTrace, (Formatter)formatter);
            log.setName(OLD_LOG_NAME);
            log.setDescription(OLD_LOG_DESCRIPTION);
            SQLTrace.getLogger().addLog((Log)log);
            TRACE.debugT("Added log " + fileToAdd);
            log.close();
            TRACE.debugT("Closed log " + fileToAdd);
            SQLTrace.getLogger().removeLog((Log)log);
            TRACE.debugT("Removed log " + fileToAdd);
            ++i;
        }
        TRACE.pathT("Exiting registerOldLogs().");
    }

    public static String getSATPrefix() {
        return SATPREFIX;
    }

    public static FileLog setUpSAT() {
        if (satFileLog != null) {
            return satFileLog;
        }
        String filePattern = traceFilePath + SATPATTERN;
        satFileLog = new FileLog(filePattern, sizeLimit, nrFilePerTrace, (Formatter)formatter);
        satFileLog.setName(SAT_LOG_NAME);
        satFileLog.setDescription(SAT_LOG_DESCRIPTION);
        SQLTrace.getLogger().addLog((Log)satFileLog);
        return satFileLog;
    }

    public static void removeSATFileLog() {
        Iterator it = SQLTrace.getLogger().getLogs().iterator();
        while (it.hasNext()) {
            Log log = (Log)it.next();
            if (log.getName() == null || !SAT_LOG_NAME.equalsIgnoreCase(log.getName())) continue;
            log.flush();
            log.close();
            SQLTrace.getLogger().removeLog(log);
            satFileLog = null;
            TRACE.debugT("Log " + log.getName() + " flushed and closed.");
        }
    }

    public static FileLog getSATFileLog() {
        return satFileLog;
    }

    public static void setDefaultsFromProperties(Properties p) {
        int i;
        String sTmp;
        Properties props;
        TRACE.infoT("Entering setDefaultsFromProperties()");
        if (p == null) {
            try {
                props = ContextFactory.mergeProperties(null);
            }
            catch (SQLException e) {
                Syslog.logSQLException(class$com$sap$sql$trace$SQLTrace == null ? (class$com$sap$sql$trace$SQLTrace = SQLTrace.class$(className)) : class$com$sap$sql$trace$SQLTrace, e, null);
                return;
            }
        } else {
            props = p;
        }
        if ((sTmp = props.getProperty("com.sap.sql.trace.j2ee.tracefilepath")) != null) {
            traceFilePath = sTmp.trim();
        }
        sTmp = props.getProperty("com.sap.sql.trace.j2ee.cnt");
        TRACE.infoT("com.sap.sql.trace.j2ee.cnt is" + sTmp);
        if (sTmp != null) {
            try {
                i = new Integer(sTmp.trim());
                nrFilePerTrace = i >= 5 && i <= 1000 ? i : (i > 1000 ? 1000 : 5);
            }
            catch (NumberFormatException e) {
                SYSLOG.infoT(TRACE, "com.sap.sql.trace.j2ee.cnt: Can not convert " + sTmp + " to int.");
                TRACE.catching((Throwable)e);
            }
        }
        sTmp = props.getProperty("com.sap.sql.trace.j2ee.limit");
        TRACE.infoT("com.sap.sql.trace.j2ee.limit is" + sTmp);
        if (sTmp != null) {
            try {
                i = new Integer(sTmp.trim());
                sizeLimit = i >= 10000 && i <= 1000000000 ? i : (i < 10000 ? 10000 : 1000000000);
            }
            catch (NumberFormatException e) {
                SYSLOG.infoT(TRACE, "com.sap.sql.trace.j2ee.limit: Can not convert " + sTmp + " to int.");
                TRACE.catching((Throwable)e);
            }
        }
        if ((sTmp = props.getProperty("com.sap.sql.trace.standalone.filename")) != null) {
            filePattern = sTmp.trim();
        }
        if (SQLTrace.isStandalone() && (sTmp = props.getProperty("com.sap.sql.trace.active_on_startup")) != null) {
            sTmp = sTmp.trim();
            TRACE.infoT("com.sap.sql.trace.active_on_startup is " + sTmp);
            if (sTmp.equals("true")) {
                SQLTrace.on();
            }
        }
        TRACE.infoT("Exiting setDefaultsFromProperties()");
    }

    private static void closeAndFlushLogs() {
        TRACE.pathT("Entering closeAndFlushLogs()");
        Iterator it = SQLTrace.getLogger().getLogs().iterator();
        while (it.hasNext()) {
            Log log = (Log)it.next();
            if (log.getName() == null || SAT_LOG_NAME.equalsIgnoreCase(log.getName())) continue;
            log.flush();
            log.close();
            SQLTrace.getLogger().removeLog(log);
            TRACE.debugT("Log " + log.getName() + " flushed and closed.");
        }
        TRACE.pathT("Exiting closeAndFlushLogs()");
    }

    private static boolean isStandalone() {
        return !VMContext.isJ2EEServerActive();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        clusterId = null;
        nrFilePerTrace = 10;
        sizeLimit = 10000000;
        dateFormatter = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        filePattern = "sqltrace.xml";
        formatter = new SQLTraceXMLFormatter();
        FILSEP = System.getProperty("file.separator");
        isStackTrace = false;
        methodPattern = null;
        stacktraceThreshold = 0;
        SQLTrace.setDefaultsFromProperties(null);
    }
}

