/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.tablebuffer;

import com.sap.sql.buffer.BufferAccess;
import com.sap.sql.buffer.BufferRecord;
import com.sap.sql.sync.SyncRecordInputStream;
import com.sap.sql.sync.SyncRecordOutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

public class BufferSyncRecord
extends SyncRecordOutputStream {
    public static final short ACTION_INVALIDATE = 1;
    public static final short ACTION_REMOVE = 2;
    private static final byte TYPE_BYTE = 1;
    private static final byte TYPE_SHORT = 2;
    private static final byte TYPE_INTEGER = 3;
    private static final byte TYPE_LONG = 4;
    private static final byte TYPE_FLOAT = 5;
    private static final byte TYPE_DOUBLE = 6;
    private static final byte TYPE_BIGINTEGER = 7;
    private static final byte TYPE_BIGDECIMAL = 8;
    private static final byte TYPE_BOOLEAN = 9;
    private static final byte TYPE_CHARACTER = 10;
    private static final byte TYPE_STRING = 11;
    private static final byte TYPE_DATE = 12;
    private static final byte TYPE_TIME = 13;
    private static final byte TYPE_TIMESTAMP = 14;
    private short action;
    private String tableName = null;
    private BufferRecord bufferKey = null;

    private BufferSyncRecord(SyncRecordInputStream in, BufferAccess access) throws SQLException {
        this.action = in.readShort();
        this.tableName = in.readString();
        if (this.action == 1) {
            int keyCount = in.readShort();
            this.bufferKey = keyCount > 0 ? access.getBufferKey(keyCount) : null;
            int i = 1;
            while (i <= keyCount) {
                byte type = in.readByte();
                switch (type) {
                    case 1: {
                        this.bufferKey.setByte(i, new Byte(in.readByte()));
                        break;
                    }
                    case 2: {
                        this.bufferKey.setShort(i, new Short(in.readShort()));
                        break;
                    }
                    case 3: {
                        this.bufferKey.setInteger(i, new Integer(in.readInt()));
                        break;
                    }
                    case 4: {
                        this.bufferKey.setLong(i, new Long(in.readLong()));
                        break;
                    }
                    case 5: {
                        this.bufferKey.setFloat(i, new Float(in.readFloat()));
                        break;
                    }
                    case 6: {
                        this.bufferKey.setDouble(i, new Double(in.readDouble()));
                        break;
                    }
                    case 7: {
                        this.bufferKey.setBigInteger(i, new BigInteger(in.readString()));
                        break;
                    }
                    case 8: {
                        this.bufferKey.setBigDecimal(i, new BigDecimal(in.readString()));
                        break;
                    }
                    case 9: {
                        this.bufferKey.setBoolean(i, new Boolean(in.readBoolean()));
                        break;
                    }
                    case 10: {
                        this.bufferKey.setCharacter(i, new Character(in.readChar()));
                        break;
                    }
                    case 11: {
                        this.bufferKey.setString(i, in.readString());
                        break;
                    }
                    case 12: {
                        this.bufferKey.setDate(i, new java.sql.Date(in.readLong()));
                        break;
                    }
                    case 13: {
                        this.bufferKey.setTime(i, new Time(in.readLong()));
                        break;
                    }
                    case 14: {
                        this.bufferKey.setTimestamp(i, new Timestamp(in.readLong()));
                    }
                }
                ++i;
            }
        }
        in.close();
    }

    public static SyncRecordOutputStream writeInvalidateSyncRecord(String tableName, BufferRecord bufferKey) throws SQLException {
        SyncRecordOutputStream out = new SyncRecordOutputStream();
        out.writeShort((short)1);
        out.writeString(tableName);
        int keyCount = bufferKey != null ? bufferKey.getValueCount() : 0;
        out.writeShort((short)keyCount);
        int i = 1;
        while (i <= keyCount) {
            Object obj = bufferKey.getValue(i);
            if (obj instanceof Number) {
                if (obj instanceof Byte) {
                    out.writeByte((byte)1);
                    out.writeByte((Byte)obj);
                } else if (obj instanceof Short) {
                    out.writeByte((byte)2);
                    out.writeShort((Short)obj);
                } else if (obj instanceof Integer) {
                    out.writeByte((byte)3);
                    out.writeInt((Integer)obj);
                } else if (obj instanceof Long) {
                    out.writeByte((byte)4);
                    out.writeLong((Long)obj);
                } else if (obj instanceof Float) {
                    out.writeByte((byte)5);
                    out.writeFloat(((Float)obj).floatValue());
                } else if (obj instanceof Double) {
                    out.writeByte((byte)6);
                    out.writeDouble((Double)obj);
                } else if (obj instanceof BigInteger) {
                    out.writeByte((byte)7);
                    out.writeString(((BigInteger)obj).toString());
                } else if (obj instanceof BigDecimal) {
                    out.writeByte((byte)8);
                    out.writeString(((BigDecimal)obj).toString());
                }
            } else if (obj instanceof Boolean) {
                out.writeByte((byte)9);
                out.writeBoolean((Boolean)obj);
            } else if (obj instanceof Character) {
                out.writeByte((byte)10);
                out.writeChar(((Character)obj).charValue());
            } else if (obj instanceof String) {
                out.writeByte((byte)11);
                out.writeString((String)obj);
            } else if (obj instanceof java.sql.Date) {
                out.writeByte((byte)12);
                out.writeLong(((java.sql.Date)obj).getTime());
            } else if (obj instanceof Time) {
                out.writeByte((byte)13);
                out.writeLong(((Time)obj).getTime());
            } else if (obj instanceof Timestamp) {
                out.writeByte((byte)14);
                out.writeLong(((Date)((Timestamp)obj)).getTime());
            }
            ++i;
        }
        return out;
    }

    public static SyncRecordOutputStream writeRemoveSyncRecord(String tableName) throws SQLException {
        SyncRecordOutputStream out = new SyncRecordOutputStream();
        out.writeShort((short)2);
        out.writeString(tableName);
        return out;
    }

    public static BufferSyncRecord readSyncRecord(SyncRecordInputStream in, BufferAccess access) throws SQLException {
        return new BufferSyncRecord(in, access);
    }

    public short getAction() {
        return this.action;
    }

    public String getTableName() {
        return this.tableName;
    }

    public BufferRecord getBufferKey() {
        return this.bufferKey;
    }
}

