/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.tablebuffer;

import com.sap.sql.buffer.BufferAccess;
import com.sap.sql.buffer.BufferException;
import com.sap.sql.buffer.BufferLoadAccess;
import com.sap.sql.buffer.BufferNotAvailableException;
import com.sap.sql.buffer.BufferRecord;
import com.sap.sql.buffer.BufferRecordProcessor;
import com.sap.sql.buffer.BufferResetException;
import com.sap.sql.buffer.DataLockedException;
import com.sap.sql.buffer.IllegalArgumentException;
import com.sap.sql.buffer.ObjectExistsException;
import com.sap.sql.buffer.ObjectNotDefinedException;
import com.sap.sql.buffer.RecordNotFoundException;
import com.sap.sql.catalog.Column;
import com.sap.sql.catalog.Table;
import com.sap.sql.jdbc.ExtendedStatement;
import com.sap.sql.jdbc.common.AbstractCommonStatement;
import com.sap.sql.jdbc.common.CommonConnectionImpl;
import com.sap.sql.jdbc.common.UTCCalendar;
import com.sap.sql.log.Syslog;
import com.sap.sql.sync.SyncRecordOutputStream;
import com.sap.sql.sync.SyncWriter;
import com.sap.sql.tablebuffer.BufferCommonStatement;
import com.sap.sql.tablebuffer.BufferConnectionContext;
import com.sap.sql.tablebuffer.BufferHostVars;
import com.sap.sql.tablebuffer.BufferManager;
import com.sap.sql.tablebuffer.BufferStatementInfo;
import com.sap.sql.tablebuffer.BufferSyncRecord;
import com.sap.sql.tablebuffer.TableBufferException;
import com.sap.sql.tablebuffer.TableBufferLOBException;
import com.sap.sql.tablebuffer.TableBufferRTIllegalArgumentException;
import com.sap.sql.tablebuffer.TableBufferRecordProcessor;
import com.sap.sql.tablebuffer.TableBufferUnsupportedMethodException;
import com.sap.sql.trace.TraceContext;
import com.sap.sql.types.CommonTypes;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Timestamp;

public class BufferStatement
implements ExtendedStatement {
    protected static final TableBufferAccessException accessException = new TableBufferAccessException();
    private static final BufferRecordProcessor proc = new TableBufferRecordProcessor();
    protected BufferConnectionContext connectionContext;
    protected Connection connection;
    protected BufferManager bufferManager;
    protected SyncWriter syncWriter;
    protected String syncID;
    protected int vendorID;
    protected BufferAccess access;
    protected BufferStatementInfo stmtInfo;
    protected int stmtType;
    protected Table table;
    protected String tableName;
    protected boolean bufferModify;
    protected int bufferKeyCnt;
    protected BufferRecordProcessor recordProcessor;
    protected ResultSet resultSet;
    protected int updateCount;
    protected int maxRows = 0;
    private BufferCommonStatement commonStmt;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$sql$Clob;
    static /* synthetic */ Class class$java$sql$Blob;

    BufferStatement(BufferConnectionContext connectionContext, BufferAccess access, BufferStatementInfo stmtInfo) {
        this(connectionContext, access, stmtInfo, null);
    }

    BufferStatement(BufferConnectionContext connectionContext, BufferAccess access, BufferStatementInfo stmtInfo, BufferCommonStatement commonStmt) {
        this.connectionContext = connectionContext;
        this.connection = connectionContext.getWrappedConnection();
        this.bufferManager = connectionContext.getBufferManager();
        this.syncWriter = connectionContext.getSyncWriter();
        this.syncID = connectionContext.getBufferSyncID();
        this.vendorID = connectionContext.getVendorID();
        this.access = access;
        this.stmtInfo = stmtInfo;
        this.commonStmt = commonStmt;
        this.table = stmtInfo.getTable();
        this.stmtType = stmtInfo.getStatementType();
        this.bufferModify = stmtInfo.getBufferModify();
        this.bufferKeyCnt = this.table.getBufferKeyCnt();
        this.tableName = this.table.getName().toUpperCase();
        this.resultSet = null;
        this.updateCount = -1;
    }

    public ResultSet executeQuery(String sql, TraceContext traceContext) throws SQLException {
        if (null == this.recordProcessor) {
            this.recordProcessor = new TableBufferRecordProcessor(this.stmtInfo.getQuerySpecification(), null, this.stmtInfo);
        }
        try {
            BufferRecord bufferKey = this.stmtInfo.getBufferKey(this.access, null);
            this.resultSet = this.bufferSelect(bufferKey);
            if (this.resultSet == null) {
                this.bufferLoad(bufferKey, null);
                this.resultSet = this.bufferSelect(bufferKey);
            }
        }
        catch (TableBufferAccessException ex) {
            this.resultSet = this.getNativeStmt().executeQuery(this.getStmtString(), traceContext);
        }
        return this.resultSet;
    }

    public int executeUpdate(String sql, TraceContext traceContext) throws SQLException {
        this.updateCount = 0;
        this.updateCount = this.getNativeStmt().executeUpdate(this.getStmtString(), traceContext);
        switch (this.stmtType) {
            case 1: {
                this.bufferDelete(null);
                break;
            }
            case 2: {
                this.bufferInsert(null);
                break;
            }
            case 3: {
                this.bufferUpdate(null);
            }
        }
        return this.updateCount;
    }

    public boolean execute(String sql, TraceContext traceContext) throws SQLException {
        if (this.stmtType == 0) {
            this.executeQuery(sql, traceContext);
            return true;
        }
        this.executeUpdate(sql, traceContext);
        return false;
    }

    public void prepareResultSet(Object[] resultSetColumns) throws SQLException {
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        return this.executeQuery(sql, null);
    }

    public int executeUpdate(String sql) throws SQLException {
        return this.executeUpdate(sql, (TraceContext)null);
    }

    public boolean execute(String sql) throws SQLException {
        return this.execute(sql, (TraceContext)null);
    }

    public void close() throws SQLException {
        try {
            if (this.resultSet != null) {
                this.resultSet.close();
            }
            Object var2_1 = null;
            this.access = null;
            this.bufferManager = null;
            this.commonStmt = null;
            this.connection = null;
            this.connectionContext = null;
            this.recordProcessor = null;
            this.stmtInfo = null;
            this.syncID = null;
            this.syncWriter = null;
            this.table = null;
            this.tableName = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.access = null;
            this.bufferManager = null;
            this.commonStmt = null;
            this.connection = null;
            this.connectionContext = null;
            this.recordProcessor = null;
            this.stmtInfo = null;
            this.syncID = null;
            this.syncWriter = null;
            this.table = null;
            this.tableName = null;
            throw throwable;
        }
    }

    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    public void setMaxFieldSize(int max) throws SQLException {
        throw TableBufferUnsupportedMethodException.getAndLog(this.getClass(), "setMaxFieldSize(int)");
    }

    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    public void setMaxRows(int max) throws SQLException {
        this.maxRows = max;
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        throw TableBufferUnsupportedMethodException.getAndLog(this.getClass(), "setEscapeProcessing(boolean enable)");
    }

    public int getQueryTimeout() throws SQLException {
        throw TableBufferUnsupportedMethodException.getAndLog(this.getClass(), "getQueryTimeout()");
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        throw TableBufferUnsupportedMethodException.getAndLog(this.getClass(), "setQueryTimeout(int seconds)");
    }

    public void cancel() throws SQLException {
        throw TableBufferUnsupportedMethodException.getAndLog(this.getClass(), "cancel()");
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
    }

    public void setCursorName(String name) throws SQLException {
        throw TableBufferUnsupportedMethodException.getAndLog(this.getClass(), "setCursorName(String name)");
    }

    public ResultSet getResultSet() throws SQLException {
        return this.resultSet;
    }

    public int getUpdateCount() throws SQLException {
        return this.updateCount;
    }

    public boolean getMoreResults() throws SQLException {
        throw TableBufferUnsupportedMethodException.getAndLog(this.getClass(), "getMoreResults()");
    }

    public void setFetchDirection(int direction) throws SQLException {
        throw TableBufferUnsupportedMethodException.getAndLog(this.getClass(), "setFetchDirection(int)");
    }

    public int getFetchDirection() throws SQLException {
        throw TableBufferUnsupportedMethodException.getAndLog(this.getClass(), "getFetchDirection()");
    }

    public void setFetchSize(int rows) throws SQLException {
        throw TableBufferUnsupportedMethodException.getAndLog(this.getClass(), "setFetchSize(int)");
    }

    public int getFetchSize() throws SQLException {
        throw TableBufferUnsupportedMethodException.getAndLog(this.getClass(), "getFetchSize()");
    }

    public int getResultSetConcurrency() throws SQLException {
        throw TableBufferUnsupportedMethodException.getAndLog(this.getClass(), "getResultSetConcurrency()");
    }

    public int getResultSetType() throws SQLException {
        throw TableBufferUnsupportedMethodException.getAndLog(this.getClass(), "getResultSetType()");
    }

    public void addBatch(String sql) throws SQLException {
        throw TableBufferUnsupportedMethodException.getAndLog(this.getClass(), "addBatch(String)");
    }

    public void clearBatch() throws SQLException {
        throw TableBufferUnsupportedMethodException.getAndLog(this.getClass(), "clearBatch()");
    }

    public int[] executeBatch() throws SQLException {
        throw TableBufferUnsupportedMethodException.getAndLog(this.getClass(), "executeBatch()");
    }

    public Connection getConnection() throws SQLException {
        throw TableBufferUnsupportedMethodException.getAndLog(this.getClass(), "getConnection()");
    }

    void setBufferStatementInfo(BufferStatementInfo stmtInfo) {
        this.stmtInfo = stmtInfo;
        this.table = stmtInfo.getTable();
        this.stmtType = stmtInfo.getStatementType();
        this.bufferModify = stmtInfo.getBufferModify();
        this.bufferKeyCnt = this.table.getBufferKeyCnt();
        this.tableName = this.table.getName().toUpperCase();
        if (this.stmtType == 0) {
            this.recordProcessor = new TableBufferRecordProcessor(stmtInfo.getQuerySpecification(), null, stmtInfo);
        }
        this.resultSet = null;
        this.updateCount = -1;
    }

    void setBufferKeyCnt(int bufferKeyCnt) {
        this.bufferKeyCnt = bufferKeyCnt;
    }

    ResultSet bufferSelect(BufferRecord bufferKey) throws TableBufferAccessException {
        try {
            return this.access.getResultSet(this.tableName, bufferKey, this.recordProcessor, this.maxRows);
        }
        catch (ObjectNotDefinedException ex) {
            try {
                this.bufferDefine();
            }
            catch (BufferException e) {
                Syslog.createAndLogOpenSQLException(this, "com.sap.sql.tablebuffer_1204", null, (Throwable)e);
                throw accessException;
            }
            return null;
        }
        catch (BufferException ex) {
            throw accessException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void bufferLoad(BufferRecord bufferKey, BufferHostVars hostVals) throws SQLException {
        int isolationLevel = -1;
        String stmtTxt = null;
        Statement loadStmt = null;
        ResultSet rs = null;
        if (this.vendorID != 1) {
            isolationLevel = this.connection.getTransactionIsolation();
            this.connection.setTransactionIsolation(2);
        }
        try {
            block26: {
                try {
                    StringBuffer order = null;
                    StringBuffer stmt = new StringBuffer().append("SELECT * FROM ").append(this.tableName);
                    int i = 1;
                    while (i <= this.bufferKeyCnt) {
                        if (i == 1) {
                            stmt.append(" WHERE ");
                            order = new StringBuffer().append(" ORDER BY ");
                        } else {
                            stmt.append(" AND ");
                            order.append(", ");
                        }
                        stmt.append(this.stmtInfo.getName(i)).append(" = ?");
                        order.append(this.stmtInfo.getName(i));
                        ++i;
                    }
                    stmtTxt = stmt.toString();
                    if (order != null) {
                        stmtTxt = stmtTxt + order.toString();
                    }
                    if (this.vendorID == 1) {
                        stmtTxt = stmtTxt + " WITH CS";
                    }
                    loadStmt = this.connection.prepareStatement(stmtTxt);
                    int i2 = 1;
                    while (i2 <= this.bufferKeyCnt) {
                        Object value = this.stmtInfo.getValue(i2, hostVals);
                        if (value instanceof String) {
                            loadStmt.setString(i2, (String)value);
                        } else if (value instanceof Timestamp) {
                            loadStmt.setTimestamp(i2, (Timestamp)value, UTCCalendar.getInstance());
                        } else {
                            loadStmt.setObject(i2, value);
                        }
                        ++i2;
                    }
                    ((CommonConnectionImpl)this.connectionContext.getConnection()).setActiveTransactionState(2, this.connection.getTransactionIsolation());
                    rs = loadStmt.executeQuery();
                    BufferLoadAccess loadAccess = this.access.loadData(this.tableName, bufferKey);
                    try {
                        Class[] columnClass = null;
                        while (rs.next()) {
                            if (null == columnClass) {
                                columnClass = this.createColumnClass();
                            }
                            BufferRecord bufferRecord = this.access.getBufferRecord(this.table.getColumnCnt());
                            int i3 = 1;
                            while (i3 <= this.table.getColumnCnt()) {
                                this.copyToBufferRecord(i3, rs, bufferRecord, columnClass[i3 - 1]);
                                ++i3;
                            }
                            loadAccess.put(bufferRecord);
                        }
                        loadAccess.end();
                    }
                    catch (DataLockedException lockedEx) {
                        throw lockedEx;
                    }
                    catch (SQLException sqlEx) {
                        loadAccess.abort();
                        throw sqlEx;
                    }
                    catch (RuntimeException rtEx) {
                        loadAccess.abort();
                        throw rtEx;
                    }
                    Object var16_20 = null;
                    if (rs == null) break block26;
                }
                catch (BufferException bufferEx) {
                    throw accessException;
                }
                catch (SQLException sqlEx) {
                    Syslog.logSQLException(this, sqlEx, this.connectionContext.getConnectionID(), stmtTxt);
                    throw accessException;
                }
                rs.close();
            }
            if (loadStmt != null) {
                loadStmt.close();
            }
            if (this.vendorID == 1) return;
            this.connection.setTransactionIsolation(isolationLevel);
            return;
        }
        catch (Throwable throwable) {
            Object var16_21 = null;
            if (rs != null) {
                rs.close();
            }
            if (loadStmt != null) {
                loadStmt.close();
            }
            if (this.vendorID == 1) throw throwable;
            this.connection.setTransactionIsolation(isolationLevel);
            throw throwable;
        }
    }

    private Class[] createColumnClass() {
        Class[] columnClass = new Class[this.table.getColumnCnt()];
        int i = 1;
        while (i <= this.table.getColumnCnt()) {
            Column col = this.table.getColumn(i);
            columnClass[i - 1] = CommonTypes.defaultMapping(col.getJdbcType());
            ++i;
        }
        return columnClass;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void bufferDelete(BufferHostVars hostVals) throws SQLException {
        BufferRecord bufferKey = this.stmtInfo.getBufferKey(this.access, hostVals);
        try {
            try {
                if (this.bufferModify) {
                    this.access.deleteRecords(this.bufferManager.getTransaction(), this.tableName, bufferKey, proc);
                }
                this.bufferInvalidate(bufferKey);
            }
            catch (IllegalArgumentException ex) {
                this.bufferInvalidate(null);
                Object var6_4 = null;
                this.bufferSynchronize(bufferKey);
                return;
            }
            catch (BufferException ex) {
                Object var6_5 = null;
                this.bufferSynchronize(bufferKey);
                return;
            }
            Object var6_3 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.bufferSynchronize(bufferKey);
            throw throwable;
        }
        this.bufferSynchronize(bufferKey);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void bufferInsert(BufferHostVars hostVals) throws SQLException {
        BufferRecord bufferKey = this.stmtInfo.getBufferKey(this.access, hostVals);
        try {
            try {
                if (this.bufferModify) {
                    BufferRecord bufferRecord = this.access.getBufferRecord(this.table.getColumnCnt());
                    this.stmtInfo.fillBufferRecord(bufferRecord, hostVals);
                    this.access.insertRecord(this.bufferManager.getTransaction(), this.tableName, bufferRecord);
                }
                this.bufferInvalidate(bufferKey);
            }
            catch (IllegalArgumentException ex) {
                this.bufferInvalidate(null);
                Object var6_6 = null;
                this.bufferSynchronize(bufferKey);
                return;
            }
            catch (BufferException ex) {
                Object var6_7 = null;
                this.bufferSynchronize(bufferKey);
                return;
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.bufferSynchronize(bufferKey);
            throw throwable;
        }
        this.bufferSynchronize(bufferKey);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void bufferUpdate(BufferHostVars hostVals) throws SQLException {
        BufferRecord bufferKey = this.stmtInfo.getBufferKey(this.access, hostVals);
        try {
            try {
                if (this.bufferModify) {
                    BufferRecord bufferRecord = this.access.getBufferRecord(this.table.getColumnCnt());
                    this.stmtInfo.fillBufferRecord(bufferRecord, hostVals);
                    this.access.updateRecord(this.bufferManager.getTransaction(), this.tableName, bufferRecord);
                }
                this.bufferInvalidate(bufferKey);
            }
            catch (IllegalArgumentException ex) {
                this.bufferInvalidate(null);
                Object var10_6 = null;
                this.bufferSynchronize(bufferKey);
                return;
            }
            catch (BufferNotAvailableException ex) {
                Object var10_7 = null;
                this.bufferSynchronize(bufferKey);
                return;
            }
            catch (BufferResetException ex) {
                Object var10_8 = null;
                this.bufferSynchronize(bufferKey);
                return;
            }
            catch (ObjectNotDefinedException ex) {
                Object var10_9 = null;
                this.bufferSynchronize(bufferKey);
                return;
            }
            catch (RecordNotFoundException ex) {
                Object var10_10 = null;
                this.bufferSynchronize(bufferKey);
                return;
            }
            catch (SQLException ex) {
                this.bufferInvalidate(bufferKey);
                Object var10_11 = null;
                this.bufferSynchronize(bufferKey);
                return;
            }
            Object var10_5 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.bufferSynchronize(bufferKey);
            throw throwable;
        }
        this.bufferSynchronize(bufferKey);
    }

    private void bufferDefine() throws IllegalArgumentException, BufferNotAvailableException, BufferResetException {
        try {
            int keyCnt = this.table.getPrimaryKeyCnt();
            int[] keyInd = new int[keyCnt];
            int i = 0;
            while (i < keyCnt) {
                keyInd[i] = this.table.getPrimaryKeyColumn(i + 1).getPosition();
                ++i;
            }
            this.access.defineObject(this.table.getName(), keyCnt, this.bufferKeyCnt, this.table.getColumnCnt(), keyInd);
        }
        catch (ObjectExistsException objectExistsException) {
            // empty catch block
        }
    }

    private void bufferInvalidate(BufferRecord bufferKey) throws IllegalArgumentException, BufferNotAvailableException {
        this.access.invalidateObject(this.bufferManager.getTransaction(), this.tableName, bufferKey);
    }

    private void bufferSynchronize(BufferRecord bufferKey) throws SQLException {
        if (this.connectionContext.getAutoCommit()) {
            this.bufferManager.commit();
        }
        if (this.syncWriter != null) {
            SyncRecordOutputStream syncRecord = BufferSyncRecord.writeInvalidateSyncRecord(this.tableName, bufferKey);
            this.syncWriter.syncRequest(this.syncID, syncRecord);
            if (this.connectionContext.getAutoCommit()) {
                this.syncWriter.flushRequests();
            }
        }
    }

    private String getStmtString() {
        return this.commonStmt != null ? ((AbstractCommonStatement)((Object)this.commonStmt)).getStatementString() : this.stmtInfo.getSQLStatement().toSqlString(this.connectionContext.getVendorID());
    }

    private ExtendedStatement getNativeStmt() throws SQLException {
        return this.commonStmt.getDbStmt(this.stmtInfo.getSQLStatement().getStatementType());
    }

    private void copyToBufferRecord(int columnIndex, ResultSet rs, BufferRecord bufRec, Class clazz) throws SQLException {
        if (clazz == null) {
            throw TableBufferRTIllegalArgumentException.getAndLog(this.getClass(), "com.sap.exception.standard_0001", "clazz");
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = BufferStatement.class$("java.lang.String")) : class$java$lang$String)) {
            bufRec.setString(columnIndex, rs.getString(columnIndex));
        } else if (clazz == Short.TYPE || clazz == (class$java$lang$Short == null ? (class$java$lang$Short = BufferStatement.class$("java.lang.Short")) : class$java$lang$Short)) {
            short value = rs.getShort(columnIndex);
            bufRec.setShort(columnIndex, rs.wasNull() ? null : new Short(value));
        } else if (clazz == Integer.TYPE || clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = BufferStatement.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            int value = rs.getInt(columnIndex);
            bufRec.setInteger(columnIndex, rs.wasNull() ? null : new Integer(value));
        } else if (clazz == Long.TYPE || clazz == (class$java$lang$Long == null ? (class$java$lang$Long = BufferStatement.class$("java.lang.Long")) : class$java$lang$Long)) {
            long value = rs.getLong(columnIndex);
            bufRec.setLong(columnIndex, rs.wasNull() ? null : new Long(value));
        } else if (clazz == Float.TYPE || clazz == (class$java$lang$Float == null ? (class$java$lang$Float = BufferStatement.class$("java.lang.Float")) : class$java$lang$Float)) {
            float value = rs.getFloat(columnIndex);
            bufRec.setFloat(columnIndex, rs.wasNull() ? null : new Float(value));
        } else if (clazz == Double.TYPE || clazz == (class$java$lang$Double == null ? (class$java$lang$Double = BufferStatement.class$("java.lang.Double")) : class$java$lang$Double)) {
            double value = rs.getDouble(columnIndex);
            bufRec.setDouble(columnIndex, rs.wasNull() ? null : new Double(value));
        } else if (clazz == Boolean.TYPE || clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = BufferStatement.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            boolean value = rs.getBoolean(columnIndex);
            bufRec.setBoolean(columnIndex, rs.wasNull() ? null : new Boolean(value));
        } else if (clazz == Byte.TYPE || clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = BufferStatement.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            byte value = rs.getByte(columnIndex);
            bufRec.setByte(columnIndex, rs.wasNull() ? null : new Byte(value));
        } else if (clazz == (array$B == null ? (array$B = BufferStatement.class$("[B")) : array$B)) {
            bufRec.setByteArray(columnIndex, rs.getBytes(columnIndex));
        } else if (clazz == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = BufferStatement.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
            bufRec.setBigDecimal(columnIndex, rs.getBigDecimal(columnIndex));
        } else if (clazz == (class$java$sql$Date == null ? (class$java$sql$Date = BufferStatement.class$("java.sql.Date")) : class$java$sql$Date)) {
            bufRec.setDate(columnIndex, rs.getDate(columnIndex));
        } else if (clazz == (class$java$sql$Time == null ? (class$java$sql$Time = BufferStatement.class$("java.sql.Time")) : class$java$sql$Time)) {
            bufRec.setTime(columnIndex, rs.getTime(columnIndex));
        } else if (clazz == (class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = BufferStatement.class$("java.sql.Timestamp")) : class$java$sql$Timestamp)) {
            bufRec.setTimestamp(columnIndex, rs.getTimestamp(columnIndex, UTCCalendar.getInstance()));
        } else if (clazz == (class$java$sql$Clob == null ? (class$java$sql$Clob = BufferStatement.class$("java.sql.Clob")) : class$java$sql$Clob)) {
            Clob clob = rs.getClob(columnIndex);
            if (rs.wasNull() || null == clob) {
                bufRec.setCharArray(columnIndex, null);
            } else {
                long clobLength = clob.length();
                if (!this.access.isLoadable(clobLength * 2L)) {
                    throw TableBufferLOBException.getAndLog(this.getClass(), "com.sap.sql.jdbc.common_1113", new Object[]{new Integer(columnIndex), "CLOB", new Long(clobLength)});
                }
                Reader clobReader = clob.getCharacterStream();
                bufRec.setCharArray(columnIndex, this.readReader(clobReader, (int)clobLength, columnIndex));
            }
        } else if (clazz == (class$java$sql$Blob == null ? (class$java$sql$Blob = BufferStatement.class$("java.sql.Blob")) : class$java$sql$Blob)) {
            Blob blob = rs.getBlob(columnIndex);
            if (rs.wasNull() || null == blob) {
                bufRec.setByteArray(columnIndex, null);
            } else {
                long blobLength = blob.length();
                if (!this.access.isLoadable(blobLength)) {
                    throw TableBufferLOBException.getAndLog(this.getClass(), "com.sap.sql.jdbc.common_1113", new Object[]{new Integer(columnIndex), "BLOB", new Long(blobLength)});
                }
                InputStream inputStream = blob.getBinaryStream();
                bufRec.setByteArray(columnIndex, this.readInputStream(inputStream, (int)blobLength, columnIndex));
            }
        } else {
            throw TableBufferRTIllegalArgumentException.getAndLog(this.getClass(), "com.sap.exception.standard_0027", "clazz", clazz.getName());
        }
    }

    char[] readReader(Reader reader, int length, int columnIndex) throws TableBufferException {
        char[] charArray = new char[length];
        int numChars = 0;
        int readChars = 0;
        try {
            while (numChars != -1 && readChars != length) {
                numChars = reader.read(charArray, readChars, length - readChars);
                if (-1 == numChars) continue;
                readChars += numChars;
            }
            reader.close();
        }
        catch (Exception e) {
            if (numChars != -1) {
                try {
                    reader.close();
                }
                catch (Exception dummy) {
                    // empty catch block
                }
                throw TableBufferLOBException.getAndLog(this.getClass(), "com.sap.sql.jdbc.common_1110", new Object[]{new Integer(columnIndex), "java.io.Reader", e.getMessage()});
            }
            throw TableBufferLOBException.getAndLog(this.getClass(), "com.sap.sql.jdbc.common_1110", new Object[]{new Integer(columnIndex), "java.io.Reader.close()", e.getMessage()});
        }
        if (-1 == numChars) {
            throw TableBufferLOBException.getAndLog(this.getClass(), "com.sap.sql.jdbc.common_1111", new Object[]{new Integer(columnIndex), "java.io.Reader", new Long(readChars), new Long(length)});
        }
        return charArray;
    }

    byte[] readInputStream(InputStream x, int length, int columnIndex) throws TableBufferException {
        byte[] byteArray = new byte[length];
        int numBytes = 0;
        int readBytes = 0;
        try {
            while (numBytes != -1 && readBytes != length) {
                numBytes = x.read(byteArray, readBytes, length - readBytes);
                if (-1 == numBytes) continue;
                readBytes += numBytes;
            }
            x.close();
        }
        catch (Exception e) {
            if (numBytes != -1) {
                try {
                    x.close();
                }
                catch (Exception dummy) {
                    // empty catch block
                }
                throw TableBufferLOBException.getAndLog(this.getClass(), "com.sap.sql.jdbc.common_1110", new Object[]{new Integer(columnIndex), "java.io.InputStream", e.getMessage()});
            }
            throw TableBufferLOBException.getAndLog(this.getClass(), "com.sap.sql.jdbc.common_1110", new Object[]{new Integer(columnIndex), "java.io.InputStream.close()", e.getMessage()});
        }
        if (-1 == numBytes) {
            throw TableBufferLOBException.getAndLog(this.getClass(), "com.sap.sql.jdbc.common_1111", new Object[]{new Integer(columnIndex), "java.io.Reader", new Long(readBytes), new Long(length)});
        }
        return byteArray;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class TableBufferAccessException
    extends SQLException {
        TableBufferAccessException() {
        }
    }
}

