/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.tablebuffer;

import com.sap.sql.buffer.BufferAccess;
import com.sap.sql.buffer.BufferRecord;
import com.sap.sql.jdbc.ExtendedPreparedStatement;
import com.sap.sql.jdbc.common.UTCCalendar;
import com.sap.sql.log.Syslog;
import com.sap.sql.tablebuffer.BufferByteArrayInputStream;
import com.sap.sql.tablebuffer.BufferCharArrayReader;
import com.sap.sql.tablebuffer.BufferCommonStatement;
import com.sap.sql.tablebuffer.BufferConnectionContext;
import com.sap.sql.tablebuffer.BufferHostVars;
import com.sap.sql.tablebuffer.BufferStatement;
import com.sap.sql.tablebuffer.BufferStatementInfo;
import com.sap.sql.tablebuffer.TableBufferRecordProcessor;
import com.sap.sql.tablebuffer.TableBufferUnsupportedMethodException;
import com.sap.sql.trace.TraceContext;
import com.sap.sql.tree.QuerySpecification;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;

public class BufferPreparedStatement
extends BufferStatement
implements ExtendedPreparedStatement {
    private static final int BATCH_EXECUTE_FAILED = -3;
    private BufferCommonStatement commonPrepStmt;
    private ExtendedPreparedStatement nativePrepStmt = null;
    private BufferHostVars hostValues;
    private Collection batchCollection;

    BufferPreparedStatement(BufferConnectionContext connectionContext, BufferAccess access, BufferStatementInfo stmtInfo, BufferCommonStatement commonPrepStmt) {
        super(connectionContext, access, stmtInfo);
        this.commonPrepStmt = commonPrepStmt;
        this.hostValues = new BufferHostVars(stmtInfo.getHostVariableCount());
        if (this.stmtType == 0) {
            this.recordProcessor = new TableBufferRecordProcessor(stmtInfo.getQuerySpecification(), this.hostValues, stmtInfo);
        }
    }

    public ResultSet executeQuery(TraceContext traceContext) throws SQLException {
        try {
            BufferRecord bufferKey = this.stmtInfo.getBufferKey(this.access, this.hostValues);
            this.resultSet = this.bufferSelect(bufferKey);
            if (this.resultSet == null) {
                this.bufferLoad(bufferKey, this.hostValues);
                this.resultSet = this.bufferSelect(bufferKey);
            }
        }
        catch (BufferStatement.TableBufferAccessException ex) {
            this.getNativePrepStmt();
            this.copyHostValues();
            this.resultSet = this.nativePrepStmt.executeQuery(traceContext);
        }
        return this.resultSet;
    }

    public int executeUpdate(TraceContext traceContext) throws SQLException {
        this.updateCount = 0;
        this.getNativePrepStmt();
        this.copyHostValues();
        this.updateCount = this.nativePrepStmt.executeUpdate(traceContext);
        switch (this.stmtType) {
            case 1: {
                this.bufferDelete(this.hostValues);
                break;
            }
            case 2: {
                this.bufferInsert(this.hostValues);
                break;
            }
            case 3: {
                this.bufferUpdate(this.hostValues);
            }
        }
        return this.updateCount;
    }

    public boolean execute(TraceContext traceContext) throws SQLException {
        if (this.stmtType == 0) {
            this.executeQuery(traceContext);
            return true;
        }
        this.executeUpdate(traceContext);
        return false;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] executeBatch(TraceContext traceContext) throws SQLException {
        block26: {
            block27: {
                if (this.batchCollection == null) {
                    return new int[0];
                }
                this.getNativePrepStmt();
                this.copyHostValues();
                updateCounts = null;
                errorUpdateCounts = null;
                try {
                    try {
                        updateCounts = this.nativePrepStmt.executeBatch(traceContext);
                    }
                    catch (BatchUpdateException batchException) {
                        errorUpdateCounts = batchException.getUpdateCounts();
                        this.bufferModify = false;
                        throw batchException;
                    }
                    catch (RuntimeException e) {
                        this.bufferModify = false;
                        throw e;
                    }
                    var7_4 = null;
                }
                catch (Throwable var6_18) {
                    var7_5 = null;
                    try {
                        batchCounter = 0;
                        batchIterator = this.batchCollection.iterator();
                        block19: while (true) lbl-1000:
                        // 5 sources

                        {
                            if (!batchIterator.hasNext()) {
                                v0 = null;
                                break block26;
                            }
                            hostVals = (BufferHostVars)batchIterator.next();
                            if (null == errorUpdateCounts || batchCounter >= errorUpdateCounts.length || -3 == errorUpdateCounts[batchCounter++]) {
                                // empty if block
                            }
                            switch (this.stmtType) {
                                case 1: {
                                    this.bufferDelete(hostVals);
                                    ** break;
                                }
                                case 2: {
                                    this.bufferInsert(hostVals);
                                    ** break;
                                }
                                case 3: {
                                    this.bufferUpdate(hostVals);
                                    continue block19;
                                }
                            }
                        }
                    }
                    catch (Throwable var11_13) {
                        v0 = null;
                        break block26;
                    }
                }
                ** try [egrp 2[TRYBLOCK] [3 : 77->201)] { 
lbl50:
                // 1 sources

                batchCounter = 0;
                batchIterator = this.batchCollection.iterator();
                while (batchIterator.hasNext()) {
                    hostVals = (BufferHostVars)batchIterator.next();
                    if (null == errorUpdateCounts || batchCounter >= errorUpdateCounts.length || -3 == errorUpdateCounts[batchCounter++]) {
                        // empty if block
                    }
                    switch (this.stmtType) {
                        case 1: {
                            this.bufferDelete(hostVals);
                            break;
                        }
                        case 2: {
                            this.bufferInsert(hostVals);
                            break;
                        }
                        case 3: {
                            this.bufferUpdate(hostVals);
                            break;
                        }
                    }
                }
                v1 = null;
                break block27;
lbl69:
                // 1 sources

                catch (Throwable var11_12) {
                    v1 = null;
                }
            }
            var12_14 = v1;
            this.clearBatch();
            return updateCounts;
        }
        var12_15 = v0;
        this.clearBatch();
        throw var6_18;
    }

    public ResultSet executeQuery() throws SQLException {
        return this.executeQuery((TraceContext)null);
    }

    public int executeUpdate() throws SQLException {
        return this.executeUpdate((TraceContext)null);
    }

    public boolean execute() throws SQLException {
        return this.execute((TraceContext)null);
    }

    public void close() throws SQLException {
        try {
            super.close();
            Object var2_1 = null;
            this.batchCollection = null;
            this.commonPrepStmt = null;
            this.hostValues = null;
            this.nativePrepStmt = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.batchCollection = null;
            this.commonPrepStmt = null;
            this.hostValues = null;
            this.nativePrepStmt = null;
            throw throwable;
        }
    }

    public void addBatch() throws SQLException {
        if (null == this.batchCollection) {
            this.batchCollection = new ArrayList(10);
        }
        this.batchCollection.add((BufferHostVars)this.hostValues.clone());
    }

    public void clearBatch() throws SQLException {
        this.batchCollection = null;
    }

    public void clearParameters() throws SQLException {
        this.hostValues.clear();
    }

    public void setNull(int index, int sqlType) throws SQLException {
        this.hostValues.setNull(index, sqlType);
    }

    public void setBoolean(int index, boolean x) throws SQLException {
        this.hostValues.set(index, new Boolean(x));
    }

    public void setByte(int index, byte x) throws SQLException {
        this.hostValues.set(index, new Byte(x));
    }

    public void setShort(int index, short x) throws SQLException {
        this.hostValues.set(index, new Short(x));
    }

    public void setInt(int index, int x) throws SQLException {
        this.hostValues.set(index, new Integer(x));
    }

    public void setLong(int index, long x) throws SQLException {
        this.hostValues.set(index, new Long(x));
    }

    public void setFloat(int index, float x) throws SQLException {
        this.hostValues.set(index, new Float(x));
    }

    public void setDouble(int index, double x) throws SQLException {
        this.hostValues.set(index, new Double(x));
    }

    public void setBigDecimal(int index, BigDecimal x) throws SQLException {
        this.hostValues.set(index, x);
    }

    public void setString(int index, String x) throws SQLException {
        this.hostValues.set(index, x);
    }

    public void setBytes(int index, byte[] x) throws SQLException {
        this.hostValues.set(index, x);
    }

    public void setDate(int index, Date x) throws SQLException {
        this.hostValues.set(index, x);
    }

    public void setTime(int index, Time x) throws SQLException {
        this.hostValues.set(index, x);
    }

    public void setTimestamp(int index, Timestamp x, Calendar cal) throws SQLException {
        this.hostValues.set(index, x);
    }

    public void setBinaryStream(int index, InputStream x, int length) throws SQLException {
        if (!this.access.isLoadable(length)) {
            this.bufferModify = false;
            this.hostValues.set(index, x);
        } else {
            byte[] byteArray = this.readInputStream(x, length, index);
            BufferByteArrayInputStream bufferInputStream = new BufferByteArrayInputStream(byteArray);
            this.hostValues.set(index, bufferInputStream);
        }
    }

    public void setCharacterStream(int index, Reader reader, int length) throws SQLException {
        if (!this.access.isLoadable((long)length * 2L)) {
            this.bufferModify = false;
            this.hostValues.set(index, reader);
        } else {
            char[] charArray = this.readReader(reader, length, index);
            BufferCharArrayReader bufferReader = new BufferCharArrayReader(charArray);
            this.hostValues.set(index, bufferReader);
        }
    }

    public void setAsciiStream(int index, InputStream x, int length) throws SQLException {
        throw TableBufferUnsupportedMethodException.getAndLog(this.getClass(), "setAsciiStream(int, InputStream, int)");
    }

    public void setUnicodeStream(int index, InputStream x, int length) throws SQLException {
        throw TableBufferUnsupportedMethodException.getAndLog(this.getClass(), "setUnicodeStream(int, InputStream, int)");
    }

    public void setObject(int index, Object x, int targetSqlType, int scale) throws SQLException {
        throw TableBufferUnsupportedMethodException.getAndLog(this.getClass(), "setObject(int, Object, int, int)");
    }

    public void setObject(int index, Object x, int targetSqlType) throws SQLException {
        if (x == null) {
            this.hostValues.setNull(index, targetSqlType);
        } else {
            this.hostValues.set(index, x);
        }
    }

    public void setObject(int index, Object x) throws SQLException {
        if (x == null) {
            throw TableBufferUnsupportedMethodException.getAndLog(this.getClass(), "setObject(int index, Object x)");
        }
        this.hostValues.set(index, x);
    }

    public void setRef(int index, Ref x) throws SQLException {
        throw TableBufferUnsupportedMethodException.getAndLog(this.getClass(), "setRef(int, Ref)");
    }

    public void setBlob(int index, Blob x) throws SQLException {
        throw TableBufferUnsupportedMethodException.getAndLog(this.getClass(), "setBlob(int, Blob)");
    }

    public void setClob(int index, Clob x) throws SQLException {
        throw TableBufferUnsupportedMethodException.getAndLog(this.getClass(), "setClob(int, Blob)");
    }

    public void setArray(int index, Array x) throws SQLException {
        throw TableBufferUnsupportedMethodException.getAndLog(this.getClass(), "setArray(int, Array)");
    }

    public void setDate(int index, Date x, Calendar cal) throws SQLException {
        throw TableBufferUnsupportedMethodException.getAndLog(this.getClass(), "setDate(int, Date, Calendar)");
    }

    public void setTime(int index, Time x, Calendar cal) throws SQLException {
        throw TableBufferUnsupportedMethodException.getAndLog(this.getClass(), "setTime(int, Time, Calendar)");
    }

    public void setTimestamp(int index, Timestamp x) throws SQLException {
        throw TableBufferUnsupportedMethodException.getAndLog(this.getClass(), "setTimestamp(int, Timestamp)");
    }

    public void setNull(int index, int sqlType, String typeName) throws SQLException {
        throw TableBufferUnsupportedMethodException.getAndLog(this.getClass(), "setNull(int, int, String)");
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        throw TableBufferUnsupportedMethodException.getAndLog(this.getClass(), "getMetaData()");
    }

    private ExtendedPreparedStatement getNativePrepStmt() throws SQLException {
        if (this.nativePrepStmt == null) {
            this.nativePrepStmt = this.commonPrepStmt.getDbPrepStmt();
        }
        return this.nativePrepStmt;
    }

    private void copyHostValues() throws SQLException {
        if (null == this.batchCollection) {
            this.copyHostValues(this.hostValues);
        } else {
            Iterator batchIterator = this.batchCollection.iterator();
            while (batchIterator.hasNext()) {
                BufferHostVars hostVals = (BufferHostVars)batchIterator.next();
                this.copyHostValues(hostVals);
                this.nativePrepStmt.addBatch();
            }
        }
    }

    private void copyHostValues(BufferHostVars hostVals) throws SQLException {
        int i = 1;
        while (i <= hostVals.getSize()) {
            Object hostVal = hostVals.get(i);
            if (null == hostVal) {
                this.nativePrepStmt.setNull(i, hostVals.getSqlType(i));
            } else if (hostVal instanceof String) {
                this.nativePrepStmt.setString(i, (String)hostVal);
            } else if (hostVal instanceof BufferCharArrayReader) {
                BufferCharArrayReader reader = (BufferCharArrayReader)hostVal;
                try {
                    reader.reset();
                }
                catch (IOException e) {
                    throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.tablebuffer_1205", new Object[]{new Integer(i), reader.getClass().getName()}, (Throwable)e);
                }
                this.nativePrepStmt.setCharacterStream(i, (Reader)reader, reader.getArrayLength());
            } else if (hostVal instanceof BufferByteArrayInputStream) {
                BufferByteArrayInputStream stream = (BufferByteArrayInputStream)hostVal;
                stream.reset();
                this.nativePrepStmt.setBinaryStream(i, (InputStream)stream, stream.getArrayLength());
            } else if (hostVal instanceof Timestamp) {
                this.nativePrepStmt.setTimestamp(i, (Timestamp)hostVal, UTCCalendar.getInstance());
            } else {
                this.nativePrepStmt.setObject(i, hostVal);
            }
            ++i;
        }
    }

    public QuerySpecification getQuerySpecification() {
        return this.stmtInfo.getQuerySpecification();
    }

    public BufferHostVars getHostVariableValues() {
        return this.hostValues;
    }
}

