/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.tablebuffer;

import com.sap.sql.buffer.Buffer;
import com.sap.sql.buffer.BufferAccess;
import com.sap.sql.buffer.BufferException;
import com.sap.sql.buffer.BufferNotAvailableException;
import com.sap.sql.catalog.Column;
import com.sap.sql.catalog.Table;
import com.sap.sql.log.Syslog;
import com.sap.sql.sync.SyncRecordOutputStream;
import com.sap.sql.tablebuffer.BufferCommonStatement;
import com.sap.sql.tablebuffer.BufferConnectionContext;
import com.sap.sql.tablebuffer.BufferManagerFactory;
import com.sap.sql.tablebuffer.BufferPreparedStatement;
import com.sap.sql.tablebuffer.BufferStatement;
import com.sap.sql.tablebuffer.BufferStatementInfo;
import com.sap.sql.tablebuffer.BufferSyncRecord;
import com.sap.sql.tablebuffer.InternalTreeException;
import com.sap.sql.tablebuffer.TableBufferRTIllegalArgumentException;
import com.sap.sql.tree.ArithmeticExpression;
import com.sap.sql.tree.BetweenPredicate;
import com.sap.sql.tree.BooleanAnd;
import com.sap.sql.tree.BooleanNot;
import com.sap.sql.tree.BooleanOr;
import com.sap.sql.tree.ColumnReference;
import com.sap.sql.tree.ComparisonPredicate;
import com.sap.sql.tree.DeleteStatement;
import com.sap.sql.tree.ExistsPredicate;
import com.sap.sql.tree.HostVariable;
import com.sap.sql.tree.InListPredicate;
import com.sap.sql.tree.InSubqueryPredicate;
import com.sap.sql.tree.InsertStatement;
import com.sap.sql.tree.LikePredicate;
import com.sap.sql.tree.Literal;
import com.sap.sql.tree.NullPredicate;
import com.sap.sql.tree.QuantifiedComparisonPredicate;
import com.sap.sql.tree.Query;
import com.sap.sql.tree.QuerySpecification;
import com.sap.sql.tree.RowValue;
import com.sap.sql.tree.RowValueElement;
import com.sap.sql.tree.RowValueElementList;
import com.sap.sql.tree.SQLStatement;
import com.sap.sql.tree.SearchCondition;
import com.sap.sql.tree.SelectForUpdateStatement;
import com.sap.sql.tree.SelectStatement;
import com.sap.sql.tree.SelectSublist;
import com.sap.sql.tree.SetClause;
import com.sap.sql.tree.SortSpecification;
import com.sap.sql.tree.TableValue;
import com.sap.sql.tree.UpdateStatement;
import com.sap.sql.tree.ValueExpression;
import com.sap.tc.logging.Location;
import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.xa.Xid;

public class BufferManager {
    private static final Location TRACE = Location.getLocation((Class)(class$com$sap$sql$tablebuffer$BufferManager == null ? (class$com$sap$sql$tablebuffer$BufferManager = BufferManager.class$("com.sap.sql.tablebuffer.BufferManager")) : class$com$sap$sql$tablebuffer$BufferManager));
    private static final SQLException treeTooComplexException = new InternalTreeException();
    private static final int FORCE_SINGLE = 1;
    private static final int FORCE_GENERIC = 2;
    private static final int FORCE_FULL = 3;
    private int forceMode = 0;
    private Buffer buffer;
    private boolean active;
    private Connection connection;
    private BufferAccess access;
    private Object transaction;
    static /* synthetic */ Class class$com$sap$sql$tablebuffer$BufferManager;

    public BufferManager(Buffer buffer, BufferConnectionContext connectionContext) throws BufferNotAvailableException {
        if (TRACE.bePath()) {
            TRACE.pathT("Entering BufferManager(Buffer, BufferConnectionContext)", new Object[]{buffer, connectionContext});
        }
        this.active = Boolean.valueOf(connectionContext.getProperties().getProperty("com.sap.sql.tablebuffer.manager.active"));
        if (this.active) {
            this.connection = connectionContext.getWrappedConnection();
            this.access = buffer.getBufferAccess();
            this.transaction = this.connection;
            String force = connectionContext.getProperties().getProperty("com.sap.sql.tablebuffer.force.mode");
            if (force.equalsIgnoreCase("single")) {
                this.forceMode = 1;
            } else if (force.equalsIgnoreCase("generic")) {
                this.forceMode = 2;
            } else if (force.equalsIgnoreCase("full")) {
                this.forceMode = 3;
            }
        }
        if (TRACE.bePath()) {
            TRACE.pathT("Exiting BufferManager()", new Object[]{new Boolean(this.active)});
        }
    }

    public void close() {
        if (TRACE.bePath()) {
            TRACE.pathT("Entering close()", new Object[]{new Boolean(this.active)});
        }
        this.transaction = null;
        this.access = null;
        this.connection = null;
        if (TRACE.bePath()) {
            TRACE.pathT("Exiting close()", new Object[]{new Boolean(this.active)});
        }
    }

    public void commit() {
        if (TRACE.bePath()) {
            TRACE.pathT("Entering commit()");
        }
        if (this.active) {
            try {
                this.access.commit(this.connection);
            }
            catch (BufferException ex) {
                Syslog.createAndLogOpenSQLException(this, "com.sap.sql.tablebuffer_1204", null, (Throwable)ex);
            }
        }
        if (TRACE.bePath()) {
            TRACE.pathT("Exiting commit()", new Object[]{new Boolean(this.active)});
        }
    }

    public void rollback() {
        if (TRACE.bePath()) {
            TRACE.pathT("Entering rollback()");
        }
        if (this.active) {
            try {
                this.access.rollback(this.connection);
            }
            catch (BufferException ex) {
                Syslog.createAndLogOpenSQLException(this, "com.sap.sql.tablebuffer_1204", null, (Throwable)ex);
            }
        }
        if (TRACE.bePath()) {
            TRACE.pathT("Exiting rollback()", new Object[]{new Boolean(this.active)});
        }
    }

    public void startXA(Xid xid) {
        if (TRACE.bePath()) {
            TRACE.pathT("Entering startXA(Xid)", new Object[]{xid});
        }
        if (this.active) {
            this.transaction = xid;
        }
        if (TRACE.bePath()) {
            TRACE.pathT("Exiting startXA()", new Object[]{new Boolean(this.active)});
        }
    }

    public void endXA(Xid xid) {
        if (TRACE.bePath()) {
            TRACE.pathT("Entering endXA(Xid)", new Object[]{xid});
        }
        if (this.active) {
            this.transaction = this.connection;
        }
        if (TRACE.bePath()) {
            TRACE.pathT("Exiting startXA()", new Object[]{new Boolean(this.active)});
        }
    }

    public void commitXA(Xid xid) {
        if (TRACE.bePath()) {
            TRACE.pathT("Entering commitXA(Xid)", new Object[]{xid});
        }
        if (this.active) {
            try {
                this.access.commit(xid);
            }
            catch (BufferException ex) {
                Syslog.createAndLogOpenSQLException(this, "com.sap.sql.tablebuffer_1204", null, (Throwable)ex);
            }
        }
        if (TRACE.bePath()) {
            TRACE.pathT("Exiting commitXA()", new Object[]{new Boolean(this.active)});
        }
    }

    public void rollbackXA(Xid xid) {
        if (TRACE.bePath()) {
            TRACE.pathT("Entering rollbackXA(Xid)", new Object[]{xid});
        }
        if (this.active) {
            try {
                this.access.rollback(xid);
            }
            catch (BufferException ex) {
                Syslog.createAndLogOpenSQLException(this, "com.sap.sql.tablebuffer_1204", null, (Throwable)ex);
            }
        }
        if (TRACE.bePath()) {
            TRACE.pathT("Exiting commitXA()", new Object[]{new Boolean(this.active)});
        }
    }

    public void forgetXA(Xid xid) {
        if (TRACE.bePath()) {
            TRACE.pathT("Entering forgetXA(Xid)", new Object[]{xid});
        }
        this.rollbackXA(xid);
        if (TRACE.bePath()) {
            TRACE.pathT("Exiting rollbackXA()", new Object[]{new Boolean(this.active)});
        }
    }

    Object getTransaction() {
        if (TRACE.bePath()) {
            TRACE.pathT("Entering getTransaction()");
        }
        if (TRACE.bePath()) {
            TRACE.pathT("Exiting getTransaction()", new Object[]{new Boolean(this.active)});
        }
        return this.transaction;
    }

    public SyncRecordOutputStream removeTable(String tableName) throws SQLException {
        if (tableName == null) {
            throw TableBufferRTIllegalArgumentException.getAndLog(this.getClass(), "com.sap.exception.standard_0001", "tableName");
        }
        try {
            if (this.active) {
                this.access.removeObject(tableName);
            }
        }
        catch (BufferException ex) {
            Syslog.createAndLogOpenSQLException(this, "com.sap.sql.tablebuffer_1204", null, (Throwable)ex);
        }
        return BufferSyncRecord.writeRemoveSyncRecord(tableName);
    }

    public static SyncRecordOutputStream removeTable(String connectionID, String tableName) throws SQLException {
        if (TRACE.bePath()) {
            TRACE.pathT("Entering removeTable(String, String)", new Object[]{connectionID, tableName});
        }
        if (tableName == null) {
            throw TableBufferRTIllegalArgumentException.getAndLog(class$com$sap$sql$tablebuffer$BufferManager == null ? (class$com$sap$sql$tablebuffer$BufferManager = BufferManager.class$("com.sap.sql.tablebuffer.BufferManager")) : class$com$sap$sql$tablebuffer$BufferManager, "com.sap.exception.standard_0001", "tableName");
        }
        try {
            Buffer buffer = BufferManagerFactory.getBuffer(connectionID);
            if (buffer != null) {
                BufferAccess access = buffer.getBufferAccess();
                access.removeObject(tableName);
            }
        }
        catch (BufferException ex) {
            Syslog.logSQLException(class$com$sap$sql$tablebuffer$BufferManager == null ? (class$com$sap$sql$tablebuffer$BufferManager = BufferManager.class$("com.sap.sql.tablebuffer.BufferManager")) : class$com$sap$sql$tablebuffer$BufferManager, (SQLException)ex);
        }
        SyncRecordOutputStream out = BufferSyncRecord.writeRemoveSyncRecord(tableName);
        if (TRACE.bePath()) {
            TRACE.pathT("Exiting removeTable()");
        }
        return out;
    }

    public BufferStatement checkStatement(BufferConnectionContext context, SQLStatement stmtTree, BufferStatement bufferStmt, BufferCommonStatement commonStmt) throws SQLException {
        BufferStatement bufStmt;
        int bufKeyCnt;
        if (TRACE.bePath()) {
            TRACE.pathT("Entering checkStatement(BufferConnectionContext, SQLStatement, BufferStatement bufferStmt,BufferCommonStatement)", new Object[]{context, stmtTree, bufferStmt, commonStmt});
        }
        if (!this.active || (bufKeyCnt = this.checkRuntimeSQLStatement(context, stmtTree)) == -1) {
            bufStmt = null;
        } else {
            BufferStatementInfo stmtInfo = (BufferStatementInfo)stmtTree.getBufferStatementInfo();
            if (bufferStmt == null) {
                bufStmt = new BufferStatement(context, this.access, stmtInfo, commonStmt);
                if (this.forceMode > 0) {
                    bufStmt.setBufferKeyCnt(bufKeyCnt);
                }
            } else {
                bufferStmt.setBufferStatementInfo(stmtInfo);
                if (this.forceMode > 0) {
                    bufferStmt.setBufferKeyCnt(bufKeyCnt);
                }
                bufStmt = bufferStmt;
            }
        }
        if (TRACE.bePath()) {
            TRACE.pathT("Exiting checkStatement()", new Object[]{bufStmt});
        }
        return bufStmt;
    }

    public BufferPreparedStatement checkPreparedStatement(BufferConnectionContext context, SQLStatement stmtTree, BufferCommonStatement commonPrepStmt) throws SQLException {
        BufferPreparedStatement bufPrepStmt;
        int bufKeyCnt;
        if (TRACE.bePath()) {
            TRACE.pathT("Entering checkPreparedStatement(BufferConnectionContext, SQLStatement, BufferCommonStatement)", new Object[]{context, stmtTree, commonPrepStmt});
        }
        if (!this.active || (bufKeyCnt = this.checkRuntimeSQLStatement(context, stmtTree)) == -1) {
            bufPrepStmt = null;
        } else {
            BufferStatementInfo stmtInfo = (BufferStatementInfo)stmtTree.getBufferStatementInfo();
            bufPrepStmt = new BufferPreparedStatement(context, this.access, stmtInfo, commonPrepStmt);
            if (this.forceMode > 0) {
                bufPrepStmt.setBufferKeyCnt(bufKeyCnt);
            }
        }
        if (TRACE.bePath()) {
            TRACE.pathT("Exiting checkPreparedStatement()", new Object[]{bufPrepStmt});
        }
        return bufPrepStmt;
    }

    public static BufferStatementInfo checkSQLStatement(SQLStatement stmtTree) {
        BufferStatementInfo stmtInfo;
        if (TRACE.bePath()) {
            TRACE.pathT("Entering checkSQLStatement(SQLStatement)", new Object[]{stmtTree});
        }
        if (null == (stmtInfo = (BufferStatementInfo)stmtTree.getBufferStatementInfo())) {
            if (stmtTree instanceof SelectStatement) {
                stmtInfo = stmtTree.getHintBypassingBuffer() ? null : BufferManager.checkSelectStatement((SelectStatement)stmtTree);
            } else if (stmtTree instanceof SelectForUpdateStatement) {
                stmtInfo = null;
            } else if (stmtTree instanceof DeleteStatement) {
                stmtInfo = BufferManager.checkDeleteStatement((DeleteStatement)stmtTree);
            } else if (stmtTree instanceof InsertStatement) {
                stmtInfo = BufferManager.checkInsertStatement((InsertStatement)stmtTree);
            } else if (stmtTree instanceof UpdateStatement) {
                stmtInfo = BufferManager.checkUpdateStatement((UpdateStatement)stmtTree);
            }
            stmtTree.setBufferStatementInfo(stmtInfo);
        }
        if (TRACE.bePath()) {
            TRACE.pathT("Exiting checkSQLStatement()");
        }
        return stmtInfo;
    }

    private int checkRuntimeSQLStatement(BufferConnectionContext context, SQLStatement stmtTree) throws SQLException {
        int level;
        BufferStatementInfo stmtInfo;
        if (TRACE.bePath()) {
            TRACE.pathT("Entering checkRuntimeSQLStatement(BufferConnectionContext,  SQLStatement)", new Object[]{context, stmtTree});
        }
        if (null == (stmtInfo = (BufferStatementInfo)stmtTree.getBufferStatementInfo())) {
            if (TRACE.bePath()) {
                TRACE.pathT("Exiting checkRuntimeSQLStatement()", new Object[]{new Integer(-1), "stmtInfo is null"});
            }
            return -1;
        }
        if (stmtInfo.getStatementType() == 0 && (level = context.getConnection().getTransactionIsolation()) != 1) {
            if (TRACE.bePath()) {
                TRACE.pathT("Exiting checkRuntimeSQLStatement()", new Object[]{new Integer(-1), "Isolation level != TRANSACTION_READ_UNCOMMITTED"});
            }
            return -1;
        }
        Table table = stmtInfo.getTable();
        int keyCnt = table.getPrimaryKeyCnt();
        int bufKeyCnt = table.getBufferKeyCnt();
        switch (this.forceMode) {
            case 1: {
                bufKeyCnt = keyCnt;
                break;
            }
            case 2: {
                bufKeyCnt = keyCnt == 0 ? -1 : 1;
                break;
            }
            case 3: {
                bufKeyCnt = 0;
            }
        }
        if (bufKeyCnt < 0) {
            bufKeyCnt = -1;
        } else if (stmtTree instanceof SelectStatement && !stmtInfo.isGenericKeyComplete(bufKeyCnt)) {
            if (TRACE.bePath()) {
                TRACE.pathT("Exiting checkRuntimeSQLStatement()", new Object[]{new Integer(-1), "generic key incomplete"});
            }
            return -1;
        }
        if (TRACE.bePath()) {
            TRACE.pathT("Exiting checkRuntimeSQLStatement()", new Object[]{new Integer(bufKeyCnt)});
        }
        return bufKeyCnt;
    }

    private static BufferStatementInfo checkSelectStatement(SelectStatement tree) {
        SearchCondition whereClause;
        int i;
        QuerySpecification querySpec = BufferStatementInfo.getQuerySpecification(tree);
        Table table = BufferStatementInfo.getTable(tree);
        if (null == table) {
            return null;
        }
        BufferStatementInfo stmtInfo = BufferStatementInfo.newInstance(tree);
        SortSpecification[] orderByList = tree.getOrderByList();
        if (orderByList != null) {
            int keyCnt = table.getPrimaryKeyCnt();
            i = 0;
            while (i < orderByList.length) {
                if (orderByList[i].isDescending() || i >= keyCnt) {
                    return null;
                }
                if (!orderByList[i].getColumnName().equalsIgnoreCase(table.getPrimaryKeyColumn(i + 1).getName())) {
                    return null;
                }
                ++i;
            }
        }
        if (querySpec.getGroupByList() != null || querySpec.getHavingClause() != null || querySpec.isDistinct()) {
            return null;
        }
        SelectSublist[] selectList = querySpec.getSelectList();
        if (selectList != null) {
            i = 0;
            while (i < selectList.length) {
                ValueExpression value = selectList[i].getValue();
                if (value == null || !(value instanceof ColumnReference)) {
                    return null;
                }
                ++i;
            }
        }
        if ((whereClause = querySpec.getWhereClause()) != null) {
            try {
                BufferManager.searchCondition(whereClause);
            }
            catch (InternalTreeException treeTooComplex) {
                return null;
            }
            catch (SQLException ex) {
                Syslog.createAndLogOpenSQLException(class$com$sap$sql$tablebuffer$BufferManager == null ? (class$com$sap$sql$tablebuffer$BufferManager = BufferManager.class$("com.sap.sql.tablebuffer.BufferManager")) : class$com$sap$sql$tablebuffer$BufferManager, "com.sap.sql.tablebuffer_1204", null, (Throwable)ex);
                return null;
            }
        }
        if (whereClause != null) {
            BufferManager.collectPrimaryKey(whereClause, stmtInfo);
        }
        return stmtInfo;
    }

    private static BufferStatementInfo checkDeleteStatement(DeleteStatement tree) {
        BufferStatementInfo stmtInfo = BufferStatementInfo.newInstance(tree);
        SearchCondition whereClause = tree.getWhereClause();
        if (whereClause != null) {
            stmtInfo.setBufferModify(BufferManager.checkPrimaryKey(whereClause, stmtInfo));
        }
        return stmtInfo;
    }

    private static BufferStatementInfo checkInsertStatement(InsertStatement tree) {
        Table table = tree.getTable().getTableDescriptor();
        BufferStatementInfo stmtInfo = BufferStatementInfo.newInstance(tree);
        Query query = tree.getInsertSource();
        if (!(query instanceof TableValue)) {
            return stmtInfo;
        }
        RowValue[] rowValues = ((TableValue)query).getRowValues();
        if (rowValues.length != 1 || !(rowValues[0] instanceof RowValueElementList)) {
            return stmtInfo;
        }
        RowValueElement[] valueList = ((RowValueElementList)rowValues[0]).getValueList();
        ColumnReference[] columns = tree.getColumnList();
        if (columns != null) {
            int i = 0;
            while (i < valueList.length) {
                RowValueElement value;
                Column column = columns[i].getColumnDescriptor();
                if (!stmtInfo.addValue(column, value = valueList[i])) {
                    return stmtInfo;
                }
                ++i;
            }
            stmtInfo.setDefault();
            stmtInfo.setBufferModify(true);
            return stmtInfo;
        }
        int i = 0;
        while (i < valueList.length) {
            RowValueElement value = valueList[i];
            if (!stmtInfo.addValue(table.getColumn(i + 1), value)) {
                return stmtInfo;
            }
            ++i;
        }
        stmtInfo.setBufferModify(true);
        return stmtInfo;
    }

    private static BufferStatementInfo checkUpdateStatement(UpdateStatement tree) {
        BufferStatementInfo stmtInfo = BufferStatementInfo.newInstance(tree);
        SetClause[] setList = tree.getSetClauseList();
        SearchCondition whereClause = tree.getWhereClause();
        if (whereClause == null || !BufferManager.checkPrimaryKey(whereClause, stmtInfo)) {
            return stmtInfo;
        }
        int i = 0;
        while (i < setList.length) {
            RowValueElement value;
            SetClause set = setList[i];
            Column column = set.getColumnReference().getColumnDescriptor();
            if (!stmtInfo.addSetValue(column, value = set.getValue(), i + 1)) {
                return stmtInfo;
            }
            ++i;
        }
        stmtInfo.setBufferModify(true);
        return stmtInfo;
    }

    private static boolean collectPrimaryKey(SearchCondition cond, BufferStatementInfo stmtInfo) {
        if (cond instanceof BooleanAnd) {
            SearchCondition[] opers = ((BooleanAnd)cond).getOperands();
            int i = 0;
            while (i < opers.length) {
                if (opers[i] instanceof ComparisonPredicate) {
                    BufferManager.checkKeyComparison((ComparisonPredicate)opers[i], stmtInfo);
                }
                ++i;
            }
        } else if (cond instanceof ComparisonPredicate) {
            BufferManager.checkKeyComparison((ComparisonPredicate)cond, stmtInfo);
        } else {
            return false;
        }
        return true;
    }

    private static boolean checkPrimaryKey(SearchCondition cond, BufferStatementInfo stmtInfo) {
        if (cond instanceof BooleanAnd) {
            SearchCondition[] opers = ((BooleanAnd)cond).getOperands();
            int i = 0;
            while (i < opers.length) {
                if (opers[i] instanceof ComparisonPredicate) {
                    if (!BufferManager.checkKeyComparison((ComparisonPredicate)opers[i], stmtInfo)) {
                        return false;
                    }
                } else {
                    return false;
                }
                ++i;
            }
        } else if (cond instanceof ComparisonPredicate) {
            if (!BufferManager.checkKeyComparison((ComparisonPredicate)cond, stmtInfo)) {
                return false;
            }
        } else {
            return false;
        }
        return stmtInfo.isPrimaryKeyComplete();
    }

    private static boolean checkKeyComparison(ComparisonPredicate pred, BufferStatementInfo stmtInfo) {
        if (pred.getOperator() != 1) {
            return false;
        }
        RowValue left = pred.getLeftOperand();
        if (!(left instanceof ColumnReference)) {
            return false;
        }
        Column column = ((ColumnReference)left).getColumnDescriptor();
        int keyPos = column.getPrimaryKeyPosition();
        if (keyPos <= 0) {
            return false;
        }
        RowValue right = pred.getRightOperand();
        if (!(right instanceof RowValueElement)) {
            return false;
        }
        return false != stmtInfo.addKeyValue(column, (RowValueElement)right);
    }

    private static void searchCondition(SearchCondition cond) throws SQLException {
        if (cond instanceof BooleanAnd) {
            BufferManager.booleanAnd((BooleanAnd)cond);
        } else if (cond instanceof BooleanOr) {
            BufferManager.booleanOr((BooleanOr)cond);
        } else if (cond instanceof BooleanNot) {
            BufferManager.booleanNot((BooleanNot)cond);
        } else if (cond instanceof BetweenPredicate) {
            BufferManager.betweenPredicate((BetweenPredicate)cond);
        } else if (cond instanceof ComparisonPredicate) {
            BufferManager.comparisonPredicate((ComparisonPredicate)cond);
        } else if (cond instanceof ExistsPredicate) {
            BufferManager.existsPredicate((ExistsPredicate)cond);
        } else if (cond instanceof InListPredicate) {
            BufferManager.inListPredicate((InListPredicate)cond);
        } else if (cond instanceof InSubqueryPredicate) {
            BufferManager.inSubqueryPredicate((InSubqueryPredicate)cond);
        } else if (cond instanceof LikePredicate) {
            BufferManager.likePredicate((LikePredicate)cond);
        } else if (cond instanceof NullPredicate) {
            BufferManager.nullPredicate((NullPredicate)cond);
        } else if (cond instanceof QuantifiedComparisonPredicate) {
            BufferManager.quantifiedComparisonPredicate((QuantifiedComparisonPredicate)cond);
        }
    }

    private static void booleanAnd(BooleanAnd oper) throws SQLException {
        SearchCondition[] conds = oper.getOperands();
        int i = 0;
        while (i < conds.length) {
            BufferManager.searchCondition(conds[i]);
            ++i;
        }
    }

    private static void booleanOr(BooleanOr oper) throws SQLException {
        SearchCondition[] conds = oper.getOperands();
        int i = 0;
        while (i < conds.length) {
            BufferManager.searchCondition(conds[i]);
            ++i;
        }
    }

    private static void booleanNot(BooleanNot oper) throws SQLException {
        BufferManager.searchCondition(oper.getOperand());
    }

    private static void betweenPredicate(BetweenPredicate pred) throws SQLException {
        BufferManager.rowValue(pred.getHighValue());
        BufferManager.rowValue(pred.getLowValue());
        BufferManager.rowValue(pred.getValue());
    }

    private static void comparisonPredicate(ComparisonPredicate pred) throws SQLException {
        BufferManager.rowValue(pred.getLeftOperand());
        BufferManager.rowValue(pred.getRightOperand());
    }

    private static int existsPredicate(ExistsPredicate pred) throws SQLException {
        throw treeTooComplexException;
    }

    private static void inListPredicate(InListPredicate pred) throws SQLException {
        BufferManager.valueExpression(pred.getValue());
        ValueExpression[] expr = pred.getValueList();
        int i = 0;
        while (i < expr.length) {
            BufferManager.valueExpression(expr[i]);
            ++i;
        }
    }

    private static void inSubqueryPredicate(InSubqueryPredicate pred) throws SQLException {
        throw treeTooComplexException;
    }

    private static void likePredicate(LikePredicate pred) throws SQLException {
        ValueExpression escape = pred.getEscapeValue();
        if (escape != null) {
            BufferManager.valueExpression(escape);
        }
        BufferManager.valueExpression(pred.getMatchValue());
        BufferManager.valueExpression(pred.getPatternValue());
    }

    private static void nullPredicate(NullPredicate pred) throws SQLException {
        BufferManager.valueExpression(pred.getValue());
    }

    private static void quantifiedComparisonPredicate(QuantifiedComparisonPredicate pred) throws SQLException {
        throw treeTooComplexException;
    }

    private static void rowValue(RowValue value) throws SQLException {
        if (!(value instanceof ValueExpression)) {
            throw treeTooComplexException;
        }
        BufferManager.valueExpression((ValueExpression)value);
    }

    private static void valueExpression(ValueExpression expr) throws SQLException {
        if (expr instanceof ArithmeticExpression) {
            BufferManager.arithmeticExpression((ArithmeticExpression)expr);
        } else if (!(expr instanceof ColumnReference || expr instanceof HostVariable || expr instanceof Literal)) {
            throw treeTooComplexException;
        }
    }

    private static void arithmeticExpression(ArithmeticExpression expr) throws SQLException {
        ValueExpression left = expr.getLeftOperand();
        if (left != null) {
            BufferManager.valueExpression(left);
        }
        BufferManager.valueExpression(expr.getRightOperand());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

