/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sync;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.cluster.ApplicationClusterContext;
import com.sap.engine.frame.cluster.message.ListenerAlreadyRegisteredException;
import com.sap.engine.frame.cluster.message.MessageContext;
import com.sap.engine.frame.cluster.message.MessageListener;
import com.sap.sql.jdbc.ConnectionContext;
import com.sap.sql.jdbc.VMContext;
import com.sap.sql.log.Syslog;
import com.sap.sql.services.core.CoreServices;
import com.sap.sql.sync.DbTableSyncWriter;
import com.sap.sql.sync.MessageSyncReader;
import com.sap.sql.sync.MessageSyncWriter;
import com.sap.sql.sync.SyncWriter;
import com.sap.tc.logging.Location;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Properties;

public class SyncWriterFactory {
    private static boolean initialized = false;
    private static String implementation;
    private static String logTableName;
    private static MessageContext msgContext;
    private static boolean writerActive;
    private static boolean sendAsynchronous;
    private static final Location TRACE;
    static /* synthetic */ Class class$com$sap$sql$sync$SyncWriterFactory;

    private SyncWriterFactory() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized SyncWriter createSyncWriter(ConnectionContext connectionContext) throws SQLException {
        SyncWriter syncWriter;
        block11: {
            MessageSyncWriter messageSyncWriter;
            block10: {
                DbTableSyncWriter dbTableSyncWriter;
                block9: {
                    SyncWriter syncWriter2;
                    block8: {
                        String myMethodName = "createSyncWriter";
                        TRACE.entering("createSyncWriter", new Object[]{connectionContext});
                        try {
                            if (VMContext.isJ2EEServerActive() && VMContext.getVMID() <= 0) {
                                syncWriter2 = null;
                                Object var4_7 = null;
                                break block8;
                            }
                            if (!initialized) {
                                SyncWriterFactory.initSyncProperties(connectionContext);
                            }
                            if (writerActive) {
                                if (sendAsynchronous) {
                                    dbTableSyncWriter = new DbTableSyncWriter(CoreServices.getNativeConnection(connectionContext), logTableName);
                                    break block9;
                                }
                                try {
                                    msgContext.registerListener((MessageListener)new MessageSyncReader());
                                }
                                catch (ListenerAlreadyRegisteredException e) {
                                    throw Syslog.createAndLogOpenSQLException(class$com$sap$sql$sync$SyncWriterFactory == null ? (class$com$sap$sql$sync$SyncWriterFactory = SyncWriterFactory.class$("com.sap.sql.sync.SyncWriterFactory")) : class$com$sap$sql$sync$SyncWriterFactory, "com.sap.sql.sync_1031", new Object[]{e.getMessage()}, (Throwable)e);
                                }
                                messageSyncWriter = new MessageSyncWriter(msgContext);
                                break block10;
                            }
                            syncWriter = null;
                            break block11;
                        }
                        catch (Throwable throwable) {
                            Object var4_11 = null;
                            TRACE.exiting();
                            throw throwable;
                        }
                    }
                    TRACE.exiting();
                    return syncWriter2;
                }
                Object var4_8 = null;
                TRACE.exiting();
                return dbTableSyncWriter;
            }
            Object var4_9 = null;
            TRACE.exiting();
            return messageSyncWriter;
        }
        Object var4_10 = null;
        TRACE.exiting();
        return syncWriter;
    }

    public static synchronized MessageSyncWriter createMessageSyncWriter(boolean waitForAnswer, long timeout) throws SQLException {
        ApplicationServiceContext serviceCtx = SyncWriterFactory.getAppContext();
        ApplicationClusterContext clusterCtx = serviceCtx.getClusterContext();
        MessageContext myMessageCtx = clusterCtx.getMessageContext();
        try {
            myMessageCtx.registerListener((MessageListener)new MessageSyncReader());
        }
        catch (ListenerAlreadyRegisteredException e) {
            throw Syslog.createAndLogOpenSQLException(class$com$sap$sql$sync$SyncWriterFactory == null ? (class$com$sap$sql$sync$SyncWriterFactory = SyncWriterFactory.class$("com.sap.sql.sync.SyncWriterFactory")) : class$com$sap$sql$sync$SyncWriterFactory, "com.sap.sql.sync_1031", new Object[]{e.getMessage()}, (Throwable)e);
        }
        return new MessageSyncWriter(myMessageCtx, waitForAnswer, timeout);
    }

    private static void initSyncProperties(ConnectionContext connectionContext) throws SQLException {
        String implProp;
        Properties props = connectionContext.getProperties();
        implementation = props.getProperty(implProp = "com.sap.sql.sync.implementation");
        if (implementation == null) {
            throw Syslog.createAndLogOpenSQLException(class$com$sap$sql$sync$SyncWriterFactory == null ? (class$com$sap$sql$sync$SyncWriterFactory = SyncWriterFactory.class$("com.sap.sql.sync.SyncWriterFactory")) : class$com$sap$sql$sync$SyncWriterFactory, "com.sap.sql_0013", new Object[]{implProp});
        }
        writerActive = Boolean.valueOf(props.getProperty("com.sap.sql.sync.writer.active"));
        if (implementation.equalsIgnoreCase("none") || !writerActive) {
            initialized = true;
            return;
        }
        if (implementation.equalsIgnoreCase("table")) {
            sendAsynchronous = true;
            logTableName = props.getProperty("com.sap.sql.sync.storage");
        } else if (implementation.equalsIgnoreCase("message")) {
            sendAsynchronous = false;
            ApplicationServiceContext serviceCtx = SyncWriterFactory.getAppContext();
            ApplicationClusterContext clusterCtx = serviceCtx.getClusterContext();
            msgContext = clusterCtx.getMessageContext();
        } else {
            throw Syslog.createAndLogOpenSQLException(class$com$sap$sql$sync$SyncWriterFactory == null ? (class$com$sap$sql$sync$SyncWriterFactory = SyncWriterFactory.class$("com.sap.sql.sync.SyncWriterFactory")) : class$com$sap$sql$sync$SyncWriterFactory, "com.sap.sql_0014", new Object[]{implProp, implementation});
        }
        initialized = true;
    }

    private static ApplicationServiceContext getAppContext() throws SQLException {
        Class<?> cl = null;
        Method m = null;
        ApplicationServiceContext asc = null;
        try {
            cl = Class.forName("com.sap.engine.services.dbpool.PoolFrame");
        }
        catch (ClassNotFoundException e) {
            throw Syslog.createAndLogOpenSQLException(class$com$sap$sql$sync$SyncWriterFactory == null ? (class$com$sap$sql$sync$SyncWriterFactory = SyncWriterFactory.class$("com.sap.sql.sync.SyncWriterFactory")) : class$com$sap$sql$sync$SyncWriterFactory, "com.sap.sql_0006", new Object[]{"PoolFrame"}, (Throwable)e);
        }
        try {
            m = cl.getMethod("getAppContext", null);
        }
        catch (NoSuchMethodException e) {
            throw Syslog.createAndLogOpenSQLException(class$com$sap$sql$sync$SyncWriterFactory == null ? (class$com$sap$sql$sync$SyncWriterFactory = SyncWriterFactory.class$("com.sap.sql.sync.SyncWriterFactory")) : class$com$sap$sql$sync$SyncWriterFactory, "com.sap.sql_0007", new Object[]{"Method getAppContext() not found"}, (Throwable)e);
        }
        try {
            asc = (ApplicationServiceContext)m.invoke(null, null);
        }
        catch (Exception e) {
            throw Syslog.createAndLogOpenSQLException(class$com$sap$sql$sync$SyncWriterFactory == null ? (class$com$sap$sql$sync$SyncWriterFactory = SyncWriterFactory.class$("com.sap.sql.sync.SyncWriterFactory")) : class$com$sap$sql$sync$SyncWriterFactory, "com.sap.sql_0007", new Object[]{"Error on invocation of getAppContext()"}, (Throwable)e);
        }
        return asc;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        writerActive = false;
        sendAsynchronous = true;
        TRACE = Location.getLocation((Class)(class$com$sap$sql$sync$SyncWriterFactory == null ? (class$com$sap$sql$sync$SyncWriterFactory = SyncWriterFactory.class$("com.sap.sql.sync.SyncWriterFactory")) : class$com$sap$sql$sync$SyncWriterFactory));
    }
}

