/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sync;

import com.sap.sql.j2ee.EventRegistry;
import com.sap.sql.jdbc.ConnectionContext;
import com.sap.sql.jdbc.VMContext;
import com.sap.sql.log.Syslog;
import com.sap.sql.sync.DbTableSyncReader;
import com.sap.sql.sync.SyncTimeoutListener;
import com.sap.tc.logging.Location;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class SyncReaderFactory {
    private static boolean initialized = false;
    private static String implementation;
    private static String logTableName;
    private static boolean readerActive;
    private static long readerDelay;
    private static long readerPeriod;
    private static Hashtable readers;
    private static SyncTimeoutListener timeoutListener;
    private static final Location TRACE;
    static /* synthetic */ Class class$com$sap$sql$sync$SyncReaderFactory;

    private SyncReaderFactory() {
    }

    public static synchronized void createSyncReader(ConnectionContext connectionContext) throws SQLException {
        String myMethodName = "createSyncReader";
        TRACE.entering("createSyncReader", new Object[]{connectionContext});
        if (!initialized) {
            SyncReaderFactory.initSyncProperties(connectionContext);
        }
        try {
            if (readerActive && VMContext.isJ2EEServerActive()) {
                if (VMContext.getVMID() <= 0) {
                    throw Syslog.createAndLogOpenSQLException(class$com$sap$sql$sync$SyncReaderFactory == null ? (class$com$sap$sql$sync$SyncReaderFactory = SyncReaderFactory.class$("com.sap.sql.sync.SyncReaderFactory")) : class$com$sap$sql$sync$SyncReaderFactory, "com.sap.sql.sync_1026", new Object[]{new Integer(VMContext.getVMID())});
                }
                EventRegistry eventRegistry = EventRegistry.getInstance();
                if (eventRegistry == null) {
                    throw Syslog.createAndLogOpenSQLException(class$com$sap$sql$sync$SyncReaderFactory == null ? (class$com$sap$sql$sync$SyncReaderFactory = SyncReaderFactory.class$("com.sap.sql.sync.SyncReaderFactory")) : class$com$sap$sql$sync$SyncReaderFactory, "com.sap.sql.sync_1027", null);
                }
                if (timeoutListener == null) {
                    timeoutListener = new SyncTimeoutListener();
                    eventRegistry.addTimeoutListener(timeoutListener, readerDelay, readerPeriod);
                }
                DbTableSyncReader syncReader = new DbTableSyncReader(logTableName);
                readers.put(connectionContext.getConnectionName(), syncReader);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            TRACE.exiting();
            throw throwable;
        }
        TRACE.exiting();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized void startSyncReader(String dataSourceName) throws SQLException {
        block6: {
            block5: {
                String myMethodName = "startSyncReader";
                TRACE.entering("startSyncReader", new Object[]{dataSourceName});
                try {
                    DataSource dataSource;
                    DbTableSyncReader syncReader = (DbTableSyncReader)readers.get(dataSourceName);
                    if (syncReader == null) {
                        Object var7_3 = null;
                        break block5;
                    }
                    String dsName = "jdbc/" + dataSourceName;
                    try {
                        InitialContext ctx = new InitialContext();
                        dataSource = (DataSource)ctx.lookup(dsName);
                    }
                    catch (NamingException ex) {
                        throw Syslog.createAndLogOpenSQLException(class$com$sap$sql$sync$SyncReaderFactory == null ? (class$com$sap$sql$sync$SyncReaderFactory = SyncReaderFactory.class$("com.sap.sql.sync.SyncReaderFactory")) : class$com$sap$sql$sync$SyncReaderFactory, "com.sap.sql.sync_1028", new Object[]{dsName}, (Throwable)ex);
                    }
                    syncReader.start(dataSource);
                    timeoutListener.addSyncReader(syncReader);
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var7_5 = null;
                    TRACE.exiting();
                    throw throwable;
                }
            }
            TRACE.exiting();
            return;
        }
        Object var7_4 = null;
        TRACE.exiting();
    }

    public static synchronized void stopSyncReader(String dataSourceName) {
        String myMethodName = "stopSyncReader";
        TRACE.entering("stopSyncReader", new Object[]{dataSourceName});
        DbTableSyncReader syncReader = (DbTableSyncReader)readers.get(dataSourceName);
        if (syncReader != null) {
            timeoutListener.removeSyncReader(syncReader);
            readers.remove(dataSourceName);
        }
        TRACE.exiting();
    }

    private static void initSyncProperties(ConnectionContext connectionContext) throws SQLException {
        String implProp;
        Properties props = connectionContext.getProperties();
        implementation = props.getProperty(implProp = "com.sap.sql.sync.implementation");
        if (implementation == null) {
            throw Syslog.createAndLogOpenSQLException(class$com$sap$sql$sync$SyncReaderFactory == null ? (class$com$sap$sql$sync$SyncReaderFactory = SyncReaderFactory.class$("com.sap.sql.sync.SyncReaderFactory")) : class$com$sap$sql$sync$SyncReaderFactory, "com.sap.sql_0013", new Object[]{implProp});
        }
        readerActive = Boolean.valueOf(props.getProperty("com.sap.sql.sync.reader.active"));
        if (implementation.equalsIgnoreCase("none") || !readerActive) {
            initialized = true;
            return;
        }
        if (!implementation.equalsIgnoreCase("table") && !implementation.equalsIgnoreCase("message")) {
            throw Syslog.createAndLogOpenSQLException(class$com$sap$sql$sync$SyncReaderFactory == null ? (class$com$sap$sql$sync$SyncReaderFactory = SyncReaderFactory.class$("com.sap.sql.sync.SyncReaderFactory")) : class$com$sap$sql$sync$SyncReaderFactory, "com.sap.sql_0014", new Object[]{implProp, implementation});
        }
        logTableName = props.getProperty("com.sap.sql.sync.storage");
        readerDelay = Long.parseLong(props.getProperty("com.sap.sql.sync.reader.delay")) * 1000L;
        readerPeriod = Long.parseLong(props.getProperty("com.sap.sql.sync.reader.period")) * 1000L;
        initialized = true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        readerActive = false;
        readers = new Hashtable();
        timeoutListener = null;
        TRACE = Location.getLocation((Class)(class$com$sap$sql$sync$SyncReaderFactory == null ? (class$com$sap$sql$sync$SyncReaderFactory = SyncReaderFactory.class$("com.sap.sql.sync.SyncReaderFactory")) : class$com$sap$sql$sync$SyncReaderFactory));
    }
}

