/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sync;

import com.sap.engine.frame.cluster.ClusterException;
import com.sap.engine.frame.cluster.message.MessageContext;
import com.sap.sql.log.OpenSQLException;
import com.sap.sql.log.Syslog;
import com.sap.sql.sync.SyncManager;
import com.sap.sql.sync.SyncRecordOutputStream;
import com.sap.sql.sync.SyncWriter;
import com.sap.tc.logging.Location;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class MessageSyncWriter
implements SyncWriter {
    private static final int myMessageType = 4711;
    private static final int groupId = -1;
    private static final byte nodeType = -1;
    private SyncManager syncMan;
    private boolean waitForAnswer = false;
    private long timeout = 0L;
    private MessageContext msgCtx;
    private Collection syncRecordList;
    private static final Location TRACE = Location.getLocation((Class)(class$com$sap$sql$sync$MessageSyncWriter == null ? (class$com$sap$sql$sync$MessageSyncWriter = MessageSyncWriter.class$("com.sap.sql.sync.MessageSyncWriter")) : class$com$sap$sql$sync$MessageSyncWriter));
    static /* synthetic */ Class class$com$sap$sql$sync$MessageSyncWriter;

    public MessageSyncWriter(MessageContext msgContext) {
        TRACE.entering("MessageSyncWriter()");
        this.syncMan = SyncManager.getInstance();
        this.msgCtx = msgContext;
        this.syncRecordList = new ArrayList();
        TRACE.exiting();
    }

    public MessageSyncWriter(MessageContext msgContext, boolean waitForAnswer, long timeout) {
        TRACE.entering("MessageSyncWriter()");
        this.syncMan = SyncManager.getInstance();
        this.msgCtx = msgContext;
        this.waitForAnswer = waitForAnswer;
        this.timeout = timeout;
        this.syncRecordList = new ArrayList();
        TRACE.exiting();
    }

    public void syncRequest(String bufferHandlerId, SyncRecordOutputStream sros) throws OpenSQLException {
        String myMethodName = "syncRequest(String, SyncRecordOutputStream)";
        TRACE.entering("syncRequest(String, SyncRecordOutputStream)", new Object[]{bufferHandlerId, sros});
        if (!this.syncMan.isBufferHandlerIdValid(bufferHandlerId)) {
            throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.sync_1024", new Object[]{bufferHandlerId});
        }
        this.syncRecordList.add(bufferHandlerId);
        this.syncRecordList.add(sros);
        TRACE.exiting();
    }

    public void flushRequests() throws OpenSQLException {
        TRACE.entering("flushRequests()");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        Iterator i = this.syncRecordList.iterator();
        while (i.hasNext()) {
            String bufferHandlerId = (String)i.next();
            TRACE.debugT("bufferHandlerId: " + bufferHandlerId);
            SyncRecordOutputStream sros = (SyncRecordOutputStream)i.next();
            try {
                dos.writeUTF(bufferHandlerId);
                dos.writeInt(sros.size());
                dos.write(sros.toByteArray());
            }
            catch (IOException e) {
                throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.sync_1025", null, (Throwable)e);
            }
        }
        if (!this.syncRecordList.isEmpty()) {
            try {
                if (this.waitForAnswer) {
                    this.msgCtx.sendAndWaitForAnswer(-1, (byte)-1, 4711, baos.toByteArray(), 0, baos.toByteArray().length, this.timeout);
                } else {
                    this.msgCtx.send(-1, (byte)-1, 4711, baos.toByteArray(), 0, baos.toByteArray().length);
                }
                TRACE.debugT("Message sent!");
            }
            catch (ClusterException e) {
                throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.sync_1025", null, (Throwable)e);
            }
            this.syncRecordList.clear();
        }
        TRACE.exiting();
    }

    public void undoRequests() {
        TRACE.entering("undoRequests()");
        this.syncRecordList.clear();
        TRACE.exiting();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

