/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sync;

import com.sap.engine.frame.cluster.message.MessageAnswer;
import com.sap.engine.frame.cluster.message.MessageListener;
import com.sap.sql.log.Syslog;
import com.sap.sql.sync.SyncManager;
import com.sap.sql.sync.SyncReader;
import com.sap.sql.sync.SyncRecordInputStream;
import com.sap.sql.sync.Synchronizer;
import com.sap.tc.logging.Location;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class MessageSyncReader
implements SyncReader,
MessageListener {
    private SyncManager syncMan;
    private static final Location TRACE = Location.getLocation((Class)(class$com$sap$sql$sync$MessageSyncReader == null ? (class$com$sap$sql$sync$MessageSyncReader = MessageSyncReader.class$("com.sap.sql.sync.MessageSyncReader")) : class$com$sap$sql$sync$MessageSyncReader));
    static /* synthetic */ Class class$com$sap$sql$sync$MessageSyncReader;

    public MessageSyncReader() {
        TRACE.entering("MessageSyncReader()");
        this.syncMan = SyncManager.getInstance();
        TRACE.exiting();
    }

    public void performSynchronisation() {
    }

    public void receive(int clusterId, int messageType, byte[] body, int offset, int length) {
        TRACE.entering("receive()");
        this.decodeMessage(body, length);
        TRACE.exiting();
    }

    public MessageAnswer receiveWait(int clusterId, int messageType, byte[] body, int offset, int length) {
        TRACE.entering("receiveWait()");
        this.decodeMessage(body, length);
        TRACE.exiting();
        return null;
    }

    private void decodeMessage(byte[] message, int msgLength) {
        ByteArrayInputStream bais = new ByteArrayInputStream(message);
        DataInputStream dis = new DataInputStream(bais);
        int logLength = msgLength;
        try {
            TRACE.debugT("Message reveived!");
            while (logLength > 0) {
                try {
                    String bufferHandlerId = dis.readUTF();
                    TRACE.debugT("DbTableSyncReader", "bufferHandlerId: " + bufferHandlerId);
                    logLength -= bufferHandlerId.length() + 2;
                    int syncReqLength = dis.readInt();
                    TRACE.debugT("DbTableSyncReader", "syncReqLength: " + syncReqLength);
                    logLength -= 4;
                    byte[] syncRequest = new byte[syncReqLength];
                    dis.readFully(syncRequest);
                    TRACE.debugT("syncRequest: " + new String(syncRequest));
                    logLength -= syncReqLength;
                    this.performInvalidation(bufferHandlerId, syncRequest);
                }
                catch (IOException e) {
                    Syslog.createAndLogOpenSQLException(this, "com.sap.sql.sync_1023", new Object[]{e.getMessage()}, (Throwable)e);
                }
            }
            if (logLength != 0) {
                Syslog.logError(this, "com.sap.sql.sync_1021", new Object[]{new Integer(logLength)});
            }
        }
        catch (Throwable t) {
            Syslog.createAndLogOpenSQLException(this, "com.sap.sql.sync_1022", new Object[]{t.toString()}, t);
        }
    }

    private void performInvalidation(String bufferHandlerId, byte[] syncReq) {
        SyncRecordInputStream sris = new SyncRecordInputStream(syncReq);
        Synchronizer bufferHandler = this.syncMan.getBufferHandler(bufferHandlerId);
        bufferHandler.synchronize(sris);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

