/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sync;

import com.sap.sql.jdbc.VMContext;
import com.sap.sql.log.OpenSQLException;
import com.sap.sql.log.Syslog;
import com.sap.sql.services.core.CoreServices;
import com.sap.sql.sync.SyncManager;
import com.sap.sql.sync.SyncRecordOutputStream;
import com.sap.sql.sync.SyncWriter;
import com.sap.tc.logging.Location;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

public class DbTableSyncWriter
implements SyncWriter {
    private static final String defaultLogTableName = "\"BC_SYNCLOG\"";
    private static final int vmId = VMContext.getVMID();
    private String logTableName = "\"BC_SYNCLOG\"";
    private Connection conn;
    private SyncManager syncMan;
    private Collection syncRecordList;
    private static final Location TRACE = Location.getLocation((Class)(class$com$sap$sql$sync$DbTableSyncWriter == null ? (class$com$sap$sql$sync$DbTableSyncWriter = DbTableSyncWriter.class$("com.sap.sql.sync.DbTableSyncWriter")) : class$com$sap$sql$sync$DbTableSyncWriter));
    static /* synthetic */ Class class$com$sap$sql$sync$DbTableSyncWriter;

    public DbTableSyncWriter(Connection conn, String logTableName) {
        this.conn = CoreServices.getNativeConnection(conn);
        this.syncMan = SyncManager.getInstance();
        this.syncRecordList = new ArrayList();
        if (logTableName != null) {
            this.logTableName = "\"" + logTableName + "\"";
        }
    }

    public void syncRequest(String bufferHandlerId, SyncRecordOutputStream sros) throws OpenSQLException {
        String myMethodName = "syncRequest(String, SyncRecordOutputStream)";
        TRACE.entering("syncRequest(String, SyncRecordOutputStream)", new Object[]{bufferHandlerId, sros});
        try {
            if (!this.syncMan.isBufferHandlerIdValid(bufferHandlerId)) {
                throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.sync_1024", new Object[]{bufferHandlerId});
            }
            this.syncRecordList.add(bufferHandlerId);
            this.syncRecordList.add(sros);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            TRACE.exiting();
            throw throwable;
        }
        TRACE.exiting();
    }

    public void flushRequests() throws OpenSQLException {
        int NoteBookMaxLength = 1000000;
        int PackagingLength = 6;
        TRACE.entering("flushRequests()");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            Iterator i = this.syncRecordList.iterator();
            while (i.hasNext()) {
                String bufferHandlerId = (String)i.next();
                TRACE.debugT("DbTableSyncWriter", "BufferHandlerId: " + bufferHandlerId);
                SyncRecordOutputStream sros = (SyncRecordOutputStream)i.next();
                if (dos.size() + sros.size() + bufferHandlerId.length() + 6 > 1000000) {
                    this.writeLog(baos.toByteArray());
                    baos = new ByteArrayOutputStream();
                    dos = new DataOutputStream(baos);
                }
                try {
                    dos.writeUTF(bufferHandlerId);
                    dos.writeInt(sros.size());
                    dos.write(sros.toByteArray());
                }
                catch (IOException e) {
                    throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.sync_1025", null, (Throwable)e);
                }
            }
            if (!this.syncRecordList.isEmpty()) {
                this.writeLog(baos.toByteArray());
                this.syncRecordList.clear();
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            TRACE.exiting();
            throw throwable;
        }
        TRACE.exiting();
    }

    public void undoRequests() {
        TRACE.entering("undoRequests()");
        this.syncRecordList.clear();
        TRACE.exiting();
    }

    private void writeLog(byte[] notebook) throws OpenSQLException {
        boolean isDuplicate;
        long utcTime = 0L;
        TRACE.debugT("Notebook length: " + notebook.length);
        try {
            utcTime = ((Date)CoreServices.getUTCTimestamp(this.conn)).getTime();
        }
        catch (SQLException e) {
            throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.sync_1025", new Object[]{"getUTCTimestamp() failed"}, (Throwable)e);
        }
        do {
            TRACE.debugT("Timestamp: " + utcTime);
            isDuplicate = this.insertIntoSyncLog(utcTime, vmId, notebook);
            ++utcTime;
        } while (isDuplicate);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean insertIntoSyncLog(long utcTime, int vmId, byte[] notebook) throws OpenSQLException {
        String sql = "insert into " + this.logTableName + " (\"TIMESTMP\", \"VMID\", \"NOTEBOOK\") values (?, ?, ?)";
        boolean isDuplicate = false;
        PreparedStatement ps = null;
        try {
            try {
                ps = this.conn.prepareStatement(sql);
                ps.setLong(1, utcTime);
                ps.setInt(2, vmId);
                ps.setBytes(3, notebook);
                ps.executeUpdate();
            }
            catch (SQLException e) {
                try {
                    isDuplicate = CoreServices.isDuplicateKeyException(this.conn, e);
                }
                catch (SQLException serviceEx) {
                    throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.sync_1025", null, (Throwable)serviceEx);
                }
                if (!isDuplicate) {
                    throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.sync_1025", null, (Throwable)e);
                }
                Object var11_8 = null;
                if (ps == null) return isDuplicate;
                try {
                    ps.close();
                    return isDuplicate;
                }
                catch (SQLException closeEx) {
                    throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.sync_1025", null, (Throwable)closeEx);
                }
            }
            Object var11_7 = null;
            if (ps == null) return isDuplicate;
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            if (ps == null) throw throwable;
            try {}
            catch (SQLException closeEx) {
                throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.sync_1025", null, (Throwable)closeEx);
            }
            ps.close();
            throw throwable;
        }
        try {}
        catch (SQLException closeEx) {
            throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.sync_1025", null, (Throwable)closeEx);
        }
        ps.close();
        return isDuplicate;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

