/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlparser;

import com.sap.sql.tree.ArithmeticExpression;
import com.sap.sql.tree.BetweenPredicate;
import com.sap.sql.tree.BigDecimalLiteral;
import com.sap.sql.tree.BooleanAnd;
import com.sap.sql.tree.BooleanNot;
import com.sap.sql.tree.BooleanOr;
import com.sap.sql.tree.ColumnReference;
import com.sap.sql.tree.ComparisonOperator;
import com.sap.sql.tree.ComparisonPredicate;
import com.sap.sql.tree.ConcatenationExpression;
import com.sap.sql.tree.CountAll;
import com.sap.sql.tree.DefaultValue;
import com.sap.sql.tree.DeleteStatement;
import com.sap.sql.tree.DerivedTable;
import com.sap.sql.tree.ExistsPredicate;
import com.sap.sql.tree.FloatLiteral;
import com.sap.sql.tree.HostVariable;
import com.sap.sql.tree.InListPredicate;
import com.sap.sql.tree.InSubqueryPredicate;
import com.sap.sql.tree.InsertStatement;
import com.sap.sql.tree.IntegerLiteral;
import com.sap.sql.tree.JoinedTable;
import com.sap.sql.tree.LikePredicate;
import com.sap.sql.tree.NonJoinQuery;
import com.sap.sql.tree.NullPredicate;
import com.sap.sql.tree.NullValue;
import com.sap.sql.tree.QuantifiedComparisonPredicate;
import com.sap.sql.tree.Query;
import com.sap.sql.tree.QuerySpecification;
import com.sap.sql.tree.RowValue;
import com.sap.sql.tree.RowValueElement;
import com.sap.sql.tree.RowValueElementList;
import com.sap.sql.tree.SQLStatement;
import com.sap.sql.tree.SQLVisitor;
import com.sap.sql.tree.SearchCondition;
import com.sap.sql.tree.SelectForUpdateStatement;
import com.sap.sql.tree.SelectStatement;
import com.sap.sql.tree.SelectSublist;
import com.sap.sql.tree.SetClause;
import com.sap.sql.tree.SetFunction;
import com.sap.sql.tree.SortSpecification;
import com.sap.sql.tree.StringLiteral;
import com.sap.sql.tree.TableReference;
import com.sap.sql.tree.TableValue;
import com.sap.sql.tree.UpdateStatement;
import com.sap.sql.tree.ValueExpression;

public class DumpVisitor
extends SQLVisitor {
    private static final int INDENT = 2;
    private int indentation = 0;

    private void _print(String what) {
        System.out.print(what + " ");
    }

    private void _println(String what) {
        System.out.println(what);
    }

    private void _println() {
        System.out.println();
    }

    private void _printComparisonOperator(int op) {
        switch (op) {
            case 1: {
                this._print("EQ");
                break;
            }
            case 2: {
                this._print("NE");
                break;
            }
            case 3: {
                this._print("LT");
                break;
            }
            case 4: {
                this._print("LE");
                break;
            }
            case 5: {
                this._print("GT");
                break;
            }
            case 6: {
                this._print("GE");
            }
        }
    }

    private void indent() {
        int i = 0;
        while (i < this.indentation) {
            System.out.print(" ");
            ++i;
        }
    }

    private void print(String what) {
        this.indent();
        this._print(what);
    }

    private void println(String what) {
        this.print(what);
        this._println();
    }

    public void visitArithmeticExpressionBefore(ArithmeticExpression x) {
        this.print(x.toString());
        switch (x.getOperator()) {
            case 1: {
                this._println("+");
                break;
            }
            case 2: {
                this._println("-");
                break;
            }
            case 3: {
                this._println("*");
                break;
            }
            case 4: {
                this._println("/");
            }
        }
        this.indentation += 2;
    }

    public void visitArithmeticExpression(ArithmeticExpression x) {
        this.indentation -= 2;
    }

    public void visitBetweenPredicateBefore(BetweenPredicate x) {
        this.print(x.toString());
        if (x.isNotBetween()) {
            this._println("NOT");
        } else {
            this._println();
        }
        this.indentation += 2;
    }

    public void visitBetweenPredicate(BetweenPredicate x) {
        this.indentation -= 2;
    }

    public void visitBigDecimalLiteralBefore(BigDecimalLiteral x) {
        this.print(x.toString());
        this._println(x.getValue().toString());
        this.indentation += 2;
    }

    public void visitBigDecimalLiteral(BigDecimalLiteral x) {
        this.indentation -= 2;
    }

    public void visitBooleanAndBefore(BooleanAnd x) {
        this.println(x.toString());
        this.indentation += 2;
    }

    public void visitBooleanAnd(BooleanAnd x) {
        this.indentation -= 2;
    }

    public void visitBooleanNotBefore(BooleanNot x) {
        this.println(x.toString());
        this.indentation += 2;
    }

    public void visitBooleanNot(BooleanNot x) {
        this.indentation -= 2;
    }

    public void visitBooleanOrBefore(BooleanOr x) {
        this.println(x.toString());
        this.indentation += 2;
    }

    public void visitBooleanOr(BooleanOr x) {
        this.indentation -= 2;
    }

    public void visitColumnReferenceBefore(ColumnReference x) {
        this.print(x.toString());
        String tableName = x.getTableName();
        if (null != tableName) {
            this._println(tableName + "." + x.getColumnName());
        } else {
            this._println(x.getColumnName());
        }
        this.indentation += 2;
    }

    public void visitColumnReference(ColumnReference x) {
        this.indentation -= 2;
    }

    public void visitComparisonOperatorBefore(ComparisonOperator x) {
        this.println(x.toString());
        this.indentation += 2;
    }

    public void visitComparisonOperator(ComparisonOperator x) {
        this.indentation -= 2;
    }

    public void visitComparisonPredicateBefore(ComparisonPredicate x) {
        this.print(x.toString());
        this._printComparisonOperator(x.getOperator());
        this._println();
        this.indentation += 2;
    }

    public void visitComparisonPredicate(ComparisonPredicate x) {
        this.indentation -= 2;
    }

    public void visitConcatenationExpressionBefore(ConcatenationExpression x) {
        this.println(x.toString());
        this.indentation += 2;
    }

    public void visitConcatenationExpression(ConcatenationExpression x) {
        this.indentation -= 2;
    }

    public void visitCountAllBefore(CountAll x) {
        this.println(x.toString());
        this.indentation += 2;
    }

    public void visitCountAll(CountAll x) {
        this.indentation -= 2;
    }

    public void visitDefaultValueBefore(DefaultValue x) {
        this.println(x.toString());
        this.indentation += 2;
    }

    public void visitDefaultValue(DefaultValue x) {
        this.indentation -= 2;
    }

    public void visitDeleteStatementBefore(DeleteStatement x) {
        this.println(x.toString());
        this.indentation += 2;
    }

    public void visitDeleteStatement(DeleteStatement x) {
        this.indentation -= 2;
    }

    public void visitDerivedTableBefore(DerivedTable x) {
        this.print(x.toString());
        this._println(x.getCorrelationName());
        this.indentation += 2;
    }

    public void visitDerivedTable(DerivedTable x) {
        this.indentation -= 2;
    }

    public void visitExistsPredicateBefore(ExistsPredicate x) {
        this.println(x.toString());
        this.indentation += 2;
    }

    public void visitExistsPredicate(ExistsPredicate x) {
        this.indentation -= 2;
    }

    public void visitFloatLiteralBefore(FloatLiteral x) {
        this.print(x.toString());
        this._println(Float.toString(x.getValue()));
        this.indentation += 2;
    }

    public void visitFloatLiteral(FloatLiteral x) {
        this.indentation -= 2;
    }

    public void visitHostVariableBefore(HostVariable x) {
        this.print(x.toString());
        this._println(Integer.toString(x.getPosition()));
        this.indentation += 2;
    }

    public void visitHostVariable(HostVariable x) {
        this.indentation -= 2;
    }

    public void visitInListPredicateBefore(InListPredicate x) {
        this.print(x.toString());
        if (x.isNotIn()) {
            this._println("NOT");
        } else {
            this._println();
        }
        this.indentation += 2;
    }

    public void visitInListPredicate(InListPredicate x) {
        this.indentation -= 2;
    }

    public void visitInsertStatementBefore(InsertStatement x) {
        this.println(x.toString());
        this.indentation += 2;
    }

    public void visitInsertStatement(InsertStatement x) {
        this.indentation -= 2;
    }

    public void visitInSubqueryPredicateBefore(InSubqueryPredicate x) {
        this.print(x.toString());
        if (x.isNotIn()) {
            this._println("NOT");
        } else {
            this._println();
        }
        this.indentation += 2;
    }

    public void visitInSubqueryPredicate(InSubqueryPredicate x) {
        this.indentation -= 2;
    }

    public void visitIntegerLiteralBefore(IntegerLiteral x) {
        this.print(x.toString());
        this._println(x.getValue().toString());
        this.indentation += 2;
    }

    public void visitIntegerLiteral(IntegerLiteral x) {
        this.indentation -= 2;
    }

    public void visitJoinedTableBefore(JoinedTable x) {
        this.print(x.toString());
        switch (x.getJoinType()) {
            case 1: {
                this._println("CROSS JOIN");
                break;
            }
            case 2: {
                this._println("UNION JOIN");
                break;
            }
            case 3: {
                this._println("INNER JOIN");
                break;
            }
            case 4: {
                this._println("NATURAL INNER JOIN");
                break;
            }
            case 5: {
                this._println("LEFT OUTER JOIN");
                break;
            }
            case 6: {
                this._println("NATURAL LEFT OUTER JOIN");
                break;
            }
            case 7: {
                this._println("RIGHT OUTER JOIN");
                break;
            }
            case 8: {
                this._println("NATURAL RIGHT OUTER JOIN");
                break;
            }
            case 9: {
                this._println("FULL OUTER JOIN");
                break;
            }
            case 10: {
                this._println("NATURAL FULL OUTER JOIN");
            }
        }
        this.indentation += 2;
    }

    public void visitJoinedTable(JoinedTable x) {
        this.indentation -= 2;
    }

    public void visitLikePredicateBefore(LikePredicate x) {
        this.print(x.toString());
        if (x.isNotLike()) {
            this._println("NOT");
        } else {
            this._println();
        }
        this.indentation += 2;
    }

    public void visitLikePredicate(LikePredicate x) {
        this.indentation -= 2;
    }

    public void visitNonJoinQueryBefore(NonJoinQuery x) {
        this.print(x.toString());
        switch (x.getOperator()) {
            case 1: {
                this._println("UNION");
                break;
            }
            case 2: {
                this._println("UNION ALL");
                break;
            }
            case 3: {
                this._println("INTERSECT");
                break;
            }
            case 4: {
                this._println("INTERSECT ALL");
                break;
            }
            case 5: {
                this._println("EXCEPT");
                break;
            }
            case 6: {
                this._println("EXCEPT_ALL");
            }
        }
        this.indentation += 2;
    }

    public void visitNonJoinQuery(NonJoinQuery x) {
        this.indentation -= 2;
    }

    public void visitNullPredicateBefore(NullPredicate x) {
        this.print(x.toString());
        if (x.isNotNull()) {
            this._println("NOT");
        } else {
            this._println();
        }
        this.indentation += 2;
    }

    public void visitNullPredicate(NullPredicate x) {
        this.indentation -= 2;
    }

    public void visitNullValueBefore(NullValue x) {
        this.println(x.toString());
        this.indentation += 2;
    }

    public void visitNullValue(NullValue x) {
        this.indentation -= 2;
    }

    public void visitQuantifiedComparisonPredicateBefore(QuantifiedComparisonPredicate x) {
        this.print(x.toString());
        this._printComparisonOperator(x.getOperator());
        switch (x.getQuantifier()) {
            case 1: {
                this._println("ALL");
                break;
            }
            case 2: {
                this._println("ANY");
                break;
            }
            case 3: {
                this._println("SOME");
            }
        }
        this.indentation += 2;
    }

    public void visitQuantifiedComparisonPredicate(QuantifiedComparisonPredicate x) {
        this.indentation -= 2;
    }

    public void visitQueryBefore(Query x) {
        this.println(x.toString());
        this.indentation += 2;
    }

    public void visitQuery(Query x) {
        this.indentation -= 2;
    }

    public void visitQuerySpecificationBefore(QuerySpecification x) {
        this.println(x.toString());
        this.indentation += 2;
    }

    public void visitQuerySpecification(QuerySpecification x) {
        this.indentation -= 2;
    }

    public void visitRowValueBefore(RowValue x) {
        this.println(x.toString());
        this.indentation += 2;
    }

    public void visitRowValue(RowValue x) {
        this.indentation -= 2;
    }

    public void visitRowValueElementBefore(RowValueElement x) {
        this.println(x.toString());
        this.indentation += 2;
    }

    public void visitRowValueElement(RowValueElement x) {
        this.indentation -= 2;
    }

    public void visitRowValueElementListBefore(RowValueElementList x) {
        this.println(x.toString());
        this.indentation += 2;
    }

    public void visitRowValueElementList(RowValueElementList x) {
        this.indentation -= 2;
    }

    public void visitSearchConditionBefore(SearchCondition x) {
        this.println(x.toString());
        this.indentation += 2;
    }

    public void visitSearchCondition(SearchCondition x) {
        this.indentation -= 2;
    }

    public void visitSelectForUpdateBefore(SelectForUpdateStatement x) {
        this.println(x.toString());
        this.indentation += 2;
    }

    public void visitSelectForUpdate(SelectForUpdateStatement x) {
        this.indentation -= 2;
    }

    public void visitSelectStatementBefore(SelectStatement x) {
        this.println(x.toString());
        this.indentation += 2;
    }

    public void visitSelectStatement(SelectStatement x) {
        this.indentation -= 2;
    }

    public void visitSelectSublistBefore(SelectSublist x) {
        this.print(x.toString());
        this._println(x.getAliasName());
        this.indentation += 2;
    }

    public void visitSelectSublist(SelectSublist x) {
        this.indentation -= 2;
    }

    public void visitSetClauseBefore(SetClause x) {
        this.print(x.toString());
        this.indentation += 2;
    }

    public void visitSetClause(SetClause x) {
        this.indentation -= 2;
    }

    public void visitSetFunctionBefore(SetFunction x) {
        this.print(x.toString());
        switch (x.getSetFunctionType()) {
            case 1: {
                this._println("AVG");
                break;
            }
            case 2: {
                this._println("MIN");
                break;
            }
            case 3: {
                this._println("MAX");
                break;
            }
            case 4: {
                this._println("SUM");
                break;
            }
            case 5: {
                this._println("COUNT");
            }
        }
        this.indentation += 2;
    }

    public void visitSetFunction(SetFunction x) {
        this.indentation -= 2;
    }

    public void visitSortSpecificationBefore(SortSpecification x) {
        this.print(x.toString());
        this._print(x.getColumnName());
        if (x.isDescending()) {
            this._println("DESC");
        } else {
            this._println("ASC");
        }
        this.indentation += 2;
    }

    public void visitSortSpecification(SortSpecification x) {
        this.indentation -= 2;
    }

    public void visitSQLStatementBefore(SQLStatement x) {
        this.println(x.toString());
        this.indentation += 2;
    }

    public void visitSQLStatement(SQLStatement x) {
        this.indentation -= 2;
    }

    public void visitStringLiteralBefore(StringLiteral x) {
        this.print(x.toString());
        this._println(x.getValue());
        this.indentation += 2;
    }

    public void visitStringLiteral(StringLiteral x) {
        this.indentation -= 2;
    }

    public void visitTableReferenceBefore(TableReference x) {
        this.print(x.toString());
        this._print(x.getTableName());
        this._println("AS " + x.getAliasName());
        this.indentation += 2;
    }

    public void visitTableReference(TableReference x) {
        this.indentation -= 2;
    }

    public void visitTableValueBefore(TableValue x) {
        this.println(x.toString());
        this.indentation += 2;
    }

    public void visitTableValue(TableValue x) {
        this.indentation -= 2;
    }

    public void visitUpdateStatementBefore(UpdateStatement x) {
        this.println(x.toString());
        this.indentation += 2;
    }

    public void visitUpdateStatement(UpdateStatement x) {
        this.indentation -= 2;
    }

    public void visitValueExpressionBefore(ValueExpression x) {
        this.println(x.toString());
        this.indentation += 2;
    }

    public void visitValueExpression(ValueExpression x) {
        this.indentation -= 2;
    }
}

