/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlparser;

import antlr.ANTLRException;
import antlr.RecognitionException;
import com.sap.sql.catalog.CatalogReader;
import com.sap.sql.sqlparser.CheckColAndTabVisitor;
import com.sap.sql.sqlparser.CheckCreateViewVisitor;
import com.sap.sql.sqlparser.CheckDistinctVisitor;
import com.sap.sql.sqlparser.CheckGroupVisitor;
import com.sap.sql.sqlparser.CheckHostVariableVisitor;
import com.sap.sql.sqlparser.CheckJoinVisitor;
import com.sap.sql.sqlparser.CheckSelForUpdVisitor;
import com.sap.sql.sqlparser.CheckSetClauseVisitor;
import com.sap.sql.sqlparser.CheckSetFunctionVisitor;
import com.sap.sql.sqlparser.CheckSubQueryVisitor;
import com.sap.sql.sqlparser.CheckTypeVisitor;
import com.sap.sql.sqlparser.CheckVisitor;
import com.sap.sql.sqlparser.CommonSQLParserException;
import com.sap.sql.sqlparser.SQLLexer;
import com.sap.sql.sqlparser.SQLParser;
import com.sap.sql.tree.GeneralSelectStatement;
import com.sap.sql.tree.ResultDescriptor;
import com.sap.sql.tree.SQLStatement;
import com.sap.tc.logging.Location;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.sql.SQLException;
import java.util.Vector;

public class CommonSQLStatement {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$sql$sqlparser$CommonSQLStatement == null ? (class$com$sap$sql$sqlparser$CommonSQLStatement = CommonSQLStatement.class$("com.sap.sql.sqlparser.CommonSQLStatement")) : class$com$sap$sql$sqlparser$CommonSQLStatement));
    protected static final String client = "000";
    private int hostVarCount = 0;
    private SQLStatement statement = null;
    private SQLLexer lexer;
    private SQLParser parser;
    private StringReader reader = new StringReader("");
    static /* synthetic */ Class class$com$sap$sql$sqlparser$CommonSQLStatement;

    public CommonSQLStatement(String source) throws CommonSQLParserException {
        this();
        this.parse(source);
    }

    public CommonSQLStatement(SQLStatement aStatement) throws CommonSQLParserException {
        this();
        this.setStatement(aStatement);
    }

    public CommonSQLStatement() {
        this.lexer = new SQLLexer(this.reader);
        this.parser = new SQLParser(this.lexer);
    }

    public void parse(String source) throws CommonSQLParserException {
        this.reader = new StringReader(source);
        this.lexer.resetInput(this.reader);
        this.parser.resetTokenBuffer();
        this.parser.clearErrorLog();
        try {
            this.statement = this.parser.directly_executable_statement();
        }
        catch (RecognitionException ex) {
            LOCATION.catching((Throwable)ex);
            throw new CommonSQLParserException(ex.getMessage(), ex.getLine());
        }
        catch (ANTLRException ex) {
            LOCATION.catching((Throwable)ex);
            throw new CommonSQLParserException(ex.toString());
        }
        Vector log = this.parser.getErrorLog();
        if (log != null && log.size() > 0) {
            throw new CommonSQLParserException(log);
        }
        this.hostVarCount = this.parser.getHostVarCount();
        this.syntacticCheck();
    }

    private void syntacticCheck() throws CommonSQLParserException {
        Vector errorLog = new Vector();
        CheckVisitor[] checker = new CheckVisitor[]{new CheckDistinctVisitor(errorLog), new CheckSetClauseVisitor(errorLog), new CheckSetFunctionVisitor(errorLog), new CheckHostVariableVisitor(errorLog), new CheckSubQueryVisitor(errorLog)};
        int chki = 0;
        while (chki < checker.length) {
            this.statement.accept(checker[chki]);
            checker[chki].performChecks();
            ++chki;
        }
        if (errorLog.size() > 0) {
            throw new CommonSQLParserException(errorLog);
        }
    }

    protected void addClient(SQLStatement stmt, Vector errorLog, String client) {
    }

    public int getOperationCode() {
        if (null == this.statement) {
            return 1;
        }
        return this.statement.getStatementType();
    }

    public void checkSemantics(CatalogReader reader) throws CommonSQLParserException, SQLException {
        LOCATION.entering("checkSemantics");
        if (null == reader) {
            throw new IllegalArgumentException("catalog reader must not be null");
        }
        Vector errorLog = new Vector();
        if (this.statement.getStatementType() == 256) {
            CheckCreateViewVisitor createViewVisitor = new CheckCreateViewVisitor(errorLog);
            this.statement.accept(createViewVisitor);
            if (errorLog.size() > 0) {
                throw new CommonSQLParserException(errorLog);
            }
        }
        CheckColAndTabVisitor checkColAndTabVisitor = new CheckColAndTabVisitor(errorLog, reader);
        CheckVisitor[] checker = new CheckVisitor[]{checkColAndTabVisitor, new CheckJoinVisitor(errorLog), new CheckGroupVisitor(errorLog), new CheckSelForUpdVisitor(errorLog)};
        this.statement.accept(checkColAndTabVisitor);
        checkColAndTabVisitor.performCatalogChecks();
        if (errorLog.size() > 0) {
            throw new CommonSQLParserException(errorLog);
        }
        int chki = 0;
        while (chki < checker.length) {
            this.statement.accept(checker[chki]);
            checker[chki].performChecks();
            if (errorLog.size() > 0) {
                throw new CommonSQLParserException(errorLog);
            }
            ++chki;
        }
        this.addClient(this.statement, errorLog, client);
        CheckTypeVisitor checkTypeVisitor = new CheckTypeVisitor(errorLog, this.hostVarCount);
        this.statement.accept(checkTypeVisitor);
        checkTypeVisitor.performChecks();
        if (errorLog.size() > 0) {
            throw new CommonSQLParserException(errorLog);
        }
        if (this.statement instanceof GeneralSelectStatement) {
            GeneralSelectStatement gs = (GeneralSelectStatement)this.statement;
            LOCATION.debugT("query, determing result set");
            ResultDescriptor[] resultSet = checkTypeVisitor.getResultSetDescription();
            gs.setResultSetColumns(resultSet);
            gs.setIsSelectAsterisk(checkColAndTabVisitor.isSelectAsterisk());
        }
        ResultDescriptor[] inputSet = checkTypeVisitor.getInputSetDescription();
        this.statement.setHostVariablesList(inputSet);
        LOCATION.exiting();
    }

    public SQLStatement getSQLStatement() {
        return this.statement;
    }

    public void setStatement(SQLStatement aStatement) throws CommonSQLParserException {
        this.statement = aStatement;
        this.hostVarCount = 0;
        this.syntacticCheck();
    }

    public static void main(String[] args) throws IOException, SQLException {
        if (args.length != 1) {
            System.out.println("excaxtly one file name required");
        } else {
            FileReader fr = new FileReader(args[0]);
            BufferedReader inp = new BufferedReader(fr);
            while (inp.ready()) {
                String line = inp.readLine();
                try {
                    CommonSQLStatement stmt = new CommonSQLStatement(line);
                    stmt.checkSemantics(null);
                }
                catch (CommonSQLParserException ex) {
                    System.out.println(">>>");
                    System.out.println(line);
                    System.out.println("<<<");
                    System.out.println(ex.toString());
                    System.out.println();
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

