/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.util;

import com.sap.sql.sqlj.framework.BaseJSClass;
import com.sap.sql.sqlj.framework.ClassResolver;
import com.sap.sql.sqlj.util.ClassNameResolver;
import com.sap.sql.sqlj.util.ClassNameResolverWrapper;
import com.sap.sql.sqlj.util.ClassResolverWrapper;
import com.sap.sql.sqlj.util.NestedClassResolver;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class UnitClassResolver
extends ClassNameResolverWrapper {
    private Hashtable m_classCache = new Hashtable();
    private Hashtable m_nameCache = new Hashtable();
    private String m_packageQual = "";
    private int m_packageQualLen = 0;
    private Hashtable m_explicitImportTable = new Hashtable();
    private Vector m_implicitImports = new Vector();

    public UnitClassResolver(ClassResolver base) {
        super(new ClassNameResolverImpl(base));
        this.m_implicitImports.addElement(new ImplicitEntry());
        this.m_implicitImports.addElement(new ImplicitEntry("java.lang", true));
    }

    public NestedClassResolver newNestedClassResolver(String simpleClassName) {
        return new NestedClassResolver(simpleClassName, this);
    }

    public void setPackageName(String name) {
        if (name != null && name.length() > 0) {
            this.m_packageQual = name + ".";
            this.m_packageQualLen = this.m_packageQual.length();
        } else {
            this.m_packageQual = "";
            this.m_packageQualLen = 0;
        }
        this.m_implicitImports.setElementAt(new ImplicitEntry(name, true), 0);
    }

    public void addExplicitImport(String name) {
        ExplicitEntry entry = new ExplicitEntry(name);
        this.m_explicitImportTable.put(entry.getClassComponent(), entry);
    }

    public void addImplicitImport(String name) {
        this.m_implicitImports.addElement(new ImplicitEntry(name));
    }

    public BaseJSClass getClass(String name) throws ClassNotFoundException {
        BaseJSClass result = (BaseJSClass)this.m_classCache.get(name);
        if (result != null) {
            return result;
        }
        result = this.lookupResult(name);
        if (result != null) {
            this.m_classCache.put(name, result);
            return result;
        }
        throw new ClassNotFoundException(name);
    }

    private BaseJSClass lookupResult(String name) throws ClassNotFoundException {
        BaseJSClass result = this.getArray(name);
        if (result != null) {
            return result;
        }
        result = this.resolveExplicit(name);
        if (result != null) {
            return result;
        }
        result = this.resolveImplicit(name);
        if (result != null) {
            return result;
        }
        result = this.resolveClass(name);
        if (result != null) {
            return result;
        }
        return null;
    }

    private BaseJSClass resolveImplicit(String name) {
        name = name.replace('.', '$');
        Enumeration imports = this.m_implicitImports.elements();
        while (imports.hasMoreElements()) {
            ImplicitEntry entry = (ImplicitEntry)imports.nextElement();
            BaseJSClass result = this.getQualifiedClass(entry.getImport() + name);
            if (result == null) continue;
            this.m_nameCache.put(result, name);
            return result;
        }
        return null;
    }

    private BaseJSClass resolveExplicit(String name) throws ClassNotFoundException {
        String prefix;
        String rest;
        name = name.replace('.', '$');
        BaseJSClass result = null;
        int ndx = name.indexOf(36);
        if (ndx != -1) {
            rest = name.substring(ndx);
            prefix = name.substring(0, ndx);
        } else {
            rest = "";
            prefix = name;
        }
        ExplicitEntry entry = null;
        entry = (ExplicitEntry)this.m_explicitImportTable.get(prefix);
        if (entry != null && (result = this.getQualifiedClass(entry.getResolvedName() + rest)) != null) {
            this.m_nameCache.put(result, name);
        }
        return result;
    }

    private BaseJSClass resolveClass(String name) {
        int ndx = name.length();
        StringBuffer nameBuf = new StringBuffer(name);
        while (true) {
            BaseJSClass result;
            if ((result = this.getQualifiedClass(nameBuf.toString())) != null) {
                return result;
            }
            if ((ndx = name.lastIndexOf(46, ndx - 1)) == -1) break;
            nameBuf.setCharAt(ndx, '$');
        }
        return null;
    }

    public String getShortName(BaseJSClass cls) {
        String name = (String)this.m_nameCache.get(cls);
        if (name != null) {
            return name;
        }
        return this.m_base.getShortName(cls);
    }

    public StringBuffer getClassQualification() {
        return new StringBuffer(this.m_packageQual);
    }

    public void addClass(BaseJSClass aClass) {
        String name = aClass.getName();
        if (this.m_packageQualLen > 0 && name.startsWith(this.m_packageQual) && name.indexOf(46, this.m_packageQualLen) == -1) {
            String shortName = name.substring(this.m_packageQualLen);
            this.m_nameCache.put(aClass, shortName);
        }
        super.addClass(aClass);
    }

    private class ExplicitEntry {
        private String m_origName;
        private String m_classComponent;
        private String m_resolvedName = null;

        public ExplicitEntry(String origName) {
            this.m_origName = origName;
            int ndx = origName.lastIndexOf(46);
            this.m_classComponent = ndx == -1 ? origName : origName.substring(ndx + 1);
        }

        public String getClassComponent() {
            return this.m_classComponent;
        }

        public String getResolvedName() throws ClassNotFoundException {
            if (this.m_resolvedName == null) {
                BaseJSClass cls = UnitClassResolver.this.resolveClass(this.m_origName);
                if (cls == null) {
                    throw new ClassNotFoundException("error in import: " + this.m_origName);
                }
                this.m_resolvedName = cls.getName();
            }
            return this.m_resolvedName;
        }
    }

    private class ImplicitEntry {
        private String m_origName;
        private String m_resolvedName = null;

        public ImplicitEntry() {
            this.m_resolvedName = "";
            this.m_origName = "";
        }

        public ImplicitEntry(String origName) {
            this.m_origName = origName == null ? "" : origName;
        }

        public ImplicitEntry(String origName, boolean isPackage) {
            if (origName != null && origName.length() > 0) {
                this.m_origName = origName;
                if (isPackage) {
                    this.m_resolvedName = this.m_origName + ".";
                }
            } else {
                this.m_origName = "";
                this.m_resolvedName = "";
            }
        }

        public String getImport() {
            if (this.m_resolvedName == null) {
                BaseJSClass resolvedClass;
                this.m_resolvedName = this.m_origName.length() > 0 ? ((resolvedClass = UnitClassResolver.this.resolveClass(this.m_origName)) != null ? resolvedClass.getName() + "$" : this.m_origName + ".") : "";
            }
            return this.m_resolvedName;
        }
    }

    private static class ClassNameResolverImpl
    extends ClassResolverWrapper
    implements ClassNameResolver {
        ClassNameResolverImpl(ClassResolver resolver) {
            super(resolver);
        }

        public String getShortName(BaseJSClass cls) {
            return cls.getName();
        }

        public StringBuffer getClassQualification() {
            return new StringBuffer();
        }
    }
}

