/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.util;

import com.sap.sql.sqlj.framework.BaseJSClass;
import com.sap.sql.sqlj.framework.ClassResolver;
import com.sap.sql.sqlj.util.BlockClassResolver;
import com.sap.sql.sqlj.util.ClassNameResolver;
import com.sap.sql.sqlj.util.ClassNameResolverWrapper;
import com.sap.sql.sqlj.util.UnitClassResolver;
import com.sap.tc.logging.Location;
import java.util.HashSet;

public class NestedClassResolver
extends ClassNameResolverWrapper {
    private String m_enclosingClass;
    private int m_enclosingClassLen;
    private int m_blockCount = 0;
    private BaseJSClass m_thisClass;
    private static HashSet m_keywords = new HashSet();
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$sql$sqlj$util$NestedClassResolver == null ? (class$com$sap$sql$sqlj$util$NestedClassResolver = NestedClassResolver.class$("com.sap.sql.sqlj.util.NestedClassResolver")) : class$com$sap$sql$sqlj$util$NestedClassResolver));
    static /* synthetic */ Class class$com$sap$sql$sqlj$util$NestedClassResolver;

    public NestedClassResolver(String simpleClassName, NestedClassResolver base) {
        this(base, simpleClassName);
    }

    public NestedClassResolver(String simpleClassName, BlockClassResolver base) {
        this(base.getWindow(), simpleClassName);
    }

    public NestedClassResolver(String simpleClassName, UnitClassResolver base) {
        this(base, simpleClassName);
    }

    private NestedClassResolver(ClassNameResolver base, String simpleClassName) {
        super(base);
        this.m_enclosingClass = base.getClassQualification().append(simpleClassName).append("$").toString();
        this.m_enclosingClassLen = this.m_enclosingClass.length();
    }

    private BaseJSClass getKeyword(String name) {
        if (m_keywords.contains(name)) {
            return ClassResolver.SYSTEM_CLASSES.getQualifiedClass(name);
        }
        return null;
    }

    public static NestedClassResolver newInstance(String simpleClassName, ClassNameResolver base) {
        if (base instanceof NestedClassResolver) {
            return new NestedClassResolver(simpleClassName, (NestedClassResolver)base);
        }
        if (base instanceof BlockClassResolver) {
            return new NestedClassResolver(simpleClassName, (BlockClassResolver)base);
        }
        if (base instanceof UnitClassResolver) {
            return new NestedClassResolver(simpleClassName, (UnitClassResolver)base);
        }
        throw new IllegalArgumentException("unknown base resolver type");
    }

    public BaseJSClass getClass(String name) throws ClassNotFoundException {
        BaseJSClass result = this.getKeyword(name);
        if (result != null) {
            return result;
        }
        result = this.getArray(name);
        if (result != null) {
            return result;
        }
        String runtimeName = name.replace('.', '$');
        result = this.getQualifiedClass(this.m_enclosingClass + runtimeName);
        if (result != null) {
            return result;
        }
        this.initThisClass();
        BaseJSClass superclass = this.m_thisClass;
        runtimeName = "$" + runtimeName;
        while ((superclass = this.getSuperclass(superclass)) != null) {
            result = this.getQualifiedClass(superclass.getName() + runtimeName);
            if (result == null) continue;
            return result;
        }
        return this.m_base.getClass(name);
    }

    private BaseJSClass getSuperclass(BaseJSClass subclass) {
        String superName = subclass.getSuperclassName();
        if (superName == null) {
            return null;
        }
        try {
            return this.m_base.getClass(superName);
        }
        catch (ClassNotFoundException e) {
            LOCATION.catching((Throwable)e);
            return null;
        }
    }

    private void initThisClass() {
        if (this.m_thisClass == null) {
            this.m_thisClass = this.getQualifiedClass(this.m_enclosingClass.substring(0, this.m_enclosingClassLen - 1));
            if (this.m_thisClass == null) {
                throw new Error("class not found in resolver");
            }
        }
    }

    public String getShortName(BaseJSClass cls) {
        String name = cls.getName();
        if (name.startsWith(this.m_enclosingClass)) {
            return name.substring(this.m_enclosingClassLen);
        }
        this.initThisClass();
        BaseJSClass superclass = this.m_thisClass;
        while ((superclass = this.getSuperclass(superclass)) != null) {
            String superName = superclass.getName() + "$";
            if (!name.startsWith(superName)) continue;
            return name.substring(superName.length());
        }
        return this.m_base.getShortName(cls);
    }

    public StringBuffer getClassQualification() {
        return new StringBuffer(this.m_enclosingClass);
    }

    int newBlockCount() {
        return this.m_blockCount++;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        m_keywords.add("boolean");
        m_keywords.add("byte");
        m_keywords.add("char");
        m_keywords.add("short");
        m_keywords.add("int");
        m_keywords.add("long");
        m_keywords.add("float");
        m_keywords.add("double");
        m_keywords.add("void");
    }
}

