/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.translator;

import com.sap.sql.sqlj.framework.ClassResolver;
import com.sap.sql.sqlj.framework.error.ErrorLog;
import com.sap.sql.sqlj.framework.error.JSError;
import com.sap.sql.sqlj.framework.options.HasOptions;
import com.sap.sql.sqlj.framework.options.InvalidOptionException;
import com.sap.sql.sqlj.framework.options.PropertyList;
import com.sap.sql.sqlj.mesg.OptionDesc;
import com.sap.sql.sqlj.mesg.TranslatorErrors;
import com.sap.sql.sqlj.translator.ClassResolverImpl;
import com.sap.sql.sqlj.translator.FileTranslationUnit;
import com.sap.sql.sqlj.translator.TranslationUnit;
import com.sap.sql.sqlj.util.io.ErrorLogger;
import java.io.File;
import java.io.IOException;

public class TranslationUnitFactory
implements HasOptions {
    private static final String DIR_OPTION = "dir";
    private static final String SER_DIR_OPTION = "d";
    private static final String ENCODING_OPTION = "encoding";
    private static final String CLASSPATH_OPTION = "classpath";
    private static final String SOURCEPATH_OPTION = "sourcepath";
    private String m_dir_location = OptionDesc.default_origin();
    private String m_directory = null;
    private ClassResolver m_classResolver = null;
    private String m_ser_dir_location = OptionDesc.default_origin();
    private String m_ser_directory = null;
    private String m_enc_location = OptionDesc.default_origin();
    private String m_encoding = null;

    TranslationUnitFactory() {
    }

    TranslationUnit newTranslationUnit(String filename, ErrorLogger log) throws IOException {
        return new FileTranslationUnit(filename, this.m_directory, this.m_ser_directory, this.m_encoding, log, this.m_classResolver);
    }

    public void setOptions(PropertyList props, ErrorLog log) throws InvalidOptionException {
        this.m_directory = props.getProperty(DIR_OPTION);
        if (this.m_directory != null && this.m_directory.equals("")) {
            this.m_directory = null;
        }
        if (this.m_directory != null) {
            this.m_dir_location = props.getPropertyLocation(DIR_OPTION);
            if (!new File(this.m_directory).isDirectory()) {
                log.addEntry(new JSError(OptionDesc.bad_option(DIR_OPTION, this.m_dir_location, TranslatorErrors.not_a_directory(this.m_directory))));
                throw new InvalidOptionException();
            }
        }
        this.m_ser_directory = props.getProperty(SER_DIR_OPTION);
        if (this.m_ser_directory != null && this.m_ser_directory.equals("")) {
            this.m_ser_directory = null;
        }
        if (this.m_ser_directory != null) {
            this.m_ser_dir_location = props.getPropertyLocation(SER_DIR_OPTION);
            if (!new File(this.m_ser_directory).isDirectory()) {
                log.addEntry(new JSError(OptionDesc.bad_option(SER_DIR_OPTION, this.m_ser_dir_location, TranslatorErrors.not_a_directory(this.m_ser_directory))));
                throw new InvalidOptionException();
            }
        }
        this.m_encoding = props.getProperty(ENCODING_OPTION);
        if (this.m_encoding != null) {
            this.m_enc_location = props.getPropertyLocation(ENCODING_OPTION);
        } else {
            this.m_encoding = System.getProperty("file.encoding", "8859_1");
        }
        if (this.m_classResolver == null) {
            String classpath = props.getProperty(CLASSPATH_OPTION);
            String sourcepath = props.getProperty(SOURCEPATH_OPTION);
            this.m_classResolver = new ClassResolverImpl(classpath, sourcepath);
        }
    }

    public String[][] getOptionInfo() {
        return new String[][]{{DIR_OPTION, OptionDesc.directory(), this.m_directory == null ? OptionDesc.input_dir() : this.m_directory, OptionDesc.java_dir(), this.m_dir_location}};
    }
}

