/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.translator;

import com.sap.sql.sqlj.codegen.ParseletFactory;
import com.sap.sql.sqlj.framework.BaseJSClass;
import com.sap.sql.sqlj.framework.ClassResolver;
import com.sap.sql.sqlj.framework.JSClass;
import com.sap.sql.sqlj.javac.JavaParserSub;
import com.sap.sql.sqlj.javac.ParseContextImpl;
import com.sap.sql.sqlj.mesg.TranslatorErrors;
import com.sap.sql.sqlj.translator.Translator;
import com.sap.sql.sqlj.util.Disposable;
import com.sap.sql.sqlj.util.ParseException;
import com.sap.sql.sqlj.util.TranslationContext;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class ClassResolverImpl
implements ClassResolver {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$sql$sqlj$translator$ClassResolverImpl == null ? (class$com$sap$sql$sqlj$translator$ClassResolverImpl = ClassResolverImpl.class$("com.sap.sql.sqlj.translator.ClassResolverImpl")) : class$com$sap$sql$sqlj$translator$ClassResolverImpl));
    private Hashtable m_classes = new Hashtable();
    private ClassLoader m_classLoader;
    private ClassLoader m_sourceLoader;
    private Translator m_translator = null;
    private HashSet m_notOnFile = new HashSet();
    private static final Integer FAILED = new Integer(0);
    Disposable.Disposer m_disposer = null;
    JavaParserSub m_parser = null;
    static /* synthetic */ Class class$com$sap$sql$sqlj$translator$ClassResolverImpl;

    public ClassResolverImpl() {
        this(null, null);
    }

    public ClassResolverImpl(String classpath, String sourcepath) {
        this.m_notOnFile.add("java.lang");
        if ((classpath == null || classpath.equals("")) && ((classpath = System.getProperty("java.class.path")) == null || classpath.equals(""))) {
            classpath = System.getProperty("user.dir");
        }
        this.m_classLoader = this.getClassLoader(classpath);
        if (sourcepath == null || sourcepath.equals("")) {
            sourcepath = classpath;
        }
        this.m_sourceLoader = this.getClassLoader(sourcepath);
    }

    private ClassLoader getClassLoader(String path) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        if (path != null) {
            StringTokenizer tokenizer = new StringTokenizer(path, File.pathSeparator);
            while (tokenizer.hasMoreTokens()) {
                String name = tokenizer.nextToken();
                File file = new File(name);
                if (file.exists()) {
                    try {
                        try {
                            file = file.getCanonicalFile();
                        }
                        catch (IOException ex) {
                            String msg = "unexpected IOException: " + ex.getMessage();
                            LOCATION.traceThrowableT(500, msg, (Throwable)ex);
                            throw new IllegalStateException(msg);
                        }
                        arrayList.add(file.toURL());
                        continue;
                    }
                    catch (MalformedURLException ex) {
                        throw new IllegalStateException("if the file exists, the URL cannot be malformed");
                    }
                }
                LOCATION.warningT("path element " + name + " does not exists.");
            }
        }
        URL[] urls = new URL[arrayList.size()];
        urls = arrayList.toArray(urls);
        return new UncachedURLClassLoader(urls);
    }

    public BaseJSClass getClass(String name) throws ClassNotFoundException {
        BaseJSClass cls = this.getQualifiedClass(name);
        if (cls != null) {
            return cls;
        }
        throw new ClassNotFoundException(name);
    }

    public synchronized BaseJSClass getQualifiedClass(String name) {
        Object result = this.m_classes.get(name);
        if (result != null) {
            if (result == FAILED) {
                return null;
            }
            return (BaseJSClass)result;
        }
        BaseJSClass aClass = ClassResolver.SYSTEM_CLASSES.getQualifiedClass(name);
        if (aClass != null) {
            return aClass;
        }
        aClass = this.getClassFromPath(name);
        if (aClass != null) {
            return aClass;
        }
        this.m_classes.put(name, FAILED);
        return null;
    }

    private String toOuterClass(String name) {
        int index = name.indexOf(36);
        String outerClass = index == -1 ? name : name.substring(0, index);
        return outerClass;
    }

    private BaseJSClass getClassFromPath(String name) {
        String fileName;
        BaseJSClass aClass = null;
        String outerClass = this.toOuterClass(name);
        Object object = this.m_classes.get(outerClass);
        if (object == null && !this.m_notOnFile.contains(fileName = outerClass.replace('.', File.separatorChar))) {
            aClass = this.parsePath(name, fileName + ".sqlj");
            if (aClass != null) {
                return aClass;
            }
            aClass = this.parsePath(name, fileName + ".java");
            if (aClass != null) {
                return aClass;
            }
            this.m_notOnFile.add(fileName);
        }
        try {
            Class<?> cls = Class.forName(name, false, this.m_classLoader);
            aClass = JSClass.reflect(cls, this).getBaseJSClass();
        }
        catch (ClassNotFoundException e) {
            LOCATION.catching((Throwable)e);
        }
        catch (NoClassDefFoundError e) {
            LOCATION.catching((Throwable)e);
        }
        catch (ExceptionInInitializerError e) {
            LOCATION.catching((Throwable)e);
        }
        return aClass;
    }

    private JavaParserSub getSqljParser() {
        if (this.m_disposer == null) {
            try {
                this.m_disposer = new Disposable.Disposer();
                TranslationContext xlatCtx = new TranslationContext(this.m_disposer, null);
                ParseletFactory parseletFactory = new ParseletFactory(xlatCtx, null);
                this.m_parser = new JavaParserSub(parseletFactory);
            }
            catch (UnsupportedEncodingException ex) {
                LOCATION.traceThrowableT(500, "unexpected UnsupportedEncodingException", (Throwable)ex);
                this.m_disposer = null;
                return null;
            }
        }
        return this.m_parser;
    }

    private boolean parseStream(InputStream stream, String name) {
        ParseContextImpl ctx;
        try {
            ctx = new ParseContextImpl(stream, this, name, null);
        }
        catch (UnsupportedEncodingException e1) {
            LOCATION.traceThrowableT(500, "unexpected UnsupportedEncodingException", (Throwable)e1);
            return false;
        }
        JavaParserSub parser = this.getSqljParser();
        if (parser == null) {
            return false;
        }
        try {
            parser.parseSQLJUnit(ctx);
        }
        catch (ParseException e2) {
            LOCATION.traceThrowableT(500, "ParseException on parsing file " + name, (Throwable)e2);
            return false;
        }
        this.m_disposer.disposeTrash();
        return true;
    }

    private String getClassName(String name) {
        int len = name.length();
        int lastDot = 0;
        int firstDollar = len;
        char[] array = name.toCharArray();
        int i = 0;
        while (i < len && firstDollar == len) {
            switch (array[i]) {
                case '.': {
                    lastDot = i + 1;
                    break;
                }
                case '$': {
                    firstDollar = i;
                }
            }
            ++i;
        }
        return name.substring(lastDot, firstDollar);
    }

    private BaseJSClass parsePath(String name, String path) {
        block7: {
            InputStream stream;
            block6: {
                BaseJSClass baseJSClass;
                stream = this.m_sourceLoader.getResourceAsStream(path);
                if (stream == null) break block7;
                try {
                    BaseJSClass aClass;
                    String className = this.getClassName(name);
                    if (!this.parseStream(stream, className) || (aClass = (BaseJSClass)this.m_classes.get(name)) == null) break block6;
                    baseJSClass = aClass;
                    Object var8_7 = null;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    try {
                        stream.close();
                    }
                    catch (IOException ex) {
                        LOCATION.traceThrowableT(500, "unexpected IOException on closing file", (Throwable)ex);
                    }
                    throw throwable;
                }
                try {
                    stream.close();
                }
                catch (IOException ex) {
                    LOCATION.traceThrowableT(500, "unexpected IOException on closing file", (Throwable)ex);
                }
                return baseJSClass;
            }
            Object var8_8 = null;
            try {
                stream.close();
            }
            catch (IOException ex) {
                LOCATION.traceThrowableT(500, "unexpected IOException on closing file", (Throwable)ex);
            }
        }
        return null;
    }

    public boolean isLoadedClass(String className) {
        return this.m_classes.containsKey(className) || ClassResolver.SYSTEM_CLASSES.isLoadedClass(className);
    }

    public synchronized void addClass(BaseJSClass aClass) {
        BaseJSClass oldClass = this.m_classes.put(aClass.getName(), aClass);
        if (oldClass != null && oldClass != aClass && oldClass != FAILED) {
            throw new ClassCircularityError(TranslatorErrors.classAlreadyDefined(aClass.getName()));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class UncachedURLClassLoader
    extends URLClassLoader {
        public UncachedURLClassLoader(URL[] urls) {
            super(urls, (ClassLoader)null);
        }

        public InputStream getResourceAsStream(String name) {
            URL url = this.getResource(name);
            if (url != null) {
                try {
                    URLConnection urlConnection = url.openConnection();
                    urlConnection.setUseCaches(false);
                    return urlConnection.getInputStream();
                }
                catch (IOException e) {
                    LOCATION.traceThrowableT(500, "unexpected IOException", (Throwable)e);
                }
            }
            return null;
        }
    }
}

