/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.semantics;

import com.sap.sql.sqlj.framework.BaseJSClass;
import com.sap.sql.sqlj.mesg.SemanticErrors;
import com.sap.sql.sqlj.semantics.BaseAnalysis;
import com.sap.sql.sqlj.semantics.SemanticAnalyzerFactory;
import com.sap.sql.sqlj.syntax.ClassElem;
import com.sap.sql.sqlj.syntax.Elem;
import com.sap.sql.sqlj.util.ClassDescriptor;
import com.sap.sql.sqlj.util.ClassNameResolver;
import com.sap.sql.sqlj.util.ExpressionDescriptor;
import com.sap.sql.sqlj.util.Parselet;
import com.sap.tc.logging.Location;
import java.lang.reflect.Modifier;
import java.util.Enumeration;

class ClassAnalysis
extends BaseAnalysis {
    private ClassElem class_elem;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$sql$sqlj$semantics$ClassAnalysis == null ? (class$com$sap$sql$sqlj$semantics$ClassAnalysis = ClassAnalysis.class$("com.sap.sql.sqlj.semantics.ClassAnalysis")) : class$com$sap$sql$sqlj$semantics$ClassAnalysis));
    static /* synthetic */ Class class$com$sap$sql$sqlj$semantics$ClassAnalysis;

    ClassAnalysis(Elem elem, SemanticAnalyzerFactory saf) {
        super(elem, saf);
        this.class_elem = (ClassElem)elem;
    }

    private String getName() {
        try {
            return ((ClassDescriptor)this.class_elem.getScope().getDescriptor()).getReflection().getName();
        }
        catch (ClassNotFoundException e) {
            LOCATION.catching((Throwable)e);
            return this.class_elem.getClassName();
        }
    }

    protected boolean isInner() {
        return this.class_elem.getScope().getScope().getEnclosingClass() != null;
    }

    protected Parselet outer() {
        if (!this.isInner()) {
            return null;
        }
        return this.class_elem.getScope().getScope().getEnclosingClass();
    }

    private void checkWithTypes() {
        Enumeration fields = this.class_elem.getWithKeywords();
        while (fields.hasMoreElements()) {
            String f_name = (String)fields.nextElement();
            Parselet p = this.class_elem.getWithValue(f_name);
            ExpressionDescriptor ed = (ExpressionDescriptor)p.getDescriptor();
            try {
                ed.getReflection();
            }
            catch (ClassNotFoundException exn) {
                LOCATION.catching((Throwable)exn);
                String msg = "Unable to resolve type of WITH attribute " + f_name + ".";
                LOCATION.errorT(msg);
                this.logError(msg);
            }
        }
    }

    protected void checkInterfaces() {
        Enumeration e = this.class_elem.getInterfaces();
        ClassNameResolver cnr = this.class_elem.getScope().getClassResolver();
        while (e.hasMoreElements()) {
            String anInterface = (String)e.nextElement();
            try {
                BaseJSClass jsClass = cnr.getClass(anInterface);
                if (!jsClass.isInterface()) {
                    this.logError(SemanticErrors.notAnInterface(jsClass.getName()));
                }
                this.isValidInterface(jsClass);
            }
            catch (ClassNotFoundException e1) {
                this.logError(SemanticErrors.notAnInterface(anInterface));
            }
        }
    }

    protected void isValidInterface(BaseJSClass jsClass) {
    }

    public boolean prepare() {
        String declared_name = this.class_elem.getClassName();
        this.checkSQLJClassPrefix(declared_name);
        String base_name = this.getBaseName();
        int mods = this.class_elem.getModifiers();
        boolean is_inner = this.isInner();
        if (Modifier.isAbstract(mods)) {
            this.logError(SemanticErrors.modifierNotAllowed("abstract"));
        }
        if (Modifier.isInterface(mods)) {
            this.logError(SemanticErrors.modifierNotAllowed("interface"));
        }
        if (Modifier.isNative(mods)) {
            this.logError(SemanticErrors.modifierNotAllowed("native"));
        }
        if (Modifier.isPrivate(mods) && !is_inner) {
            this.logError(SemanticErrors.innerClassModifier("private"));
        }
        if (Modifier.isPublic(mods) && !is_inner && base_name != null && !this.class_elem.getClassName().equals(base_name)) {
            this.logError(SemanticErrors.fileNameForPublicDeclaration(this.class_elem.getClassName(), base_name));
        }
        if (Modifier.isStatic(mods) && !is_inner) {
            this.logError(SemanticErrors.innerClassModifier("static"));
        }
        if (Modifier.isSynchronized(mods)) {
            this.logError(SemanticErrors.modifierNotAllowed("synchronized"));
        }
        if (Modifier.isTransient(mods)) {
            this.logError(SemanticErrors.modifierNotAllowed("transient"));
        }
        if (Modifier.isVolatile(mods)) {
            this.logError(SemanticErrors.modifierNotAllowed("volatile"));
        }
        this.checkWithTypes();
        this.checkInterfaces();
        return !this.unpreparable;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

