/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.semantics;

import com.sap.sql.sqlj.common.ConfigurationException;
import com.sap.sql.sqlj.framework.error.Info;
import com.sap.sql.sqlj.framework.error.JSError;
import com.sap.sql.sqlj.framework.error.Warning;
import com.sap.sql.sqlj.mesg.SemanticErrors;
import com.sap.sql.sqlj.semantics.SemanticAnalyzer;
import com.sap.sql.sqlj.semantics.SemanticAnalyzerFactory;
import com.sap.sql.sqlj.syntax.Elem;
import com.sap.sql.sqlj.util.UnitDescriptor;

class BaseAnalysis
implements SemanticAnalyzer {
    protected static final int UNKNOWN = -999;
    protected Elem elem;
    protected int errcount;
    protected boolean unpreparable;
    protected SemanticAnalyzerFactory saf;
    private static final String sQLJPrefix = "__sJT_";
    private static final String sQLJInfix = "_SJ";

    BaseAnalysis(Elem elem, SemanticAnalyzerFactory saf) {
        this.elem = elem;
        this.saf = saf;
        this.errcount = 0;
        this.unpreparable = false;
    }

    protected void logInfo(Object obj) {
        if (this.saf.getVerbose()) {
            this.elem.getErrorLog().addEntry(new Info(obj));
        }
    }

    protected void logWarning(Object obj) {
        this.elem.getErrorLog().addEntry(new Warning(obj));
    }

    protected void logError(Object obj) {
        this.elem.getErrorLog().addEntry(new JSError(obj));
        this.unpreparable = true;
    }

    protected String getBaseName() {
        UnitDescriptor ud = (UnitDescriptor)this.elem.getScope().getDefiningUnit().getDescriptor();
        return ud.getFileName();
    }

    protected boolean checkSQLJPrefix(String name) {
        if (name == null) {
            return false;
        }
        if (name.startsWith(sQLJPrefix)) {
            this.logError(SemanticErrors.sQLJPrefix(name));
            return true;
        }
        return false;
    }

    protected boolean checkSQLJClassPrefix(String name) {
        if (name == null) {
            return false;
        }
        if (name.startsWith(this.getBaseName() + sQLJInfix)) {
            this.logError(SemanticErrors.sQLJClassPrefix(this.getBaseName() + sQLJInfix));
            return true;
        }
        return false;
    }

    public boolean prepare() throws ConfigurationException {
        return true;
    }
}

