/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.runtime.ref;

import com.sap.sql.log.OpenSQLException;
import com.sap.sql.log.Syslog;
import com.sap.sql.services.OpenSQLServices;
import com.sap.sql.sqlj.runtime.ref.ProfileGroup;
import com.sap.sql.sqlj.runtime.ref.RuntimeRefErrors;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import sqlj.runtime.ConnectionContext;
import sqlj.runtime.ExecutionContext;
import sqlj.runtime.profile.ConnectedProfile;

public abstract class ConnectionContextImpl {
    private ExecutionContext m_execCtx = new ExecutionContext();
    private boolean m_isClosed = false;
    private Connection m_conn;

    protected ConnectionContextImpl(ProfileGroup profiles, Connection conn) throws SQLException {
        if (conn == null) {
            RuntimeRefErrors.raise_NULL_CONNECTION();
        }
        if (OpenSQLServices.getSQLType(conn) != 1) {
            Object[] args = new Object[]{conn.getClass().getName()};
            OpenSQLException ex = Syslog.createAndLogOpenSQLException(this, "com.sap.sql.sqlj.runtime.ref_1241", args);
            try {
                conn.close();
            }
            catch (SQLException next) {
                ex.setNextException(next);
            }
            throw ex;
        }
        this.m_conn = conn;
    }

    private ConnectionContextImpl(ProfileGroup profiles, Connection conn, boolean autoCommit) throws SQLException {
        this(profiles, ConnectionContextImpl.initAutoCommit(conn, autoCommit));
    }

    private static Connection initAutoCommit(Connection conn, boolean autoCommit) throws SQLException {
        try {
            conn.setAutoCommit(autoCommit);
        }
        catch (SQLException e) {
            try {
                conn.close();
            }
            catch (SQLException e2) {
                e.setNextException(e2);
            }
            throw e;
        }
        return conn;
    }

    protected ConnectionContextImpl(ProfileGroup profiles, String url, String user, String password, boolean autoCommit) throws SQLException {
        this(profiles, DriverManager.getConnection(url, user, password), autoCommit);
    }

    protected ConnectionContextImpl(ProfileGroup profiles, String url, Properties info, boolean autoCommit) throws SQLException {
        this(profiles, DriverManager.getConnection(url, info), autoCommit);
    }

    protected ConnectionContextImpl(ProfileGroup profiles, String url, boolean autoCommit) throws SQLException {
        this(profiles, DriverManager.getConnection(url), autoCommit);
    }

    protected ConnectionContextImpl(ProfileGroup profiles, ConnectionContext other) throws SQLException {
        this(profiles, other.getConnection());
    }

    public ConnectedProfile getConnectedProfile(Object profileKey) throws SQLException {
        return null;
    }

    public void close() throws SQLException {
        this.close(true);
    }

    public boolean isClosed() {
        return this.m_isClosed;
    }

    public Connection getConnection() {
        return this.m_conn;
    }

    public void close(boolean closeConnection) throws SQLException {
        this.m_isClosed = true;
        if (closeConnection) {
            this.m_conn.close();
        }
    }

    public ExecutionContext getExecutionContext() {
        return this.m_execCtx;
    }

    public Map getTypeMap() {
        return null;
    }
}

