/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.runtime.profile.ref;

import com.sap.sql.sqlj.runtime.profile.ref.DynamicProfile;
import com.sap.sql.sqlj.runtime.profile.ref.DynamicProfileWrapper;
import com.sap.sql.sqlj.runtime.profile.ref.ProfileRefErrors;
import com.sap.sql.sqlj.runtime.profile.ref.RTCallableStatement;
import com.sap.sql.sqlj.runtime.profile.ref.RTStatementWrapper;
import com.sap.sql.sqlj.runtime.ref.ResultSetIterImpl;
import java.sql.SQLException;
import java.util.Map;
import sqlj.runtime.ResultSetIterator;
import sqlj.runtime.profile.BatchContext;
import sqlj.runtime.profile.EntryInfo;
import sqlj.runtime.profile.RTResultSet;
import sqlj.runtime.profile.RTStatement;

public class UntypedSelectProfile
extends DynamicProfileWrapper {
    public UntypedSelectProfile(DynamicProfile p) {
        super(p);
    }

    public RTStatement getStatement(int ndx, BatchContext batch, Map typeMap) throws SQLException {
        RTStatement result = super.getStatement(ndx, batch, typeMap);
        EntryInfo entry = this.getProfileData().getEntryInfo(ndx);
        if (entry.getRole() == 19) {
            if (entry.getStatementType() != 4) {
                ProfileRefErrors.raise_EXPECTED_CALLABLE_STATEMENT(entry.getSQLString());
            }
            if (entry.getExecuteType() != 8) {
                ProfileRefErrors.raise_EXPECTED_EXECUTE_UPDATE(entry.getSQLString());
            }
            result = new UntypedSelectStatement((RTCallableStatement)result, entry);
        }
        return result;
    }

    public static class UntypedSelectStatement
    extends RTStatementWrapper
    implements RTCallableStatement {
        private RTResultSet m_rs = null;
        private int m_resultParam;
        private RTCallableStatement m_cstmt;

        public UntypedSelectStatement(RTCallableStatement stmt, EntryInfo entry) {
            super(stmt);
            this.m_resultParam = entry.getParamCount();
            this.m_cstmt = stmt;
        }

        public void registerOutParameter(int paramIndex, int sqlType) throws SQLException {
            if (paramIndex != this.m_resultParam) {
                this.m_cstmt.registerOutParameter(paramIndex, sqlType);
            }
        }

        public Object getObject(int paramNum, Class resultType) throws SQLException {
            if (paramNum == this.m_resultParam) {
                return UntypedSelectStatement.newUntypedIterator(this.getQueryResult());
            }
            return super.getObject(paramNum, resultType);
        }

        private RTResultSet getQueryResult() throws SQLException {
            if (this.m_rs == null) {
                ProfileRefErrors.raise_UNEXPECTED_CALL("getQueryResult");
            }
            return this.m_rs;
        }

        public int executeUpdate() throws SQLException {
            this.m_rs = this.stmt.executeRTQuery();
            return -1;
        }

        public static ResultSetIterator newUntypedIterator(RTResultSet rs) throws SQLException {
            return new ResultSetIterImpl(rs);
        }
    }
}

