/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.runtime.profile.ref;

import com.sap.sql.sqlj.runtime.profile.ref.LocalStatement;
import com.sap.sql.sqlj.runtime.profile.ref.ProfileRefErrors;
import com.sap.sql.sqlj.runtime.profile.ref.ProfileWrapper;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import sqlj.runtime.profile.BatchContext;
import sqlj.runtime.profile.ConnectedProfile;
import sqlj.runtime.profile.EntryInfo;
import sqlj.runtime.profile.RTStatement;
import sqlj.runtime.profile.SetTransactionDescriptor;

public class TransactionControlProfile
extends ProfileWrapper {
    private boolean m_handleCommit = true;
    private boolean m_handleRollback = true;
    private boolean m_handleSetTransaction = true;

    public TransactionControlProfile(ConnectedProfile profile) {
        super(profile);
    }

    public TransactionControlProfile(ConnectedProfile profile, boolean handleCommit, boolean handleRollback, boolean handleSetTransaction) {
        this(profile);
        this.m_handleCommit = handleCommit;
        this.m_handleRollback = handleRollback;
        this.m_handleSetTransaction = handleSetTransaction;
    }

    public RTStatement getStatement(int ndx, BatchContext batch, Map typeMap) throws SQLException {
        EntryInfo entryInfo = this.getProfileData().getEntryInfo(ndx);
        switch (entryInfo.getRole()) {
            case 11: {
                if (!this.m_handleCommit) break;
                this.verifyEntry(entryInfo);
                return new CommitStatement(this.getConnection());
            }
            case 12: {
                if (!this.m_handleRollback) break;
                this.verifyEntry(entryInfo);
                return new RollbackStatement(this.getConnection());
            }
            default: {
                SetTransactionDescriptor desc;
                if (!this.m_handleSetTransaction || (desc = entryInfo.getTransactionDescriptor()) == null) break;
                this.verifyEntry(entryInfo);
                return new SetTransactionStatement(this.getConnection(), desc);
            }
        }
        return this.baseProfile.getStatement(ndx, batch, typeMap);
    }

    private void verifyEntry(EntryInfo entryInfo) throws SQLException {
        if (entryInfo.getStatementType() != 2) {
            ProfileRefErrors.raise_EXPECTED_PREPARED_STATEMENT(entryInfo.getSQLString());
        }
        if (entryInfo.getExecuteType() != 8) {
            ProfileRefErrors.raise_EXPECTED_EXECUTE_UPDATE(entryInfo.getSQLString());
        }
        if (entryInfo.getParamCount() != 0) {
            ProfileRefErrors.raise_UNEXPECTED_PARAMS(entryInfo.getSQLString(), 0, entryInfo.getParamCount());
        }
    }

    public static class SetTransactionStatement
    extends LocalStatement {
        private int m_isolation;
        private int m_accessMode;
        private Connection m_conn;

        public SetTransactionStatement(Connection conn, SetTransactionDescriptor desc) {
            this.m_conn = conn;
            this.m_isolation = desc.getIsolationLevel();
            this.m_accessMode = desc.getAccessMode();
        }

        public int executeUpdate() throws SQLException {
            if (this.m_isolation != 0) {
                this.m_conn.setTransactionIsolation(this.m_isolation);
            }
            if (this.m_accessMode != 3) {
                this.m_conn.setReadOnly(this.m_accessMode == 1);
            }
            return 0;
        }
    }

    public static class RollbackStatement
    extends LocalStatement {
        private Connection m_conn;

        public RollbackStatement(Connection conn) {
            this.m_conn = conn;
        }

        public int executeUpdate() throws SQLException {
            this.m_conn.rollback();
            return 0;
        }
    }

    public static class CommitStatement
    extends LocalStatement {
        private Connection m_conn;

        public CommitStatement(Connection conn) {
            this.m_conn = conn;
        }

        public int executeUpdate() throws SQLException {
            this.m_conn.commit();
            return 0;
        }
    }
}

