/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.runtime.profile.ref;

import com.sap.sql.sqlj.runtime.profile.ref.DynamicProfile;
import com.sap.sql.sqlj.runtime.profile.ref.IterConvertProfile;
import com.sap.sql.sqlj.runtime.profile.ref.JDBCProfile;
import com.sap.sql.sqlj.runtime.profile.ref.ParamRegProfile;
import com.sap.sql.sqlj.runtime.profile.ref.PositionedProfile;
import com.sap.sql.sqlj.runtime.profile.ref.ProfileDataImpl;
import com.sap.sql.sqlj.runtime.profile.ref.ProfileWrapper;
import com.sap.sql.sqlj.runtime.profile.ref.TransactionControlProfile;
import com.sap.sql.sqlj.runtime.profile.ref.UntypedSelectProfile;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import sqlj.runtime.profile.ConnectedProfile;
import sqlj.runtime.profile.Customization;
import sqlj.runtime.profile.EntryInfo;
import sqlj.runtime.profile.Loader;
import sqlj.runtime.profile.Profile;
import sqlj.runtime.profile.ProfileData;

public class ProfileImpl
extends Profile {
    private String m_profileName;
    private String m_contextName;
    private long m_timestamp;
    private Vector m_customizations = new Vector();
    private ProfileData m_profileData;
    static final long serialVersionUID = -2161640844900440703L;

    public ProfileImpl(String profileName, String contextName, EntryInfo[] entries, Loader loader, String sourceFile) {
        super(loader);
        this.m_profileName = profileName;
        this.m_contextName = contextName;
        this.m_timestamp = System.currentTimeMillis();
        this.m_profileData = new ProfileDataImpl(entries, this, sourceFile);
    }

    public String getProfileName() {
        return this.m_profileName;
    }

    public String getContextName() {
        return this.m_contextName;
    }

    public long getTimestamp() {
        return this.m_timestamp;
    }

    public ProfileData getProfileData() {
        return this.m_profileData;
    }

    public ConnectedProfile getConnectedProfile(Connection conn) throws SQLException {
        Enumeration enumeration = this.getCustomizations();
        while (enumeration.hasMoreElements()) {
            Customization c = (Customization)enumeration.nextElement();
            if (!c.acceptsConnection(conn)) continue;
            return c.getProfile(conn, this);
        }
        return ProfileImpl.getDefaultProfile(conn, this.getProfileData());
    }

    public static ConnectedProfile getDefaultProfile(Connection conn, ProfileData data) {
        DynamicProfile dprofile = new JDBCProfile(conn, data);
        dprofile = new IterConvertProfile(dprofile);
        dprofile = new UntypedSelectProfile(dprofile);
        dprofile = new ParamRegProfile(dprofile);
        ProfileWrapper profile = new PositionedProfile(dprofile);
        profile = new TransactionControlProfile(profile);
        return profile;
    }

    public void registerCustomization(Customization customization) {
        if (customization == null) {
            throw new NullPointerException();
        }
        this.m_customizations.addElement(customization);
    }

    public void registerCustomization(Customization newCustomization, Customization nextCustomization) {
        if (newCustomization == null) {
            throw new NullPointerException();
        }
        Vector vector = this.m_customizations;
        synchronized (vector) {
            int ndx = this.m_customizations.indexOf(nextCustomization);
            if (ndx == -1) {
                throw new IllegalArgumentException(nextCustomization + "");
            }
            this.m_customizations.insertElementAt(newCustomization, ndx);
        }
    }

    public void replaceCustomization(Customization newCustomization, Customization oldCustomization) {
        if (newCustomization == null) {
            throw new NullPointerException();
        }
        Vector vector = this.m_customizations;
        synchronized (vector) {
            int ndx = this.m_customizations.indexOf(oldCustomization);
            if (ndx == -1) {
                throw new IllegalArgumentException(oldCustomization + "");
            }
            this.m_customizations.setElementAt(newCustomization, ndx);
        }
    }

    public void deregisterCustomization(Customization customization) {
        if (!this.m_customizations.removeElement(customization)) {
            throw new IllegalArgumentException(customization + "");
        }
    }

    public Enumeration getCustomizations() {
        return this.m_customizations.elements();
    }
}

