/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.runtime.profile.ref;

import com.sap.sql.sqlj.runtime.profile.ref.DynamicProfile;
import com.sap.sql.sqlj.runtime.profile.ref.DynamicProfileWrapper;
import com.sap.sql.sqlj.runtime.profile.ref.LocalStatement;
import com.sap.sql.sqlj.runtime.profile.ref.ProfileRefErrors;
import com.sap.sql.sqlj.runtime.profile.ref.RTCallableStatement;
import com.sap.sql.sqlj.runtime.profile.ref.RTResultSetJDBC;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import sqlj.runtime.profile.BatchContext;
import sqlj.runtime.profile.ConnectedProfile;
import sqlj.runtime.profile.EntryInfo;
import sqlj.runtime.profile.Profile;
import sqlj.runtime.profile.RTResultSet;
import sqlj.runtime.profile.RTStatement;

public class IterConvertProfile
extends DynamicProfileWrapper {
    public IterConvertProfile(DynamicProfile p) {
        super(p);
    }

    public RTStatement getStatement(int ndx, BatchContext batch, Map typeMap) throws SQLException {
        RTStatement result;
        EntryInfo entry = this.getProfileData().getEntryInfo(ndx);
        if (entry.getRole() == 18) {
            if (entry.getStatementType() != 2) {
                ProfileRefErrors.raise_EXPECTED_CALLABLE_STATEMENT(entry.getSQLString());
            }
            if (entry.getExecuteType() != 16) {
                ProfileRefErrors.raise_EXPECTED_EXECUTE_UPDATE(entry.getSQLString());
            }
            result = IterConvertProfile.newIterConvertStatement(this, entry);
        } else {
            result = super.getStatement(ndx, batch, typeMap);
        }
        return result;
    }

    public static RTStatement newIterConvertStatement(ConnectedProfile profile, EntryInfo info) throws SQLException {
        return new IterConvertStatement(profile, info);
    }

    public static class IterConvertStatement
    extends LocalStatement
    implements RTCallableStatement {
        private ResultSet m_rs = null;
        private EntryInfo m_entry;
        private Profile m_profile;

        public IterConvertStatement(ConnectedProfile profile, EntryInfo entry) throws SQLException {
            this.m_entry = entry;
            this.m_profile = profile.getProfileData().getProfile();
        }

        public void registerOutParameter(int paramNum, int sqlType) throws SQLException {
        }

        public void setObject(int paramNum, Object obj) throws SQLException {
            if (obj instanceof ResultSet && paramNum == 1) {
                this.m_rs = (ResultSet)obj;
            } else {
                ProfileRefErrors.raise_UNEXPECTED_CALL("setObject");
            }
        }

        private ResultSet getResultSetParam() throws SQLException {
            if (this.m_rs == null) {
                ProfileRefErrors.raise_UNEXPECTED_CALL("getResultSetParam");
            }
            return this.m_rs;
        }

        public RTResultSet executeRTQuery() throws SQLException {
            return this.toRTResultSet(this.getResultSetParam());
        }

        protected RTResultSet toRTResultSet(ResultSet rs) throws SQLException {
            return new RTResultSetJDBC(rs);
        }
    }
}

