/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.framework.ide;

import com.sap.sql.sqlj.framework.error.ErrorLog;
import com.sap.sql.sqlj.framework.error.Info;
import com.sap.sql.sqlj.framework.error.JSError;
import com.sap.sql.sqlj.framework.error.LogEntry;
import com.sap.sql.sqlj.framework.error.Position;
import com.sap.sql.sqlj.framework.error.Warning;
import com.sap.sql.sqlj.framework.ide.TranslationLog;

public class TranslationLogWrapper
implements ErrorLog {
    private int m_numWarnings = 0;
    private int m_numErrors = 0;
    private String m_filename = null;
    private TranslationLog m_log;

    public TranslationLogWrapper(TranslationLog log) {
        this.m_log = log;
    }

    public void addEntryOffset(LogEntry entry, int offset) {
        this.addEntry(entry);
        if (offset > 0) {
            Position p = entry.getPosition();
            entry.setRegion(p.startLine() + offset - 1, p.startCol(), p.startLine() + offset - 1, p.endCol());
        }
    }

    public void addEntry(LogEntry entry) {
        entry.setFileName(this.m_filename);
        Position p = entry.getPosition();
        if (p == null) {
            p = new Position();
        }
        if (entry instanceof JSError) {
            this.incErrorCount();
            this.m_log.logError(entry.getMessage(), p.startLine(), p.startCol(), p.endLine(), p.endCol());
        } else if (entry instanceof Warning) {
            this.incWarningCount();
            this.m_log.logWarning(entry.getMessage(), p.startLine(), p.startCol(), p.endLine(), p.endCol());
        } else if (entry instanceof Info) {
            this.m_log.logInfo(entry.getMessage(), p.startLine(), p.startCol(), p.endLine(), p.endCol());
        }
    }

    public void addEntry(LogEntry entry, int line, int col) {
        entry.setPosition(new Position(line, col));
        this.addEntry(entry);
    }

    public void addEntryRegion(LogEntry entry, int startline, int startcol, int endline, int endcol) {
        entry.setRegion(startline, startcol, endline, endcol);
        this.addEntry(entry);
    }

    public int errorCount() {
        return this.m_numErrors;
    }

    public void incErrorCount() {
        ++this.m_numErrors;
    }

    public int warningCount() {
        return this.m_numWarnings;
    }

    public void incWarningCount() {
        ++this.m_numWarnings;
    }

    public void setFileName(String s) {
        this.m_filename = s;
    }

    public String getFileName() {
        return this.m_filename;
    }

    public Position getDefaultRegion() {
        return null;
    }
}

