/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.framework;

import com.sap.sql.sqlj.framework.ClassResolver;
import com.sap.sql.sqlj.framework.JSClass;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class BaseJSClass {
    private static final int ARRAY_MODS = 1040;
    private static final String OBJECT_NAME = "java.lang.Object";
    private boolean m_isInterface;
    private int m_modifiers;
    private boolean m_isPrimitive;
    private String m_name;
    private JSClass m_componentType = null;
    private ClassResolver m_resolver = null;
    private String m_superclassName = null;
    private JSClass m_fullClass = null;
    private Hashtable m_referringClasses = new Hashtable();
    private ClassNotFoundException m_error = null;

    public BaseJSClass(String name, int modifiers, ClassResolver resolver) {
        this(name, modifiers, resolver, null);
    }

    public BaseJSClass(String name, int modifiers, ClassResolver resolver, String superclassName) {
        this(name, modifiers, false, resolver, superclassName);
    }

    BaseJSClass(String name, int modifiers, boolean isPrimitive, ClassResolver resolver, String superclassName) {
        this(name, modifiers, isPrimitive, superclassName);
        this.m_componentType = null;
        this.m_resolver = resolver;
        this.m_resolver.addClass(this);
    }

    BaseJSClass(String name, JSClass componentType) {
        this(name, BaseJSClass.getArrayMods(componentType), false, OBJECT_NAME);
        this.m_componentType = componentType;
        this.m_resolver = null;
    }

    private static int getArrayMods(JSClass componentType) {
        int mods = componentType.getModifiers();
        mods = 0x410 | mods & 0xFFFFFFF8;
        return mods;
    }

    private BaseJSClass(String name, int modifiers, boolean isPrimitive, String superclassName) {
        this.m_modifiers = modifiers;
        this.m_isInterface = Modifier.isInterface(modifiers);
        this.m_isPrimitive = isPrimitive;
        this.m_name = name;
        if (this.m_isPrimitive) {
            if (superclassName != null) {
                throw new IllegalArgumentException();
            }
        } else if (this.m_isInterface) {
            if (superclassName != null && !superclassName.equals(OBJECT_NAME)) {
                throw new IllegalArgumentException();
            }
        } else {
            if (superclassName == null && !name.equals(OBJECT_NAME)) {
                this.m_superclassName = OBJECT_NAME;
            }
            this.m_superclassName = superclassName;
        }
    }

    public final boolean isInterface() {
        return this.m_isInterface;
    }

    public final boolean isArray() {
        return this.m_componentType != null;
    }

    public final boolean isPrimitive() {
        return this.m_isPrimitive;
    }

    public final String getName() {
        return this.m_name;
    }

    public String toString() {
        return this.getName();
    }

    public final JSClass getComponentType() {
        return this.m_componentType;
    }

    public final int getModifiers() {
        return this.m_modifiers;
    }

    public final String getSuperclassName() {
        return this.m_superclassName;
    }

    final void setJSClass(JSClass fullClass) {
        if (this.m_fullClass == null) {
            this.m_fullClass = fullClass;
        } else if (this.m_fullClass != fullClass) {
            throw new IllegalArgumentException("JSClass for this BaseJSClass already exists");
        }
    }

    private void invalidateJSClass() {
        if (this.m_fullClass != null) {
            this.m_fullClass = null;
            Enumeration refs = this.m_referringClasses.elements();
            while (refs.hasMoreElements()) {
                ((BaseJSClass)refs.nextElement()).invalidateJSClass();
            }
            this.m_referringClasses.clear();
        }
    }

    public final JSClass getJSClass() throws ClassNotFoundException {
        if (this.m_error != null) {
            throw this.m_error;
        }
        if (this.m_fullClass == null) {
            try {
                this.createJSClass();
                if (this.m_fullClass == null) {
                    throw new ClassNotFoundException(this.getName());
                }
            }
            catch (ClassNotFoundException e) {
                this.invalidateJSClass();
                this.m_error = e;
                throw e;
            }
        }
        return this.m_fullClass;
    }

    JSClass resolveClass(String className) throws ClassNotFoundException {
        return this.resolveClass(this.m_resolver.getClass(className));
    }

    JSClass resolveClass(BaseJSClass cls) throws ClassNotFoundException {
        return cls.getJSClass(this);
    }

    private JSClass getJSClass(BaseJSClass referringClass) throws ClassNotFoundException {
        JSClass cls = this.getJSClass();
        this.m_referringClasses.put(referringClass.getName(), referringClass);
        return cls;
    }

    ClassResolver getClassResolver() {
        return this.m_resolver;
    }

    protected abstract JSClass createJSClass() throws ClassNotFoundException;
}

