/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.common;

import com.sap.sql.catalog.CatalogReader;
import com.sap.sql.sqlj.common.mesg.CommonSQLCheckerErrors;
import com.sap.sql.sqlj.framework.JSClass;
import com.sap.sql.sqlj.framework.JSMethod;
import com.sap.sql.sqlj.framework.checker.HostItem;
import com.sap.sql.sqlj.framework.checker.SQLChecker;
import com.sap.sql.sqlj.framework.checker.SQLOperation;
import com.sap.sql.sqlj.framework.error.ErrorLog;
import com.sap.sql.sqlj.framework.error.JSError;
import com.sap.sql.sqlj.framework.error.Position;
import com.sap.sql.sqlj.framework.error.Warning;
import com.sap.sql.sqlj.framework.options.InvalidOptionException;
import com.sap.sql.sqlj.framework.options.PropertyList;
import com.sap.sql.sqlj.semantics.SQLOperationImpl;
import com.sap.sql.sqlparser.CommonSQLParserException;
import com.sap.sql.sqlparser.CommonSQLStatement;
import com.sap.sql.sqlparser.LogEntry;
import com.sap.sql.tree.GeneralSelectStatement;
import com.sap.sql.tree.QuerySpecification;
import com.sap.sql.tree.ResultDescriptor;
import com.sap.sql.tree.SelectStatement;
import com.sap.sql.tree.SortSpecification;
import com.sap.tc.logging.Location;
import java.sql.SQLException;
import java.util.Hashtable;

public class CommonSQLChecker
implements SQLChecker {
    private CommonSQLStatement statement;
    private CatalogReader catalogReader;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$sql$sqlj$common$CommonSQLChecker == null ? (class$com$sap$sql$sqlj$common$CommonSQLChecker = CommonSQLChecker.class$("com.sap.sql.sqlj.common.CommonSQLChecker")) : class$com$sap$sql$sqlj$common$CommonSQLChecker));
    private static final Integer RETURN_MODE = new Integer(5);
    private static final Integer IN_MODE = new Integer(1);
    private static final Integer INOUT_MODE = new Integer(2);
    private static final Integer OUT_MODE = new Integer(4);
    static /* synthetic */ Class class$com$sap$sql$sqlj$common$CommonSQLChecker;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$io$Reader;
    static /* synthetic */ Class class$java$sql$Clob;
    static /* synthetic */ Class class$java$sql$Blob;

    public CommonSQLChecker(CatalogReader reader) {
        this.catalogReader = reader;
    }

    private void checkNamedIterator(JSClass namedIter, ResultDescriptor[] columns, ErrorLog el) {
        JSMethod[] methods = namedIter.getDeclaredMethods();
        int columnCount = columns.length;
        int methodCount = methods.length;
        Hashtable<String, Integer> resultSetIndices = new Hashtable<String, Integer>();
        Hashtable<String, Boolean> uniqueNames = new Hashtable<String, Boolean>();
        boolean[] columnFound = new boolean[columnCount];
        int i = 0;
        while (i < columnCount) {
            String col_name = columns[i].getName();
            columnFound[i] = false;
            if (col_name != null) {
                String ColName = col_name.toUpperCase();
                Integer prev = resultSetIndices.put(ColName, new Integer(i));
                if (prev == null) {
                    uniqueNames.put(ColName, new Boolean(true));
                } else {
                    uniqueNames.put(ColName, new Boolean(false));
                }
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < methodCount) {
            if (methods[i2].getParameterTypes().length == 0) {
                String name = methods[i2].getName().toUpperCase();
                Integer index = (Integer)resultSetIndices.get(name);
                if (index != null) {
                    Boolean unique = (Boolean)uniqueNames.get(name);
                    if (unique.booleanValue()) {
                        JSClass javaType = methods[i2].getReturnType();
                        int j = index;
                        columnFound[j] = true;
                        this.checkTypeCompatibility(columns[j], name, javaType, el);
                    } else {
                        el.addEntry(new JSError(CommonSQLCheckerErrors.msg("Ambiguous_column", name)));
                        int jj = 0;
                        while (jj < columnCount) {
                            if (name.equalsIgnoreCase(columns[jj].getName())) {
                                columnFound[jj] = true;
                            }
                            ++jj;
                        }
                    }
                } else {
                    JSClass javaType = methods[i2].getReturnType();
                    el.addEntry(new JSError(CommonSQLCheckerErrors.msg("Column_not_found", name, this.printJavaType(javaType))));
                }
            }
            ++i2;
        }
        int j = 0;
        while (j < columnCount) {
            if (!columnFound[j]) {
                el.addEntry(new Warning(CommonSQLCheckerErrors.msg("column_unused", columns[j].getName(), columns[j].getJdbcTypeName())));
            }
            ++j;
        }
    }

    private void checkPositionalIterator(JSClass posIter, ResultDescriptor[] columns, ErrorLog el) {
        JSMethod[] methods = posIter.getDeclaredMethods();
        int columnCount = columns.length;
        int methodCount = methods.length;
        boolean[] columnFound = new boolean[columnCount];
        int i = 0;
        while (i < columnCount) {
            columnFound[i] = false;
            ++i;
        }
        int i2 = 0;
        while (i2 < methodCount) {
            String name = methods[i2].getName();
            if (name.startsWith("getCol") && methods[i2].getParameterTypes().length == 0) {
                JSClass javaType;
                int j = 0;
                try {
                    j = Integer.parseInt(name.substring(6)) - 1;
                }
                catch (NumberFormatException e) {
                    j = -1;
                }
                if (j < 0) {
                    el.addEntry(new JSError(CommonSQLCheckerErrors.msg("INTERNAL_ERROR", "CommonSQLCheker")));
                } else if (j >= columnCount) {
                    javaType = methods[i2].getReturnType();
                    el.addEntry(new JSError(CommonSQLCheckerErrors.msg(columnCount == 1 ? "only_one_columns" : "too_few_columns", new Integer(j), this.printJavaType(javaType), new Integer(columnCount))));
                } else if (columnFound[j]) {
                    el.addEntry(new JSError(CommonSQLCheckerErrors.msg("INTERNAL_ERROR", "CommonSQLCheker")));
                } else {
                    javaType = methods[i2].getReturnType();
                    columnFound[j] = true;
                    this.checkTypeCompatibility(columns[j], "#" + (j + 1), javaType, el);
                }
            }
            ++i2;
        }
        int j = 0;
        while (j < columnCount) {
            if (!columnFound[j]) {
                el.addEntry(new JSError(CommonSQLCheckerErrors.msg("No_INTO_variable", "" + j, columns[j].getName(), columns[j].getJdbcTypeName())));
            }
            ++j;
        }
    }

    public void describeSQLOperation(ErrorLog el, SQLOperation op) {
        int startErrorCount = el.errorCount();
        if (op == null) {
            throw new IllegalArgumentException("SQLChecker.describeSQLOperation(): SQLOperation is null");
        }
        if (op.getOperationCode() != 1023) {
            el.addEntry(new JSError(CommonSQLCheckerErrors.msg("INTERNAL_ERROR", "SQLChecker: SQLOperation != SQLOperation.UNKNOWN")));
            return;
        }
        String stmntSource = op.getSQLString();
        if (stmntSource == null) {
            throw new IllegalArgumentException("SQLChecker.describeSQLOperation(): getSQLString == null");
        }
        try {
            this.statement = new CommonSQLStatement(stmntSource);
            int oc = this.statement.getOperationCode();
            switch (oc) {
                case 2: 
                case 32: {
                    JSClass resultType = op.getResultType();
                    boolean isSelectInto = ((SQLOperationImpl)op).hasIntoBindExpr();
                    if (isSelectInto && !this.isSingleRowQuery(this.statement)) {
                        el.addEntry(new JSError(CommonSQLCheckerErrors.msg("NoQuerySpecification")));
                    }
                    op.setOperationCode(2);
                    if (resultType == null) break;
                    if (!this.isCursorType(resultType)) {
                        el.addEntry(new JSError(CommonSQLCheckerErrors.msg("Return_type_incompatible", this.printJavaType(resultType))));
                        break;
                    }
                    this.checkTypeAccessibility(el, resultType);
                    break;
                }
                case 4: 
                case 8: 
                case 16: {
                    op.setOperationCode(3);
                    break;
                }
                case 64: {
                    op.setOperationCode(11);
                    return;
                }
                case 128: {
                    op.setOperationCode(12);
                    return;
                }
                case 256: {
                    el.addEntry(new JSError(CommonSQLCheckerErrors.msg("noCreateView")));
                    op.setOperationCode(1023);
                    return;
                }
            }
            this.statement.checkSemantics(this.catalogReader);
        }
        catch (CommonSQLParserException ex) {
            this.handleErrorParserException(el, ex);
            return;
        }
        catch (SQLException e) {
            LOCATION.traceThrowableT(500, "unexpected SQLException", (Throwable)e);
            JSError error = new JSError("SQLException occured: " + e.getMessage());
            el.addEntry(error);
        }
        int i = 1;
        int max = op.hostItemCount();
        while (i <= max) {
            ResultDescriptor hostVar = this.statement.getSQLStatement().getHostVariablesList()[i - 1];
            HostItem h = op.hostItem(i);
            JSClass sqljClass = h.getHostItemType();
            if (h.getHostItemMode() == 0) {
                h.setHostItemMode(1);
            }
            if (null == hostVar) {
                el.addEntry(new JSError(CommonSQLCheckerErrors.msg("INTERNAL_ERROR")));
            } else if (hostVar.isSupported) {
                Class javaClass = this.toJavaClass(sqljClass);
                if (!hostVar.isSetableFrom(javaClass, this.catalogReader.isLogicalCatalogReader())) {
                    String hostVarName = h.getHostItemName();
                    String message = null;
                    message = hostVarName == null ? CommonSQLCheckerErrors.msg("hostexpressionColumnMismatch", new Integer(i), this.printJavaType(sqljClass), hostVar.getName(), hostVar.getJdbcTypeName()) : CommonSQLCheckerErrors.msg("hostvariableColumnMismatch", hostVarName, this.printJavaType(sqljClass), hostVar.getName(), hostVar.getJdbcTypeName());
                    el.addEntry(new JSError(message));
                }
            } else {
                el.addEntry(new Warning("SQLChecker: type " + hostVar.getJdbcTypeName() + " is not supported. (Host variable number " + i + ")"));
            }
            ++i;
        }
        switch (op.getOperationCode()) {
            case 2: {
                JSClass iter = op.getResultType();
                ResultDescriptor[] columns = ((GeneralSelectStatement)this.statement.getSQLStatement()).getResultSetColumns();
                if (columns == null) {
                    el.addEntry(new JSError(CommonSQLCheckerErrors.msg("select_list_empty")));
                }
                if (iter == null) break;
                if (JSClass.PositionedIterator_TYPE.isAssignableFrom(iter)) {
                    if (((GeneralSelectStatement)this.statement.getSQLStatement()).isSelectAsterisk()) {
                        el.addEntry(new JSError(CommonSQLCheckerErrors.msg("SelectAsteriskWithPositionalIterator")));
                    }
                    this.checkPositionalIterator(iter, columns, el);
                    break;
                }
                if (JSClass.NamedIterator_TYPE.isAssignableFrom(iter)) {
                    this.checkNamedIterator(iter, columns, el);
                    break;
                }
                if (JSClass.ResultSetIterator_TYPE != iter) break;
                break;
            }
            case 3: {
                break;
            }
            case 11: 
            case 12: {
                break;
            }
            default: {
                if (startErrorCount != el.errorCount()) break;
                throw new IllegalStateException("illegal SQLOperation");
            }
        }
    }

    private void handleErrorParserException(ErrorLog el, CommonSQLParserException ex) {
        int errorCount = ex.getSize();
        Position defaultRegion = el.getDefaultRegion();
        int startLine = defaultRegion.startLine();
        int startColumn = defaultRegion.startCol();
        int i = 0;
        while (i < errorCount) {
            LogEntry entry = ex.getEntry(i);
            JSError theError = new JSError(entry.getMessage());
            int column = entry.getColumn();
            if (column > 0) {
                el.addEntry(theError, startLine + entry.getLine() - 1, startColumn + entry.getColumn());
            } else {
                el.addEntryOffset(theError, entry.getLine());
            }
            ++i;
        }
    }

    private boolean isSingleRowQuery(CommonSQLStatement statement) {
        if (statement.getOperationCode() == 32) {
            return true;
        }
        SelectStatement stmt = (SelectStatement)statement.getSQLStatement();
        SortSpecification[] orderBy = stmt.getOrderByList();
        if ((orderBy == null || orderBy.length == 0) && stmt.getQuery() instanceof QuerySpecification) {
            QuerySpecification qSpec = (QuerySpecification)stmt.getQuery();
            if (qSpec.getGroupByList() != null && qSpec.getGroupByList().length > 0) {
                return false;
            }
            return qSpec.getHavingClause() == null;
        }
        return false;
    }

    private void checkTypeCompatibility(ResultDescriptor column, String name, JSClass sqljClass, ErrorLog el) {
        boolean compatible = false;
        if (column.isSupported) {
            Class javaClass = this.toJavaClass(sqljClass);
            compatible = column.isGetableInto(javaClass, this.catalogReader.isLogicalCatalogReader());
            if (!compatible) {
                String message = CommonSQLCheckerErrors.msg("resultSetColumnMismatch", name, this.printJavaType(sqljClass), column.getName(), column.getJdbcTypeName());
                el.addEntry(new JSError(message));
            }
        } else {
            String message = CommonSQLCheckerErrors.msg("TypeNotSupported", column.getJdbcTypeName(), name);
            el.addEntry(new JSError(message));
        }
        if (compatible && column.isNullable() && sqljClass.isPrimitive()) {
            el.addEntry(new Warning(CommonSQLCheckerErrors.msg("column_not_nullable", name, this.printJavaType(sqljClass))));
        }
    }

    private String printJavaType(JSClass javaType) {
        if (javaType == null) {
            throw new IllegalArgumentException("JSClass was null");
        }
        String name = javaType.toString();
        while (name.startsWith("[")) {
            name = name.substring(1) + "[]";
        }
        return name;
    }

    private boolean isCursorType(JSClass sqljClass) {
        return JSClass.PositionedIterator_TYPE.isAssignableFrom(sqljClass) && sqljClass != JSClass.PositionedIterator_TYPE || JSClass.NamedIterator_TYPE.isAssignableFrom(sqljClass) && sqljClass != JSClass.NamedIterator_TYPE || sqljClass == JSClass.ResultSetIterator_TYPE;
    }

    private void checkTypeAccessibility(ErrorLog el, JSClass cur) {
        boolean isNamed = JSClass.NamedIterator_TYPE.isAssignableFrom(cur);
        boolean isInto = cur.toString().equals("dummy*Iterator");
        JSMethod[] methods = cur.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            String name = methods[i].getName();
            if (!(name == null || name.equals("close") || name.equals("next") || name.equals("getResultSet") || name.equals("isClosed") || name.equals("endFetch"))) {
                int num_params = methods[i].getParameterTypes().length;
                JSClass javaType = methods[i].getReturnType();
                if (num_params == 0 && !JSClass.ResultSet_TYPE.hasAccessTo(javaType)) {
                    if (!isNamed) {
                        name = "#" + name.substring(6);
                    }
                    String msg = isInto ? CommonSQLCheckerErrors.msg("Type_not_accessible", this.printJavaType(javaType), name) : CommonSQLCheckerErrors.msg("Type_of_column_inaccessible", this.printJavaType(javaType), name);
                    el.addEntry(new JSError(msg));
                }
            }
            ++i;
        }
    }

    private Class toJavaClass(JSClass sqljClass) {
        if (JSClass.BinaryStream_TYPE.isAssignableFrom(sqljClass)) {
            return class$java$io$InputStream == null ? (class$java$io$InputStream = CommonSQLChecker.class$("java.io.InputStream")) : class$java$io$InputStream;
        }
        if (JSClass.CharacterStream_TYPE.isAssignableFrom(sqljClass)) {
            return class$java$io$Reader == null ? (class$java$io$Reader = CommonSQLChecker.class$("java.io.Reader")) : class$java$io$Reader;
        }
        if (JSClass.Clob_TYPE.isAssignableFrom(sqljClass)) {
            return class$java$sql$Clob == null ? (class$java$sql$Clob = CommonSQLChecker.class$("java.sql.Clob")) : class$java$sql$Clob;
        }
        if (JSClass.Blob_TYPE.isAssignableFrom(sqljClass)) {
            return class$java$sql$Blob == null ? (class$java$sql$Blob = CommonSQLChecker.class$("java.sql.Blob")) : class$java$sql$Blob;
        }
        return sqljClass.toClass();
    }

    public void setOptions(PropertyList props, ErrorLog log) throws InvalidOptionException {
    }

    public String[][] getOptionInfo() {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

