/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.common;

import com.sap.sql.catalog.CatalogReader;
import com.sap.sql.catalog.CatalogReaderFactory;
import com.sap.sql.sqlj.common.ConfigurationException;
import java.sql.SQLException;

public class CatalogReaderManager {
    public CatalogReader getCatalogReader(String readerString) throws SQLException, ConfigurationException {
        int firstSlash = readerString.indexOf("/");
        if (firstSlash > 0) {
            String readerType = readerString.substring(0, firstSlash);
            if (!readerType.equals("file")) {
                throw new ConfigurationException("The catalog reader string \"" + readerString + "\" does not start with \"xml/file/\".");
            }
            String readerArg = readerString.substring(firstSlash + 1);
            if (readerArg.length() > 0) {
                return CatalogReaderFactory.createCatalogReader("file://" + readerArg, false);
            }
            throw new SQLException("The path to the catalog reader is empty.");
        }
        throw new ConfigurationException("The catalog reader string \"" + readerString + "\" does not start with \"xml/file/\".");
    }
}

