/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.codegen;

import com.sap.sql.sqlj.codegen.ExecStmt;
import com.sap.sql.sqlj.codegen.IntoGroup;
import com.sap.sql.sqlj.codegen.JSClassType;
import com.sap.sql.sqlj.codegen.ResultSetIntoGroup;
import com.sap.sql.sqlj.codegen.engine.ExprStatement;
import com.sap.sql.sqlj.codegen.engine.FieldDecl;
import com.sap.sql.sqlj.codegen.engine.IfStatement;
import com.sap.sql.sqlj.codegen.engine.ObjectExpression;
import com.sap.sql.sqlj.codegen.engine.ObjectStatement;
import com.sap.sql.sqlj.codegen.engine.StatementBlock;

class SelectIntoStmt
extends StatementBlock {
    private ResultSetIntoGroup m_intoGroup;
    private ObjectExpression m_columnCount = new ObjectExpression();

    public SelectIntoStmt(ExecStmt query, String resultSetName) {
        this.m_intoGroup = new ResultSetIntoGroup(resultSetName, this.m_columnCount, query);
        FieldDecl rtResultSetDecl = new FieldDecl();
        rtResultSetDecl.name(resultSetName);
        rtResultSetDecl.type(JSClassType.RTResultSet_TYPE);
        this.addStatement(rtResultSetDecl);
        this.addStatement(query);
        this.addStatement(new ObjectStatement("try "));
        StatementBlock tryBlock = new StatementBlock();
        this.addStatement(tryBlock);
        ObjectExpression ifCond = new ObjectExpression("!" + resultSetName + ".next()");
        StatementBlock ifBody = new StatementBlock();
        ifBody.addStatement(new ExprStatement(new ObjectExpression("throw new com.sap.sql.NoDataException()")));
        tryBlock.addStatement(new IfStatement(ifCond, ifBody));
        tryBlock.addStatement(this.m_intoGroup);
        ifCond = new ObjectExpression(resultSetName + ".next()");
        ifBody = new StatementBlock();
        ifBody.addStatement(new ExprStatement(new ObjectExpression("throw new com.sap.sql.CardinalityViolationException()")));
        tryBlock.addStatement(new IfStatement(ifCond, ifBody));
        this.addStatement(new ObjectStatement("finally "));
        StatementBlock finallyBlock = new StatementBlock();
        this.addStatement(finallyBlock);
        finallyBlock.addStatement(new ExprStatement(new ObjectExpression(resultSetName + ".close()")));
    }

    public IntoGroup getIntoGroup() {
        return this.m_intoGroup;
    }
}

