/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.codegen;

import com.sap.sql.sqlj.codegen.HelperClassDecl;
import com.sap.sql.sqlj.codegen.JSClassType;
import com.sap.sql.sqlj.codegen.ProfileDecl;
import com.sap.sql.sqlj.codegen.ProfileKeysJSClass;
import com.sap.sql.sqlj.codegen.Util;
import com.sap.sql.sqlj.codegen.engine.AssignmentStatement;
import com.sap.sql.sqlj.codegen.engine.BaseMethodDecl;
import com.sap.sql.sqlj.codegen.engine.Expression;
import com.sap.sql.sqlj.codegen.engine.FieldDecl;
import com.sap.sql.sqlj.codegen.engine.IfStatement;
import com.sap.sql.sqlj.codegen.engine.Initializer;
import com.sap.sql.sqlj.codegen.engine.Modifiers;
import com.sap.sql.sqlj.codegen.engine.NewArray;
import com.sap.sql.sqlj.codegen.engine.ObjectExpression;
import com.sap.sql.sqlj.codegen.engine.ObjectStatement;
import com.sap.sql.sqlj.codegen.engine.StatementBlock;
import com.sap.sql.sqlj.codegen.engine.StatementGroup;
import com.sap.sql.sqlj.codegen.engine.Type;
import com.sap.sql.sqlj.framework.JSClass;
import com.sap.sql.sqlj.util.Parselet;
import java.util.Hashtable;

class ProfileKeysDecl
extends HelperClassDecl {
    private static final String LOADER = "loader";
    private static final String INST = "inst";
    private static final String KEYS = "keys";
    private static final String KEY_NUM = "keyNum";
    private static final String CONTEXT = "context";
    static final String GET_KEY = "getKey";
    private static final String PROFILE_SUFFIX = Util.newClassName("Profile");
    private static final String PROFILE_KEYS_SUFFIX = PROFILE_SUFFIX + "Keys";
    private static final Expression NULL_EXPR = new ObjectExpression("null");
    private JSClassType.Factory m_typeFactory;
    private NewArray m_keyInit;
    private StatementGroup m_keyAssign;
    private Type m_classType;
    private String m_baseClassName;
    private String m_classQualifier;
    private Hashtable m_profiles = new Hashtable();
    private int m_keyNum = 0;
    private int m_stmtNum = 0;
    private String m_sourceFile;

    public ProfileKeysDecl(String classQualifier, String baseClassName, Parselet unitParselet, String sourceFile) {
        this.m_typeFactory = new JSClassType.Factory.ElemFactory(unitParselet);
        this.m_baseClassName = baseClassName;
        this.m_classQualifier = classQualifier;
        this.m_sourceFile = sourceFile;
        this.name(baseClassName + PROFILE_KEYS_SUFFIX);
        ProfileKeysJSClass keysClass = new ProfileKeysJSClass(classQualifier + baseClassName + PROFILE_KEYS_SUFFIX, unitParselet);
        this.m_classType = this.m_typeFactory.getType(keysClass);
        FieldDecl inst = new FieldDecl();
        inst.modifiers(Modifiers.STATIC_PRIVATE);
        inst.name(INST);
        inst.type(this.m_classType);
        inst.initializer(Initializer.NULL);
        this.addBodyDecl(inst);
        this.addGetKeyMethod();
        FieldDecl loader = new FieldDecl();
        loader.modifiers(Modifiers.PRIVATE_FINAL);
        loader.name(LOADER);
        loader.type(JSClassType.Loader_TYPE);
        loader.initializer(new Initializer(new ObjectExpression(JSClassType.RuntimeContext_TYPE.name() + ".getRuntime().getLoaderForClass(getClass())")));
        this.addBodyDecl(loader);
        FieldDecl keys = new FieldDecl();
        keys.modifiers(Modifiers.PRIVATE);
        keys.name(KEYS);
        keys.type(JSClassType.ObjectArr_TYPE);
        this.addBodyDecl(keys);
        this.addConstructor();
    }

    private void addGetKeyMethod() {
        BaseMethodDecl getKey = new BaseMethodDecl(false);
        getKey.modifiers(Modifiers.STATIC_PUBLIC);
        getKey.name(GET_KEY);
        getKey.type(JSClassType.Object_TYPE);
        getKey.addException(JSClassType.SQLException_TYPE.name());
        getKey.addParameter(JSClassType.int_TYPE, KEY_NUM);
        ObjectExpression ifCond = new ObjectExpression("inst == null");
        StatementBlock ifBody = new StatementBlock();
        ifBody.addStatement(new ObjectStatement("inst = new " + this.m_classType.name() + "();"));
        getKey.addStatement(new IfStatement(ifCond, ifBody));
        getKey.addStatement(new ObjectStatement("return inst.keys[keyNum];"));
        this.addBodyDecl(getKey);
    }

    private void addConstructor() {
        BaseMethodDecl constructor = new BaseMethodDecl(false);
        constructor.modifiers(Modifiers.PRIVATE);
        constructor.addException(JSClassType.SQLException_TYPE.name());
        this.m_keyInit = new NewArray(JSClassType.Object_TYPE);
        constructor.addStatement(new AssignmentStatement(new ObjectExpression(KEYS), this.m_keyInit));
        this.m_keyAssign = new StatementGroup();
        constructor.addStatement(this.m_keyAssign);
        this.addConstructor(constructor);
    }

    public boolean hasProfile(JSClassType contextType) {
        return this.m_profiles.containsKey(contextType.toClass().getName());
    }

    public ProfileDecl getProfileDecl(JSClassType contextType) {
        return this.getProfileEntry((JSClassType)contextType).m_decl;
    }

    public Expression getProfileKey(JSClassType contextType) {
        return this.getProfileEntry((JSClassType)contextType).m_key;
    }

    public Entry getProfileEntry(JSClassType contextType) {
        JSClass contextJSClass = contextType.toClass();
        Entry entry = (Entry)this.m_profiles.get(contextJSClass.getName());
        if (entry == null) {
            String profileBaseName = this.m_baseClassName + PROFILE_SUFFIX + this.m_keyNum;
            String profileName = this.m_classQualifier + profileBaseName;
            contextType = this.m_typeFactory.getType(contextType);
            ProfileDecl decl = new ProfileDecl(this.m_classQualifier, profileBaseName, contextType, this.m_sourceFile);
            this.m_keyInit.incrementSize();
            this.m_keyAssign.addStatement(new AssignmentStatement(new ObjectExpression("keys[" + this.m_keyNum + "]"), new ObjectExpression(contextType.name() + "." + "getProfileKey" + "(" + LOADER + ", " + Util.stringify(profileName) + ")")));
            ObjectExpression key = new ObjectExpression(this.m_classType.name() + "." + GET_KEY + "(" + this.m_keyNum + ")");
            entry = new Entry(decl, key);
            this.m_profiles.put(contextJSClass.getName(), entry);
            ++this.m_keyNum;
        }
        return entry;
    }

    private static class Entry {
        public ProfileDecl m_decl;
        public Expression m_key;

        public Entry(ProfileDecl decl, Expression key) {
            this.m_decl = decl;
            this.m_key = key;
        }
    }
}

