/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.codegen;

import com.sap.sql.sqlj.codegen.CodeGenerator;
import com.sap.sql.sqlj.codegen.CodeGeneratorFactory;
import com.sap.sql.sqlj.codegen.ContextJSClass;
import com.sap.sql.sqlj.codegen.CursorJSClass;
import com.sap.sql.sqlj.codegen.UnitInfo;
import com.sap.sql.sqlj.common.ConfigurationException;
import com.sap.sql.sqlj.framework.JSClass;
import com.sap.sql.sqlj.framework.error.ErrorLog;
import com.sap.sql.sqlj.framework.options.HasOptions;
import com.sap.sql.sqlj.framework.options.InvalidOptionException;
import com.sap.sql.sqlj.framework.options.OptionGroup;
import com.sap.sql.sqlj.framework.options.PropertyList;
import com.sap.sql.sqlj.semantics.SemanticAnalyzer;
import com.sap.sql.sqlj.semantics.SemanticAnalyzerFactory;
import com.sap.sql.sqlj.syntax.ContextElem;
import com.sap.sql.sqlj.syntax.CursorElem;
import com.sap.sql.sqlj.syntax.Elem;
import com.sap.sql.sqlj.syntax.ExecElem;
import com.sap.sql.sqlj.syntax.IntoBindExpr;
import com.sap.sql.sqlj.util.BlockDescriptor;
import com.sap.sql.sqlj.util.ClassDescriptor;
import com.sap.sql.sqlj.util.DefaultParselet;
import com.sap.sql.sqlj.util.OutputContext;
import com.sap.sql.sqlj.util.Parselet;
import com.sap.sql.sqlj.util.TranslationContext;
import com.sap.sql.sqlj.util.TypeDescriptor;
import java.io.IOException;
import java.util.Map;

public class ParseletFactory
implements HasOptions {
    private SemanticAnalyzerFactory semanticsFactory = null;
    private CodeGeneratorFactory codegenFactory = null;
    private OptionGroup m_options = new OptionGroup();

    public ParseletFactory(TranslationContext ctx, Map presetCatalogReaders) {
        this.semanticsFactory = new SemanticAnalyzerFactory(ctx, this, presetCatalogReaders);
        this.codegenFactory = new CodeGeneratorFactory(ctx);
        this.m_options.addElement(this.semanticsFactory);
        this.m_options.addElement(this.codegenFactory);
    }

    public void setOptions(PropertyList props, ErrorLog log) throws InvalidOptionException {
        this.m_options.setOptions(props, log);
    }

    public String[][] getOptionInfo() {
        return this.m_options.getOptionInfo();
    }

    public JSClass newIteratorClass(IntoBindExpr intoList) throws ClassNotFoundException {
        return new CursorJSClass(intoList);
    }

    public Parselet newParselet(Elem elem) {
        if (elem instanceof CursorElem) {
            return this.newParselet((CursorElem)elem);
        }
        if (elem instanceof ExecElem) {
            return this.newParselet((ExecElem)elem);
        }
        if (elem instanceof ContextElem) {
            return this.newParselet((ContextElem)elem);
        }
        throw new IllegalArgumentException("unrecognized elem type :" + elem);
    }

    public Parselet newParselet(CursorElem e) {
        return new CursorParseletImpl(e);
    }

    public Parselet newParselet(ExecElem e) {
        return new ExecParseletImpl(e);
    }

    public Parselet newParselet(ContextElem e) {
        return new ContextParseletImpl(e);
    }

    public void resetTableDescription(String contextName, String tableName) {
        this.semanticsFactory.resetTableDescription(contextName, tableName);
    }

    public void resetCatalogReader(String contextName) {
        this.semanticsFactory.resetCatalogReader(contextName);
    }

    private class ExecParseletImpl
    extends ParseletImpl {
        private ExecElem m_exec;
        private TypeDescriptor m_desc = new BlockDescriptor();

        public ExecParseletImpl(ExecElem elem) {
            super(elem);
            this.m_exec = elem;
        }

        SemanticAnalyzer newAnalyzer() {
            return ParseletFactory.this.semanticsFactory.newSemanticAnalyzer(this.m_exec);
        }

        CodeGenerator newCodeGenerator() {
            return ParseletFactory.this.codegenFactory.newCodeGenerator(this.m_exec);
        }

        public TypeDescriptor getDescriptor() {
            return this.m_desc;
        }
    }

    private class ContextParseletImpl
    extends ParseletImpl {
        private ContextElem m_context;
        private TypeDescriptor m_desc = null;

        public ContextParseletImpl(ContextElem elem) {
            super(elem);
            this.m_context = elem;
        }

        public Parselet getEnclosingClass() {
            return this;
        }

        SemanticAnalyzer newAnalyzer() {
            return ParseletFactory.this.semanticsFactory.newSemanticAnalyzer(this.m_context);
        }

        CodeGenerator newCodeGenerator() {
            return ParseletFactory.this.codegenFactory.newCodeGenerator(this.m_context);
        }

        public TypeDescriptor getDescriptor() {
            if (this.m_desc == null) {
                this.m_desc = new ClassDescriptor(new ContextJSClass.Base(this.m_context));
            }
            return this.m_desc;
        }
    }

    private class CursorParseletImpl
    extends ParseletImpl {
        private CursorElem m_cursor;
        private TypeDescriptor m_desc = null;

        public CursorParseletImpl(CursorElem elem) {
            super(elem);
            this.m_cursor = elem;
        }

        SemanticAnalyzer newAnalyzer() {
            return ParseletFactory.this.semanticsFactory.newSemanticAnalyzer(this.m_cursor);
        }

        CodeGenerator newCodeGenerator() {
            return ParseletFactory.this.codegenFactory.newCodeGenerator(this.m_cursor);
        }

        public Parselet getEnclosingClass() {
            return this;
        }

        public TypeDescriptor getDescriptor() {
            if (this.m_desc == null) {
                this.m_desc = new ClassDescriptor(new CursorJSClass.Base(this.m_cursor));
            }
            return this.m_desc;
        }
    }

    private static abstract class ParseletImpl
    extends DefaultParselet {
        Elem m_elem;

        public ParseletImpl(Elem elem) {
            this.m_elem = elem;
            elem.setScope(this);
        }

        public boolean generate(OutputContext out) throws IOException, ConfigurationException {
            UnitInfo info = UnitInfo.getInfoFor(this);
            boolean success = this.newAnalyzer().prepare();
            if (success) {
                CodeGenerator generator = this.newCodeGenerator();
                try {
                    success = generator.generate(out);
                }
                catch (IOException e) {
                    info.addError();
                    throw e;
                }
            }
            if (!success) {
                info.addError();
            }
            return success;
        }

        abstract SemanticAnalyzer newAnalyzer();

        abstract CodeGenerator newCodeGenerator();
    }
}

