/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.codegen;

import com.sap.sql.sqlj.codegen.BaseCodegen;
import com.sap.sql.sqlj.codegen.CastStmt;
import com.sap.sql.sqlj.codegen.CommitStmt;
import com.sap.sql.sqlj.codegen.ExecStmt;
import com.sap.sql.sqlj.codegen.FetchIntoStmt;
import com.sap.sql.sqlj.codegen.HelperClassDecl;
import com.sap.sql.sqlj.codegen.IntoGroup;
import com.sap.sql.sqlj.codegen.IteratorMetaData;
import com.sap.sql.sqlj.codegen.JSClassType;
import com.sap.sql.sqlj.codegen.JavaToSQLMap;
import com.sap.sql.sqlj.codegen.ProfileDecl;
import com.sap.sql.sqlj.codegen.ProfileKeysDecl;
import com.sap.sql.sqlj.codegen.QueryExecStmt;
import com.sap.sql.sqlj.codegen.RollbackStmt;
import com.sap.sql.sqlj.codegen.SelectIntoStmt;
import com.sap.sql.sqlj.codegen.StatementsDecl;
import com.sap.sql.sqlj.codegen.TypedExpression;
import com.sap.sql.sqlj.codegen.UnitInfo;
import com.sap.sql.sqlj.codegen.UntypedQueryExecStmt;
import com.sap.sql.sqlj.codegen.UpdateExecStmt;
import com.sap.sql.sqlj.codegen.Util;
import com.sap.sql.sqlj.codegen.engine.ClassDecl;
import com.sap.sql.sqlj.codegen.engine.CodegenException;
import com.sap.sql.sqlj.codegen.engine.Expression;
import com.sap.sql.sqlj.codegen.engine.ObjectExpression;
import com.sap.sql.sqlj.codegen.engine.ObjectStatement;
import com.sap.sql.sqlj.codegen.engine.Statement;
import com.sap.sql.sqlj.codegen.engine.StatementGroup;
import com.sap.sql.sqlj.codegen.engine.Streamable;
import com.sap.sql.sqlj.common.CommonProfileCustomizer;
import com.sap.sql.sqlj.common.ConfigurationException;
import com.sap.sql.sqlj.framework.JSClass;
import com.sap.sql.sqlj.framework.error.JSError;
import com.sap.sql.sqlj.mesg.CodegenErrors;
import com.sap.sql.sqlj.syntax.BindExpr;
import com.sap.sql.sqlj.syntax.DirectBindExpr;
import com.sap.sql.sqlj.syntax.ExecElem;
import com.sap.sql.sqlj.syntax.IntoBindExpr;
import com.sap.sql.sqlj.syntax.ReturnBindExpr;
import com.sap.sql.sqlj.syntax.SQLUnit;
import com.sap.sql.sqlj.util.ClassDescriptor;
import com.sap.sql.sqlj.util.DefaultParselet;
import com.sap.sql.sqlj.util.ExpressionDescriptor;
import com.sap.sql.sqlj.util.ExpressionMetaData;
import com.sap.sql.sqlj.util.OutputContext;
import com.sap.sql.sqlj.util.Parselet;
import com.sap.sql.sqlj.util.TypeDescriptor;
import com.sap.sql.sqlj.util.UnitDescriptor;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import sqlj.runtime.profile.Profile;

class ExecCodegen
extends BaseCodegen {
    private JSClassType.Factory m_typeFactory;
    private boolean m_sapMode;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$sql$sqlj$codegen$ExecCodegen == null ? (class$com$sap$sql$sqlj$codegen$ExecCodegen = ExecCodegen.class$("com.sap.sql.sqlj.codegen.ExecCodegen")) : class$com$sap$sql$sqlj$codegen$ExecCodegen));
    private ExecElem m_execElem;
    private static final String TEMP_RESULT_SET = Util.newVarName("rtRs");
    private static final JavaToSQLMap JAVA_TO_SQL = new JavaToSQLMap();
    private static final JSClass[] EMPTY_ARGS = new JSClass[0];
    private Statement m_execGenerator = null;
    static /* synthetic */ Class class$com$sap$sql$sqlj$codegen$ExecCodegen;

    public ExecCodegen(ExecElem elem, JSClassType.Factory typeFactory, boolean sapMode) {
        super(elem);
        this.m_execElem = elem;
        this.m_typeFactory = typeFactory;
        this.m_sapMode = sapMode;
    }

    private void createGenerator() throws CodegenException {
        if (this.m_execGenerator != null) {
            return;
        }
        try {
            switch (this.m_execElem.getSQL().getOperationType()) {
                case 1022: {
                    this.m_execGenerator = this.createFetchStmt();
                    break;
                }
                default: {
                    this.m_execGenerator = this.createExecStmt();
                    break;
                }
            }
        }
        catch (ClassNotFoundException e) {
            LOCATION.catching((Throwable)e);
            this.m_execElem.getErrorLog().addEntry(new JSError("unable to generate exec codegen (ClassNotFound)"));
            throw new CodegenException("ClassNotFoundException: " + e.getMessage());
        }
    }

    private Statement createFetchStmt() throws CodegenException, ClassNotFoundException {
        Enumeration binds = this.m_execElem.getSQL().getBindExprs();
        if (!binds.hasMoreElements()) {
            throw new CodegenException("no cursor to fetch from");
        }
        DirectBindExpr cursorBindExpr = (DirectBindExpr)binds.nextElement();
        if (!binds.hasMoreElements()) {
            throw new CodegenException("no list to fetch into");
        }
        IntoBindExpr intoList = (IntoBindExpr)binds.nextElement();
        if (binds.hasMoreElements()) {
            throw new CodegenException("extra fetch bind vars found");
        }
        TypedExpression cursorExpr = new TypedExpression(cursorBindExpr.getParselet(), this.m_typeFactory);
        if (!FetchIntoStmt.isFetchExpression(cursorExpr)) {
            throw new CodegenException("cannot fetch from non-cursor");
        }
        FetchIntoStmt fetch = new FetchIntoStmt(cursorExpr);
        IntoGroup intoGroup = fetch.getIntoGroup();
        this.populateIntoGroup(intoGroup, intoList);
        return fetch;
    }

    private Statement createExecStmt() throws ClassNotFoundException, CodegenException {
        Parselet unitParselet = this.m_execElem.getScope().getDefiningUnit();
        UnitDescriptor unitDesc = (UnitDescriptor)unitParselet.getDescriptor();
        TypedExpression connCtxExpr = this.getConnCtxExpr(this.m_execElem);
        TypedExpression execCtxExpr = this.getExecCtxExpr(this.m_execElem);
        HelperClassDecl keys = this.getProfileKeys(unitParselet, unitDesc, this.m_execElem);
        ProfileDecl profile = this.m_sapMode ? null : this.getProfile((ProfileKeysDecl)keys, connCtxExpr.getType(), unitDesc);
        return this.getExecStmt(keys, profile, connCtxExpr, execCtxExpr, this.m_execElem);
    }

    private Parselet getContextExpr(ExecElem elem, JSClass contextType) throws ClassNotFoundException {
        Enumeration exprs = elem.getContextExprList();
        while (exprs.hasMoreElements()) {
            Parselet expr = (Parselet)exprs.nextElement();
            JSClass exprCls = ((ExpressionDescriptor)expr.getDescriptor()).getReflection();
            if (!contextType.isAssignableFrom(exprCls)) continue;
            return expr;
        }
        return null;
    }

    private TypedExpression getConnCtxExpr(ExecElem elem) throws ClassNotFoundException {
        Parselet context = this.getContextExpr(elem, JSClass.ConnectionContext_TYPE);
        if (context == null) {
            JSClassType defaultContext = this.m_typeFactory.getType(UnitInfo.getInfoFor(elem).getDefaultContext());
            context = new ContextParselet(defaultContext);
        }
        return new TypedExpression(context, this.m_typeFactory);
    }

    private TypedExpression getExecCtxExpr(ExecElem elem) throws ClassNotFoundException {
        Parselet context = this.getContextExpr(elem, JSClass.ExecutionContext_TYPE);
        if (context == null) {
            return null;
        }
        return new TypedExpression(context, this.m_typeFactory);
    }

    private HelperClassDecl getProfileKeys(Parselet unitParselet, UnitDescriptor unitDesc, ExecElem execElem) throws CodegenException {
        Enumeration enumeration = unitDesc.getClassDecls();
        while (enumeration.hasMoreElements()) {
            Streamable obj;
            Object parselet = enumeration.nextElement();
            if (!(parselet instanceof CodegenParselet) || !((obj = ((CodegenParselet)parselet).getStreamableObject()) instanceof HelperClassDecl)) continue;
            return (HelperClassDecl)obj;
        }
        String baseName = unitDesc.getFileName();
        if (baseName == null) {
            baseName = unitDesc.getUnitName();
        } else if (!this.isValidJavaIdentifier(baseName)) {
            throw new CodegenException(CodegenErrors.bad_filename(baseName));
        }
        if (baseName == null) {
            throw new Error("bad unit descriptor - null file and unit name");
        }
        HelperClassDecl decl = this.m_sapMode ? new StatementsDecl(Util.getClassPrefix(unitParselet).toString(), baseName, unitParselet, execElem.getErrorLog().getFileName()) : new ProfileKeysDecl(Util.getClassPrefix(unitParselet).toString(), baseName, unitParselet, execElem.getErrorLog().getFileName());
        unitDesc.addClassDecl(new CodegenParselet(decl));
        return decl;
    }

    private boolean isValidJavaIdentifier(String name) {
        int len = name.length();
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < len) {
            if (!Character.isJavaIdentifierPart(name.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private ProfileDecl getProfile(ProfileKeysDecl keys, JSClassType contextType, UnitDescriptor unit) {
        boolean wasNew = !keys.hasProfile(contextType);
        ProfileDecl decl = keys.getProfileDecl(contextType);
        if (wasNew) {
            unit.addClassDecl(new ProfileParselet(decl, this.m_sapMode));
        }
        return decl;
    }

    private Statement getExecStmt(ClassDecl keys, ProfileDecl profile, TypedExpression connCtxExpr, TypedExpression execCtxExpr, ExecElem elem) throws CodegenException, ClassNotFoundException {
        StatementGroup result;
        int execType;
        SQLUnit sqlUnit = elem.getSQL();
        String sqlString = sqlUnit.getSQL();
        int role = this.mapRole(sqlUnit.getOperationType());
        int stmtType = this.calcStatementType(role, sqlUnit);
        ReturnBindExpr returns = sqlUnit.getReturnBindExpr();
        int resultType = 128;
        Parselet resultParselet = elem.getResultExpr();
        TypedExpression resultExpr = resultParselet == null ? null : new TypedExpression(resultParselet, this.m_typeFactory);
        JSClassType resultSetClass = null;
        if (role == 8) {
            execType = 16;
            if (resultExpr != null) {
                throw new CodegenException("cursor lval found select into");
            }
            resultExpr = new TypedExpression(JSClassType.RTResultSet_TYPE, new ObjectExpression(TEMP_RESULT_SET), TEMP_RESULT_SET);
            resultType = 64;
        } else if (role == 4) {
            execType = 24;
        } else if (returns == null || returns == ReturnBindExpr.COLUMN_RETURN) {
            execType = 8;
        } else {
            execType = 16;
            if (resultExpr == null) {
                throw new CodegenException("null cursor lval found in exec");
            }
            JSClass cursorClass = resultExpr.getJSClass();
            resultSetClass = resultExpr.getType();
            if (JSClass.PositionedIterator_TYPE.isAssignableFrom(cursorClass)) {
                resultType = 64;
            } else if (JSClass.NamedIterator_TYPE.isAssignableFrom(cursorClass)) {
                resultType = 32;
            } else if (JSClass.ResultSetIterator_TYPE.isAssignableFrom(cursorClass)) {
                resultType = 19;
            } else {
                throw new CodegenException("incompatible lval found in exec");
            }
        }
        int lineNumber = elem.getErrorLog().getDefaultRegion().startLine();
        if (this.m_sapMode) {
            switch (role) {
                case 18: {
                    Enumeration bindExpressions = sqlUnit.getBindExprs();
                    bindExpressions.nextElement();
                    DirectBindExpr param = (DirectBindExpr)bindExpressions.nextElement();
                    TypedExpression source = new TypedExpression(param.getParselet(), this.m_typeFactory);
                    if (bindExpressions.hasMoreElements()) {
                        throw new CodegenException("illegal number of bind values found for CAST statement");
                    }
                    result = new CastStmt(resultExpr, source);
                    break;
                }
                case 11: {
                    result = new CommitStmt(connCtxExpr);
                    break;
                }
                case 12: {
                    result = new RollbackStmt(connCtxExpr);
                    break;
                }
                default: {
                    ExecStmt execStmt;
                    StatementsDecl decl = (StatementsDecl)keys;
                    int textNum = decl.addSqlText(sqlString, lineNumber);
                    Expression profileKey = decl.getSqlStatementExpression(textNum, connCtxExpr);
                    Expression entryKey = null;
                    switch (execType) {
                        case 16: {
                            if (role == 19) {
                                execStmt = new UntypedQueryExecStmt(stmtType, connCtxExpr, execCtxExpr, profileKey, entryKey, resultExpr, sqlUnit.hasDynamivParameters());
                                break;
                            }
                            execStmt = new QueryExecStmt(stmtType, (Expression)connCtxExpr, (Expression)execCtxExpr, profileKey, entryKey, resultExpr, sqlUnit.hasDynamivParameters(), role != 8);
                            break;
                        }
                        case 8: 
                        case 24: {
                            execStmt = new UpdateExecStmt(stmtType, connCtxExpr, execCtxExpr, profileKey, entryKey, execType, sqlUnit.hasDynamivParameters());
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("unknown exec type");
                        }
                    }
                    result = execStmt;
                    IntoGroup intoGroup = null;
                    if (role == 8) {
                        SelectIntoStmt intoStmt = new SelectIntoStmt(execStmt, TEMP_RESULT_SET);
                        intoGroup = intoStmt.getIntoGroup();
                        result = intoStmt;
                    }
                    this.addParamTypes(null, execStmt, sqlUnit, resultExpr, intoGroup);
                    break;
                }
            }
        } else {
            ExecStmt execStmt;
            ProfileDecl.EntryInit profileEntry = profile.newEntry(sqlString, stmtType, execType, role, resultType, this.getEntryDescriptor(role, sqlUnit), lineNumber, resultSetClass);
            Expression profileKey = ((ProfileKeysDecl)keys).getProfileKey(connCtxExpr.getType());
            Expression entryKey = profileEntry.getEntryKey();
            switch (execType) {
                case 16: {
                    execStmt = new QueryExecStmt(stmtType, connCtxExpr, execCtxExpr, profileKey, entryKey, resultExpr);
                    break;
                }
                case 8: 
                case 24: {
                    execStmt = new UpdateExecStmt(stmtType, connCtxExpr, execCtxExpr, profileKey, entryKey, execType);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown exec type");
                }
            }
            result = execStmt;
            IntoGroup intoGroup = null;
            if (role == 8) {
                SelectIntoStmt intoStmt = new SelectIntoStmt(execStmt, TEMP_RESULT_SET);
                intoGroup = intoStmt.getIntoGroup();
                result = intoStmt;
                this.addResultTypes(profileEntry, sqlUnit.getIntoBindExpr());
            } else if (execType == 16) {
                this.addResultTypes(profileEntry, resultExpr, elem);
            }
            this.addParamTypes(profileEntry, execStmt, sqlUnit, resultExpr, intoGroup);
        }
        return result;
    }

    private Statement getCastStmt(ExecElem elem) {
        return new ObjectStatement(";");
    }

    private Object getEntryDescriptor(int role, SQLUnit sqlUnit) {
        return sqlUnit.getDescriptor();
    }

    private int mapRole(int role) {
        return role;
    }

    private int calcStatementType(int role, SQLUnit sqlUnit) {
        Enumeration params = sqlUnit.getBindExprs();
        while (params.hasMoreElements()) {
            int mode;
            BindExpr param = (BindExpr)params.nextElement();
            if (!(param instanceof DirectBindExpr ? (mode = ((DirectBindExpr)param).getModality()) == 4 || mode == 2 : param == ReturnBindExpr.COLUMN_RETURN)) continue;
            return 4;
        }
        return 2;
    }

    private void addParamTypes(ProfileDecl.EntryInit entry, ExecStmt execStmt, SQLUnit sqlUnit, TypedExpression resultExpr, IntoGroup intoGroup) throws CodegenException, ClassNotFoundException {
        Enumeration params = sqlUnit.getBindExprs();
        int paramNum = 1;
        while (params.hasMoreElements()) {
            BindExpr param = (BindExpr)params.nextElement();
            if (param instanceof DirectBindExpr) {
                DirectBindExpr directParam = (DirectBindExpr)param;
                TypedExpression paramExpr = new TypedExpression(directParam.getParselet(), this.m_typeFactory);
                int mode = directParam.getModality();
                this.addParamType(entry, execStmt, paramExpr, mode, sqlUnit.getMarkerPosition(paramNum));
                ++paramNum;
                continue;
            }
            if (param instanceof IntoBindExpr) {
                if (intoGroup == null) {
                    throw new CodegenException("unexpected into found");
                }
                this.populateIntoGroup(intoGroup, (IntoBindExpr)param);
                intoGroup = null;
                continue;
            }
            if (!(param instanceof ReturnBindExpr) || param != ReturnBindExpr.COLUMN_RETURN) continue;
            if (resultExpr == null) {
                throw new CodegenException("no lval found in exec");
            }
            this.addParamType(entry, execStmt, resultExpr, 5, sqlUnit.getMarkerPosition(paramNum));
            ++paramNum;
        }
    }

    private void addResultTypes(ProfileDecl.EntryInit entry, IntoBindExpr intoList) throws ClassNotFoundException {
        Enumeration intoParselets = intoList.getParselets();
        while (intoParselets.hasMoreElements()) {
            TypedExpression resultExpr = new TypedExpression((Parselet)intoParselets.nextElement(), this.m_typeFactory);
            JSClassType type = resultExpr.getType();
            entry.addResult(type, JAVA_TO_SQL.mapType(type.toClass()), resultExpr.getName());
        }
    }

    private void addResultTypes(ProfileDecl.EntryInit entry, TypedExpression cursorExpr, ExecElem elem) throws CodegenException {
        IteratorMetaData iterMD;
        JSClass cursor = cursorExpr.getJSClass();
        try {
            iterMD = new IteratorMetaData(cursor, this.getCaller(elem, cursor));
        }
        catch (IteratorMetaData.Exception e) {
            LOCATION.catching((Throwable)e);
            throw new CodegenException(e.getMessage());
        }
        if (iterMD.isByPosition() || iterMD.isByName()) {
            int numCols = iterMD.getColumnCount();
            int i = 1;
            while (i <= numCols) {
                JSClass columnType = iterMD.getColumnType(i);
                entry.addResult(this.m_typeFactory.getType(columnType), JAVA_TO_SQL.mapType(columnType), iterMD.getColumnName(i));
                ++i;
            }
        }
    }

    private JSClass getCaller(ExecElem elem, JSClass defaultCaller) {
        try {
            Parselet classScope = elem.getScope().getEnclosingClass();
            return ((ClassDescriptor)classScope.getDescriptor()).getReflection();
        }
        catch (ClassNotFoundException e) {
            return defaultCaller;
        }
    }

    private void populateIntoGroup(IntoGroup intoGroup, IntoBindExpr intoList) throws ClassNotFoundException {
        Enumeration intoParselets = intoList.getParselets();
        while (intoParselets.hasMoreElements()) {
            intoGroup.addIntoVar(new TypedExpression((Parselet)intoParselets.nextElement(), this.m_typeFactory));
        }
    }

    private void addParamType(ProfileDecl.EntryInit entry, ExecStmt execStmt, TypedExpression paramExpr, int mode, int markerIndex) {
        execStmt.addParam(paramExpr, mode);
        if (!this.m_sapMode) {
            if (mode == 5) {
                mode = 4;
            }
            JSClassType type = paramExpr.getType();
            entry.addParam(type, JAVA_TO_SQL.mapType(type.toClass()), paramExpr.getName(), mode, markerIndex);
        }
    }

    public void generate(PrintWriter out) throws IOException, CodegenException, ConfigurationException {
        this.createGenerator();
        this.m_execGenerator.stream(out);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ContextParselet
    extends CodegenParselet {
        TypeDescriptor m_desc;

        public ContextParselet(JSClassType contextType) {
            super(new ObjectExpression(contextType.name() + "." + "getDefaultContext" + "()"));
            this.m_desc = new ExpressionDescriptor(ExpressionMetaData.DEFAULT, contextType.toClass().getBaseJSClass());
        }

        public TypeDescriptor getDescriptor() {
            return this.m_desc;
        }
    }

    private static class ProfileParselet
    extends DefaultParselet {
        private ProfileDecl m_profile;
        private boolean m_sapMode;

        public ProfileParselet(ProfileDecl profile, boolean sapMode) {
            this.m_profile = profile;
            this.m_sapMode = sapMode;
        }

        public UnitInfo getUnitInfo() {
            return UnitInfo.getInfoFor(this);
        }

        public boolean generate(OutputContext ctx) throws IOException {
            if (!this.m_sapMode) {
                UnitInfo info = UnitInfo.getInfoFor(this);
                if (info.wasError()) {
                    return false;
                }
                OutputStream os = ctx.createOutputStream(this.m_profile.getName() + ".ser");
                ObjectOutputStream oos = new ObjectOutputStream(os);
                Profile aProfile = this.m_profile.getProfile();
                CommonProfileCustomizer custom = new CommonProfileCustomizer();
                custom.customize(aProfile, null, null);
                oos.writeObject(aProfile);
                oos.flush();
                os.close();
            }
            return true;
        }
    }

    private static class CodegenParselet
    extends DefaultParselet {
        private Streamable m_streamableObj;

        public CodegenParselet(Streamable streamableObj) {
            this.m_streamableObj = streamableObj;
        }

        public Streamable getStreamableObject() {
            return this.m_streamableObj;
        }

        public boolean generate(OutputContext ctx) throws IOException, ConfigurationException {
            return BaseCodegen.generate(ctx.getWriter(), this.m_streamableObj);
        }
    }
}

