/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlj.anttask;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class ClassMapper
extends Task {
    private String includes = null;
    private String clazzFile = null;
    private String javaFile = null;
    private File srcDir = null;
    private File clazzDir = null;

    public void setSrcfile(String aJavaFile) {
        this.javaFile = aJavaFile;
    }

    public void setDestfile(String aClazzFile) {
        this.clazzFile = aClazzFile;
    }

    public void setSrcdir(File aSrcDir) {
        this.srcDir = aSrcDir;
    }

    public void setIncludes(String aIncludes) {
        this.includes = aIncludes;
    }

    public void setDestdir(File aClazzDir) {
        this.clazzDir = aClazzDir;
    }

    public void execute() throws BuildException {
        this.log("Using ClassMapper:\n" + com.sap.sql.sqlj.tools.ClassMapper.getVersion(), 3);
        if (this.clazzFile != null && this.javaFile != null && this.srcDir == null && this.clazzDir == null) {
            this.log("mapping:>" + this.clazzFile + "|" + this.javaFile + "<", 3);
            int rc = com.sap.sql.sqlj.tools.ClassMapper.mainStatus(this.clazzFile, this.javaFile);
            if (rc > 0) {
                throw new BuildException("ClassMapper failed with rc " + rc);
            }
        } else if (this.clazzFile == null && this.javaFile == null && this.srcDir != null && this.clazzDir != null) {
            FileSet fs = new FileSet();
            fs.setDir(this.clazzDir);
            fs.setIncludes(this.includes);
            DirectoryScanner ds = fs.getDirectoryScanner(((ProjectComponent)this).project);
            String[] files = ds.getIncludedFiles();
            if (files.length == 0) {
                throw new BuildException("No class found");
            }
            int mappingCounter = 0;
            int j = 0;
            while (j < files.length) {
                String clazzfileName = files[j];
                String javaFile = this.createJavaFile(clazzfileName);
                String cla = this.clazzDir.getAbsolutePath() + File.separator + files[j];
                String src = this.srcDir + File.separator + javaFile;
                this.log("mapping:>" + cla + "|" + src + "<", 3);
                int rc = com.sap.sql.sqlj.tools.ClassMapper.mainStatus(cla, src);
                if (rc == 0) {
                    ++mappingCounter;
                }
                this.log("ClassMapper returned:" + rc + ":" + com.sap.sql.sqlj.tools.ClassMapper.getLastErrorMsg(), 3);
                ++j;
            }
            this.log("mapped " + mappingCounter + " Class" + (mappingCounter == 1 ? "" : "es"), 2);
        } else {
            throw new BuildException("Please specify classfile and javafile or srcdir and classdir");
        }
    }

    private String createJavaFile(String clazz) {
        int innerStart = clazz.indexOf(36);
        if (innerStart > -1) {
            return clazz.substring(0, innerStart) + ".java";
        }
        return clazz.substring(0, clazz.lastIndexOf(".class")) + ".java";
    }
}

