/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.services;

import com.sap.exception.standard.SAPIllegalArgumentException;
import com.sap.sql.buffer.monitor.BufferMonitor;
import com.sap.sql.buffer.monitor.impl.BufferMonitorImpl;
import com.sap.sql.catalog.CatalogBufferManager;
import com.sap.sql.catalog.CatalogReader;
import com.sap.sql.catalog.impl.CatalogBufferManagerImpl;
import com.sap.sql.catalog.monitor.CatalogBufferMonitor;
import com.sap.sql.jdbc.ConnectionContext;
import com.sap.sql.jdbc.ServiceConnection;
import com.sap.sql.jdbc.basic.BasicDbPortingServices;
import com.sap.sql.jdbc.basic.SQLExceptionAnalyzer;
import com.sap.sql.jdbc.common.CommonConnection;
import com.sap.sql.jdbc.common.CommonConnectionContext;
import com.sap.sql.jdbc.common.CommonConnectionImpl;
import com.sap.sql.jdbc.common.CreateViewStatementAnalyzer;
import com.sap.sql.jdbc.common.CreateViewStatementAnalyzerImpl;
import com.sap.sql.jdbc.common.StatementAnalyzer;
import com.sap.sql.jdbc.common.StatementAnalyzerImpl;
import com.sap.sql.jdbc.monitor.ConnectionMonitor;
import com.sap.sql.jdbc.monitor.impl.ConnectionMonitorImpl;
import com.sap.sql.log.Syslog;
import com.sap.sql.services.DatabaseInformation;
import com.sap.sql.services.OpenSQLServicesSpi;
import com.sap.sql.sqlj.common.runtime.FakeConnectionContext;
import com.sap.sql.sqlj.runtime.profile.ref.RTResultSetJDBC;
import com.sap.sql.sqlparser.SQLKeywords;
import com.sap.sql.sync.SyncManager;
import com.sap.sql.sync.SyncRecordOutputStream;
import com.sap.sql.sync.SyncWriter;
import com.sap.sql.sync.SyncWriterFactory;
import com.sap.sql.tablebuffer.BufferManager;
import com.sap.sql.tablebuffer.BufferManagerFactory;
import com.sap.sql.tree.SQLStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class OpenSQLServicesImpl
implements OpenSQLServicesSpi {
    public Timestamp getUTCTimestamp(ConnectionContext context) throws SQLException {
        if (context.isCommonSQL()) {
            ((CommonConnectionImpl)context.getConnection()).setActiveTransactionStateMax();
        }
        return context.getDbPortingServices().getUTCTimestamp();
    }

    public String getConnectionID(ConnectionContext context) throws SQLException {
        return context.getConnectionID();
    }

    public void invalidateTable(ConnectionContext context, String tableName) throws SQLException {
        if (tableName == null) {
            throw new SAPIllegalArgumentException("com.sap.exception.standard_0001", new Object[]{"tableName"});
        }
        SyncRecordOutputStream catalogSyncRec = CatalogBufferManagerImpl.removeTable(context.getConnectionID(), tableName);
        if (context.isCommonSQL()) {
            CommonConnectionContext ctx = (CommonConnectionContext)context;
            SyncRecordOutputStream bufferSyncRec = ctx.getBufferManager().removeTable(tableName);
            SyncWriter syncWriter = ctx.getSyncWriter();
            if (syncWriter != null) {
                ((CommonConnectionImpl)ctx.getConnection()).setActiveTransactionStateMax();
                syncWriter.syncRequest(ctx.getCatalogSyncID(), catalogSyncRec);
                syncWriter.syncRequest(ctx.getBufferSyncID(), bufferSyncRec);
                syncWriter.flushRequests();
            }
        } else {
            String connectionID = context.getConnectionID();
            SyncRecordOutputStream bufferSyncRec = BufferManager.removeTable(connectionID, tableName);
            SyncWriter syncWriter = SyncWriterFactory.createSyncWriter(context);
            if (syncWriter != null) {
                String catalogSyncID = CatalogBufferManagerImpl.getCatalogSyncID(connectionID);
                String bufferSyncID = BufferManagerFactory.getBufferSyncID(connectionID);
                SyncManager.getInstance().registerSender(catalogSyncID);
                SyncManager.getInstance().registerSender(bufferSyncID);
                syncWriter.syncRequest(catalogSyncID, catalogSyncRec);
                syncWriter.syncRequest(bufferSyncID, bufferSyncRec);
                syncWriter.flushRequests();
            }
        }
    }

    public void resetCatalogBuffer(ConnectionContext context) {
        CatalogBufferManager.resetBuffer(context.getConnectionID());
    }

    public boolean isSQLKeyword(String key) {
        return SQLKeywords.isKeyword(key);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DatabaseInformation getDatabaseInformation(String dataSourceName) {
        block13: {
            block12: {
                conn = null;
                try {
                    try {
                        ctx = new InitialContext();
                        ds = (DataSource)ctx.lookup("jdbc/" + dataSourceName);
                        conn = ds.getConnection();
                        if (!(conn instanceof ServiceConnection)) {
                            var5_8 = null;
                            var8_11 = null;
                            if (conn == null) return var5_8;
                            break block12;
                        }
                        context = (ConnectionContext)((ServiceConnection)conn).getServiceContext();
                        var6_21 = this.getDatabaseInformation(context);
                        break block13;
                    }
                    catch (SQLException sqlEx) {
                        Syslog.logSQLException(this, sqlEx);
                        ds = null;
                        var8_13 = null;
                        if (conn == null) return ds;
                        try {
                            conn.close();
                            return ds;
                        }
                        catch (SQLException sqlEx) {
                            Syslog.logSQLException(this, sqlEx);
                        }
                        return ds;
                    }
                    catch (NamingException namingEx) {
                        Syslog.logThrowable(this, (Throwable)namingEx);
                        var5_10 = null;
                        var8_14 = null;
                        if (conn == null) return var5_10;
                        ** try [egrp 2[TRYBLOCK] [3 : 139->148)] { 
lbl38:
                        // 1 sources

                        conn.close();
                        return var5_10;
lbl40:
                        // 1 sources

                        catch (SQLException sqlEx) {
                            Syslog.logSQLException(this, sqlEx);
                        }
                        return var5_10;
                    }
                }
                catch (Throwable var7_22) {
                    var8_15 = null;
                    if (conn == null) throw var7_22;
                    try {}
                    catch (SQLException sqlEx) {
                        Syslog.logSQLException(this, sqlEx);
                        throw var7_22;
                    }
                    conn.close();
                    throw var7_22;
                }
            }
            ** try [egrp 2[TRYBLOCK] [3 : 139->148)] { 
lbl57:
            // 1 sources

            conn.close();
            return var5_8;
lbl59:
            // 1 sources

            catch (SQLException sqlEx) {
                Syslog.logSQLException(this, sqlEx);
            }
            return var5_8;
        }
        var8_12 = null;
        if (conn == null) return var6_21;
        ** try [egrp 2[TRYBLOCK] [3 : 139->148)] { 
lbl67:
        // 1 sources

        conn.close();
        return var6_21;
lbl69:
        // 1 sources

        catch (SQLException sqlEx) {
            Syslog.logSQLException(this, sqlEx);
        }
        return var6_21;
    }

    public DatabaseInformation getDatabaseInformation(ConnectionContext context) {
        String productName = null;
        String productVersion = null;
        String userName = null;
        String schemaName = null;
        String dbName = null;
        String dbHost = null;
        int vendorID = -1;
        Boolean is64Bit = null;
        if (context.isCommonSQL()) {
            ((CommonConnectionImpl)context.getConnection()).setActiveTransactionStateMax();
        }
        BasicDbPortingServices port = context.getDbPortingServices();
        try {
            productName = port.getDatabaseProductName();
        }
        catch (SQLException ex) {
            Syslog.logSQLException(this, ex);
        }
        try {
            productVersion = port.getDatabaseProductVersion();
        }
        catch (SQLException ex) {
            Syslog.logSQLException(this, ex);
        }
        try {
            userName = port.getUserName();
        }
        catch (SQLException ex) {
            Syslog.logSQLException(this, ex);
        }
        try {
            schemaName = port.getSchemaName();
        }
        catch (SQLException ex) {
            Syslog.logSQLException(this, ex);
        }
        try {
            dbName = port.getDatabaseName();
        }
        catch (SQLException ex) {
            Syslog.logSQLException(this, ex);
        }
        try {
            dbHost = port.getDatabaseHost();
        }
        catch (SQLException ex) {
            Syslog.logSQLException(this, ex);
        }
        vendorID = port.getVendorID();
        try {
            is64Bit = port.isDatabaseKernel64Bit();
        }
        catch (SQLException ex) {
            Syslog.logSQLException(this, ex);
        }
        return new DatabaseInformation(productName, productVersion, userName, schemaName, dbName, dbHost, vendorID, is64Bit);
    }

    public BufferMonitor getBufferMonitor() {
        return BufferMonitorImpl.getInstance();
    }

    public CatalogBufferMonitor getCatalogBufferMonitor() {
        return CatalogBufferManager.getCatalogBufferMonitor();
    }

    public ConnectionMonitor getConnectionMonitor() {
        return ConnectionMonitorImpl.getInstance();
    }

    public Object getSqljConnectionContext(ConnectionContext context, SQLStatement stmt) {
        return new FakeConnectionContext((CommonConnection)context.getConnection(), (Object)stmt);
    }

    public void trySettingExecutionContextViaBatch(Object context) {
        if (context instanceof FakeConnectionContext) {
            ((FakeConnectionContext)context).setExecuteViaBatch(true);
        }
    }

    public CreateViewStatementAnalyzer getCreateViewStatementAnalyzer(ConnectionContext context) {
        return new CreateViewStatementAnalyzerImpl(((CommonConnectionContext)context).getCatalogReader());
    }

    public CreateViewStatementAnalyzer getCreateViewStatementAnalyzer(CatalogReader reader) {
        return new CreateViewStatementAnalyzerImpl(reader);
    }

    public StatementAnalyzer createStatementAnalyzer() {
        return new StatementAnalyzerImpl();
    }

    public StatementAnalyzer getStatementAnalyzer(ConnectionContext ctx) {
        return ((CommonConnectionContext)ctx).getStatementAnalyzer();
    }

    public CatalogReader getCatalogReader(ConnectionContext ctx) {
        return ((CommonConnectionContext)ctx).getCatalogReader();
    }

    public Object getRTResultSet(ResultSet resultSet) {
        if (resultSet == null) {
            return null;
        }
        return new RTResultSetJDBC(resultSet);
    }

    public boolean isTransientSQLError(ConnectionContext context, SQLException exception) {
        SQLExceptionAnalyzer analyzer = context.getSQLExceptionAnalyzer();
        return 6 == analyzer.getCategory(exception);
    }
}

