/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.nametab;

import com.sap.sql.log.ExceptionType;
import com.sap.sql.nametab.NametabException;

public class NametabTypeMap {
    private NametabTypeMap() {
    }

    public static int getJdbcType(int aDDICType) throws NametabException {
        switch (aDDICType) {
            case 40: 
            case 64: 
            case 68: 
            case 80: 
            case 148: 
            case 152: 
            case 156: 
            case 176: 
            case 188: 
            case 236: {
                return 12;
            }
            case 20: 
            case 72: 
            case 160: {
                return 3;
            }
            case 136: {
                return 8;
            }
            case 164: {
                return -6;
            }
            case 168: 
            case 180: {
                return 5;
            }
            case 172: {
                return 4;
            }
            case 196: {
                return -1;
            }
            case 200: {
                return -4;
            }
            case 184: {
                return -3;
            }
            case 232: {
                return 2004;
            }
            case 228: {
                return 2005;
            }
        }
        throw new NametabException("NametabTypeMap", "getJdbcType", ExceptionType.ILLEGAL_INPUT, "DDIC type: " + aDDICType);
    }

    public static String getDDICTypeName(int aDDICType) throws NametabException {
        switch (aDDICType) {
            case 148: {
                return "ACCP";
            }
            case 40: {
                return "CHAR";
            }
            case 152: {
                return "CLNT";
            }
            case 64: {
                return "CUKY";
            }
            case 20: {
                return "CURR";
            }
            case 156: {
                return "DATS";
            }
            case 160: {
                return "DEC";
            }
            case 136: {
                return "FLTP";
            }
            case 164: {
                return "INT1";
            }
            case 168: {
                return "INT2";
            }
            case 172: {
                return "INT4";
            }
            case 80: {
                return "LANG";
            }
            case 196: {
                return "LCHR";
            }
            case 200: {
                return "LRAW";
            }
            case 176: {
                return "NUMC";
            }
            case 180: {
                return "PREC";
            }
            case 72: {
                return "QUAN";
            }
            case 184: {
                return "RAW";
            }
            case 232: {
                return "RAWSTRING";
            }
            case 228: {
                return "STRING";
            }
            case 236: {
                return "SSTRING";
            }
            case 188: {
                return "TIMS";
            }
            case 68: {
                return "UNIT";
            }
        }
        throw new NametabException("NametabTypeMap", "getDDICTypeName", ExceptionType.ILLEGAL_INPUT, "DDIC type: " + aDDICType);
    }
}

