/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.nametab;

import com.sap.sql.catalog.Column;
import com.sap.sql.catalog.ColumnIterator;
import com.sap.sql.catalog.Table;
import com.sap.sql.log.ExceptionType;
import com.sap.sql.nametab.NametabColumn;
import com.sap.sql.nametab.NametabColumnIterator;
import com.sap.sql.nametab.NametabException;
import com.sap.sql.nametab.NametabNotFound;
import com.sap.sql.nametab.NametabTypeMap;
import com.sap.sql.types.CommonTypes;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;

public class NametabTable
implements Table {
    public static final int NOT_BUFFERED = 0;
    public static final int PARTIALLY_BUFFERED = 1;
    public static final int GENERICALLY_BUFFERED = 2;
    public static final int TOTALLY_BUFFERED = 3;
    private int FDESCR_OFFS = 6;
    private int FDESCR1_LEN = 146;
    private int FLAG1_OFFS = 0;
    private int DISPLACEMENT_OFFS = 6;
    private int FIELD_TYPE_OFFS = 10;
    private int DBLENGTH_OFFS = 13;
    private int DECIMALS_OFFS = 19;
    private int FIELD_NAME_OFFS = 22;
    private int FIELD_NAME_LEN = 30;
    private String tableName = null;
    private String schemaName = null;
    private int columnCnt = 0;
    private int primaryKeyCnt = 0;
    private int tableType = 1;
    private int bufferType = 0;
    private int bufferKeyCnt = -1;
    private boolean clientDependent;
    private int clientPosition;
    private HashMap fieldNameIndex = new HashMap(256);
    private HashMap primaryKeyIndex = new HashMap(20);
    ArrayList columns = new ArrayList();
    private int version;
    private String cp = "UTF-16BE";
    private int unicodeLg = 2;
    private boolean skipTwoBytes = false;
    private boolean isInformix = false;
    private DatabaseMetaData md;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$sql$Clob;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$sql$Blob;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;

    NametabTable(String tableName, String schemaName, PreparedStatement selectNametabStmt, int version, String cp, int unicodeLg, boolean skipTwoBytes, boolean fieldsAsBlob, DatabaseMetaData md) throws NametabException {
        this.version = version;
        this.cp = cp;
        this.unicodeLg = unicodeLg;
        this.skipTwoBytes = skipTwoBytes;
        this.isInformix = fieldsAsBlob;
        this.md = md;
        this.initNametabTable();
        try {
            selectNametabStmt.setString(1, tableName);
            ResultSet rs = selectNametabStmt.executeQuery();
            if (rs.next()) {
                this.tableName = tableName;
                this.schemaName = schemaName;
                this.columnCnt = rs.getShort(1);
                this.primaryKeyCnt = rs.getShort(2);
                this.tableType = this.determineTableType(rs.getString(3));
                this.clientDependent = this.isInformix ? (byte)(rs.getString(4).charAt(0) & 2) != 0 : (rs.getBytes(4)[0] & 2) != 0;
                this.bufferType = this.determineBufferType(rs.getString(5));
                switch (this.bufferType) {
                    case 0: {
                        this.bufferKeyCnt = -1;
                        break;
                    }
                    case 1: {
                        this.bufferKeyCnt = this.primaryKeyCnt;
                        break;
                    }
                    case 2: {
                        short bufparm = rs.getShort(6);
                        this.bufferKeyCnt = bufparm >> 8;
                        break;
                    }
                    case 3: {
                        this.bufferKeyCnt = 0;
                        break;
                    }
                    default: {
                        this.bufferKeyCnt = -1;
                    }
                }
                this.clientPosition = this.clientDependent ? rs.getInt(7) : 0;
                byte[] fields = null;
                int fieldslg = 0;
                fieldslg = rs.getInt(9);
                if (this.isInformix) {
                    Blob fieldsBlob = rs.getBlob(10);
                    fields = fieldsBlob.getBytes(1L, fieldslg);
                } else {
                    fields = rs.getBytes(10);
                }
                HashMap defaultStringMap = this.createDefaultMap();
                int keyPos = 0;
                int skip = this.FDESCR_OFFS;
                int j = 0;
                int blockCount = 1;
                int i = 0;
                while (i < this.columnCnt) {
                    boolean pKey;
                    byte[] fdescrArray = new byte[this.FDESCR1_LEN];
                    int fdescrOffs = skip + j * this.FDESCR1_LEN;
                    if (fdescrOffs - (skipTwoBytes ? 2 : 0) + this.FDESCR1_LEN > fieldslg) {
                        int restlen = fieldslg - (fdescrOffs - (skipTwoBytes ? 2 : 0));
                        System.arraycopy(fields, fdescrOffs, fdescrArray, 0, restlen);
                        if (!rs.next()) {
                            throw new NametabException("NametabTable", "NametabTable", ExceptionType.INTERNAL_ERROR, "Missing fields block in DDNTF for table '" + this.tableName + "' (block count = " + blockCount + ").");
                        }
                        fieldslg = rs.getInt(9);
                        if (this.isInformix) {
                            Blob fieldsBlob = rs.getBlob(10);
                            fields = fieldsBlob.getBytes(1L, fieldslg);
                        } else {
                            fields = rs.getBytes(10);
                        }
                        ++blockCount;
                        skip = this.FDESCR1_LEN - restlen;
                        j = -1;
                        System.arraycopy(fields, skipTwoBytes ? 2 : 0, fdescrArray, restlen, skip);
                        skip += skipTwoBytes ? 2 : 0;
                    } else {
                        System.arraycopy(fields, fdescrOffs, fdescrArray, 0, this.FDESCR1_LEN);
                    }
                    String fieldName = this.readFieldName(fdescrArray, this.FIELD_NAME_OFFS);
                    boolean bl = pKey = (fdescrArray[this.FLAG1_OFFS] & 1) != 0;
                    if (pKey) {
                        this.primaryKeyIndex.put(new Integer(++keyPos), new Integer(i));
                    }
                    this.fieldNameIndex.put(fieldName, new Integer(i));
                    int displacement = version == 2 ? this.readInt4(fdescrArray, this.DISPLACEMENT_OFFS) : this.readInt2(fdescrArray, this.DISPLACEMENT_OFFS);
                    int fieldType = this.readInt1(fdescrArray, this.FIELD_TYPE_OFFS);
                    int jdbcType = NametabTypeMap.getJdbcType(fieldType);
                    String typeName = NametabTypeMap.getDDICTypeName(fieldType);
                    int dblength = version == 2 ? this.readInt4(fdescrArray, this.DBLENGTH_OFFS) : this.readInt2(fdescrArray, this.DBLENGTH_OFFS);
                    int size = jdbcType == 12 || jdbcType == -1 || jdbcType == 2005 ? dblength / unicodeLg : dblength;
                    int decimals = this.readInt1(fdescrArray, this.DECIMALS_OFFS);
                    boolean nullable = (fdescrArray[this.FLAG1_OFFS] & 0x40) == 0;
                    String defaultStr = (String)defaultStringMap.get(fieldName);
                    Object defaultObj = defaultStr != null ? this.createDefaultObj(jdbcType, defaultStr) : null;
                    NametabColumn col = new NametabColumn(this, fieldName, i + 1, pKey, pKey ? keyPos : 0, jdbcType, typeName, size, decimals, nullable, defaultObj, displacement);
                    this.columns.add(col);
                    ++j;
                    ++i;
                }
            } else {
                throw new NametabNotFound("NametabTable", "NametabTable", ExceptionType.OBJECT_NOT_FOUND, "Table or view '" + tableName + "' not in nametab.");
            }
            rs.close();
        }
        catch (SQLException e) {
            if (e instanceof NametabNotFound) {
                throw (NametabException)e;
            }
            throw new NametabException("NametabTable", "NametabTable", ExceptionType.INTERNAL_ERROR, "Unexpected SQL error occured during access of DDNTT/DDNTF for '" + tableName + "': " + e.getMessage());
        }
    }

    static boolean existsNametab(String tableName, PreparedStatement existsNametabStmt) throws NametabException {
        try {
            boolean rc = false;
            existsNametabStmt.setString(1, tableName);
            ResultSet rs = existsNametabStmt.executeQuery();
            rc = rs.next();
            rs.close();
            return rc;
        }
        catch (SQLException e) {
            throw new NametabException("NametabTable", "existsTable", ExceptionType.INTERNAL_ERROR, "Unexpected SQL error occured during access of DDNTT for table '" + tableName + "': " + e.getMessage());
        }
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getName() {
        return this.tableName;
    }

    public int getColumnCnt() {
        return this.columnCnt;
    }

    public int getPrimaryKeyCnt() {
        return this.primaryKeyCnt;
    }

    public int getBufferKeyCnt() {
        return this.bufferKeyCnt;
    }

    public Column getColumn(String columnName) {
        Integer posInteger = (Integer)this.fieldNameIndex.get(columnName);
        if (posInteger != null) {
            return (Column)this.columns.get(posInteger);
        }
        return null;
    }

    public Column getColumn(int position) {
        if (position <= 0 || position > this.columnCnt) {
            return null;
        }
        return (Column)this.columns.get(position - 1);
    }

    public Column getPrimaryKeyColumn(int position) {
        if (position <= 0 || position > this.primaryKeyCnt) {
            return null;
        }
        Integer posInteger = (Integer)this.primaryKeyIndex.get(new Integer(position));
        if (posInteger != null) {
            return (Column)this.columns.get(posInteger);
        }
        return null;
    }

    public ColumnIterator getColumns() {
        return new NametabColumnIterator(this);
    }

    public int getTableType() {
        return this.tableType;
    }

    public boolean isBuffered() {
        return this.bufferType != 0;
    }

    public boolean isClientDependent() {
        return this.clientDependent;
    }

    public Column getClientColumn() {
        return this.getColumn(this.clientPosition);
    }

    private void initNametabTable() {
        if (this.unicodeLg == 2) {
            this.FDESCR_OFFS = this.skipTwoBytes ? 8 : 6;
        } else {
            switch (this.version) {
                case 2: {
                    this.FDESCR1_LEN = 84;
                    this.FDESCR_OFFS = this.skipTwoBytes ? 6 : 4;
                    break;
                }
                case 1: {
                    this.FDESCR1_LEN = 78;
                    this.FDESCR_OFFS = this.skipTwoBytes ? 6 : 4;
                    this.FLAG1_OFFS = 0;
                    this.DISPLACEMENT_OFFS = 6;
                    this.FIELD_TYPE_OFFS = 8;
                    this.DBLENGTH_OFFS = 9;
                    this.DECIMALS_OFFS = 13;
                    this.FIELD_NAME_OFFS = 16;
                    this.FIELD_NAME_LEN = 30;
                    break;
                }
                case 0: {
                    this.FDESCR1_LEN = 21;
                    this.FDESCR_OFFS = this.skipTwoBytes ? 4 : 2;
                    this.FLAG1_OFFS = 0;
                    this.DISPLACEMENT_OFFS = 2;
                    this.FIELD_TYPE_OFFS = 4;
                    this.DBLENGTH_OFFS = 5;
                    this.DECIMALS_OFFS = 9;
                    this.FIELD_NAME_OFFS = 10;
                    this.FIELD_NAME_LEN = 10;
                }
            }
        }
    }

    private int determineBufferType(String bufstate) {
        if (bufstate.length() == 0) {
            return 0;
        }
        switch (bufstate.charAt(0)) {
            case ' ': {
                return 0;
            }
            case 'P': {
                return 1;
            }
            case 'G': {
                return 2;
            }
            case 'R': {
                return 3;
            }
        }
        return 0;
    }

    private int determineTableType(String tableType) {
        switch (tableType.charAt(0)) {
            case 'T': {
                return 1;
            }
            case 'J': {
                return 2;
            }
        }
        return 1;
    }

    private String readFieldName(byte[] b, int offs) throws NametabException {
        String fNameStr;
        int len = 0;
        while (b[offs + len] != 0 || this.unicodeLg == 2 && b[offs + len + 1] != 0) {
            len += this.unicodeLg;
        }
        try {
            fNameStr = this.readString(b, offs, len, this.cp);
        }
        catch (UnsupportedEncodingException e) {
            throw new NametabException("NametabTable", "readFileName", ExceptionType.INTERNAL_ERROR, "UnsupportedEncodingException: " + e.getMessage());
        }
        return fNameStr;
    }

    private int readInt4(byte[] b, int offs) {
        return (b[offs + 0] & 0xFF) << 24 | (b[offs + 1] & 0xFF) << 16 | (b[offs + 2] & 0xFF) << 8 | b[offs + 3] & 0xFF;
    }

    private int readInt2(byte[] b, int offs) {
        return (b[offs + 0] & 0xFF) << 8 | b[offs + 1] & 0xFF;
    }

    private int readInt1(byte[] b, int offs) {
        return b[offs] & 0xFF;
    }

    private String readString(byte[] b, int offs, int len, String cp) throws UnsupportedEncodingException {
        return new String(b, offs, len, cp);
    }

    private HashMap createDefaultMap() throws SQLException {
        HashMap<String, String> map = new HashMap<String, String>(256);
        ResultSet rs = this.md.getColumns(null, this.schemaName, this.tableName, null);
        while (rs.next()) {
            map.put(rs.getString("COLUMN_NAME"), rs.getString("COLUMN_DEF"));
        }
        return map;
    }

    private Object createDefaultObj(int jdbcType, String defaultStr) {
        Object defaultObj = null;
        Class defaultClass = CommonTypes.defaultMapping(jdbcType);
        if (defaultClass == (class$java$lang$String == null ? (class$java$lang$String = NametabTable.class$("java.lang.String")) : class$java$lang$String) || defaultClass == (class$java$sql$Clob == null ? (class$java$sql$Clob = NametabTable.class$("java.sql.Clob")) : class$java$sql$Clob)) {
            defaultObj = new String(defaultStr);
        } else if (defaultClass == (array$B == null ? (array$B = NametabTable.class$("[B")) : array$B) || defaultClass == (class$java$sql$Blob == null ? (class$java$sql$Blob = NametabTable.class$("java.sql.Blob")) : class$java$sql$Blob)) {
            ByteArrayOutputStream bStream = new ByteArrayOutputStream();
            String byteStr = defaultStr.toUpperCase();
            if (byteStr.charAt(0) == '\'' || byteStr.charAt(0) == '\"') {
                byteStr = byteStr.substring(1, byteStr.length() - 1);
            }
            int k = 0;
            while (k <= byteStr.length() / 2) {
                String subStr = byteStr.substring(k, k + 2);
                int sum = 0;
                int k2 = 1;
                while (k2 >= 0) {
                    int h = 0;
                    switch (subStr.charAt(-1 * (k2 - 1))) {
                        case '0': {
                            h = 0;
                            break;
                        }
                        case '1': {
                            h = 1;
                            break;
                        }
                        case '2': {
                            h = 2;
                            break;
                        }
                        case '3': {
                            h = 3;
                            break;
                        }
                        case '4': {
                            h = 4;
                            break;
                        }
                        case '5': {
                            h = 5;
                            break;
                        }
                        case '6': {
                            h = 6;
                            break;
                        }
                        case '7': {
                            h = 7;
                            break;
                        }
                        case '8': {
                            h = 8;
                            break;
                        }
                        case '9': {
                            h = 9;
                            break;
                        }
                        case 'A': {
                            h = 10;
                            break;
                        }
                        case 'B': {
                            h = 11;
                            break;
                        }
                        case 'C': {
                            h = 12;
                            break;
                        }
                        case 'D': {
                            h = 13;
                            break;
                        }
                        case 'E': {
                            h = 14;
                            break;
                        }
                        case 'F': {
                            h = 15;
                        }
                    }
                    sum = (byte)(sum + (16 * k2 * h + h * -1 * (k2 - 1)));
                    --k2;
                }
                bStream.write(sum);
                k += 2;
            }
            defaultObj = bStream.toByteArray();
        } else if (defaultClass == Short.TYPE) {
            int k = 0;
            while (k < defaultStr.length() && defaultStr.charAt(k) == ' ') {
                ++k;
            }
            String helpStr = defaultStr.substring(k, defaultStr.length());
            defaultObj = helpStr.indexOf(32) > 0 ? new Short(helpStr.substring(0, helpStr.indexOf(32))) : new Short(helpStr);
        } else if (defaultClass == Integer.TYPE) {
            int k = 0;
            while (k < defaultStr.length() && defaultStr.charAt(k) == ' ') {
                ++k;
            }
            String helpStr = defaultStr.substring(k, defaultStr.length());
            defaultObj = helpStr.indexOf(32) > 0 ? new Integer(helpStr.substring(0, helpStr.indexOf(32))) : new Integer(helpStr);
        } else if (defaultClass == Long.TYPE) {
            defaultObj = new Long(defaultStr);
        } else if (defaultClass == Float.TYPE) {
            defaultObj = new Float(defaultStr);
        } else if (defaultClass == Double.TYPE) {
            defaultObj = new Double(defaultStr);
        } else if (defaultClass == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = NametabTable.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
            int k = 0;
            while (k < defaultStr.length() && defaultStr.charAt(k) == ' ') {
                ++k;
            }
            String helpStr = defaultStr.substring(k, defaultStr.length());
            defaultObj = helpStr.indexOf(32) > 0 ? new BigDecimal(helpStr.substring(0, helpStr.indexOf(32))) : new BigDecimal(helpStr);
        } else if (defaultClass == (class$java$sql$Date == null ? (class$java$sql$Date = NametabTable.class$("java.sql.Date")) : class$java$sql$Date)) {
            defaultObj = Date.valueOf(defaultStr);
        } else if (defaultClass == (class$java$sql$Time == null ? (class$java$sql$Time = NametabTable.class$("java.sql.Time")) : class$java$sql$Time)) {
            defaultObj = Time.valueOf(defaultStr);
        } else if (defaultClass == (class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = NametabTable.class$("java.sql.Timestamp")) : class$java$sql$Timestamp)) {
            defaultObj = Timestamp.valueOf(defaultStr);
        } else if (defaultClass == Boolean.TYPE) {
            defaultObj = new Boolean(defaultStr);
        }
        return defaultObj;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

