/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.log;

import com.sap.exception.IBaseException;
import com.sap.localization.LocalizableTextFormatter;
import com.sap.localization.LocalizationException;
import com.sap.sql.log.OpenSQLException;
import com.sap.sql.log.OpenSQLResourceAccessor;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;

public class Syslog {
    private static final Location TRACE = Location.getLocation((Class)(class$com$sap$sql$log$Syslog == null ? (class$com$sap$sql$log$Syslog = Syslog.class$("com.sap.sql.log.Syslog")) : class$com$sap$sql$log$Syslog));
    private static final String OPEN_SQL_LOG_PREFIX = "/System/Database/";
    private static final String SAP_PACKAGE_PREFIX = "com.sap.";
    private static final int MAX_MESSAGE_SIZE = 100000;
    static /* synthetic */ Class class$com$sap$sql$log$Syslog;

    private Syslog() {
    }

    public static OpenSQLException createAndLogOpenSQLException(Class c, String msgKey, Object[] msgArgs) {
        return Syslog.logOpenSQLException(new OpenSQLException(c, msgKey, msgArgs));
    }

    public static OpenSQLException createAndLogOpenSQLException(Class c, String msgKey, Object[] msgArgs, Throwable cause) {
        return Syslog.logOpenSQLException(new OpenSQLException(c, msgKey, msgArgs, cause));
    }

    public static OpenSQLException createAndLogOpenSQLException(Object o, String msgKey, Object[] msgArgs) {
        return Syslog.createAndLogOpenSQLException(o.getClass(), msgKey, msgArgs);
    }

    public static OpenSQLException createAndLogOpenSQLException(Object o, String msgKey, Object[] msgArgs, Throwable cause) {
        return Syslog.createAndLogOpenSQLException(o.getClass(), msgKey, msgArgs, cause);
    }

    public static UnsupportedOperationException createUnsupportedMethodError(Object o, String methodName) {
        throw new UnsupportedOperationException("Method " + methodName + " is not supported by Open JDBC");
    }

    public static Category getLogger(Class c) {
        int idx;
        String suffix = c.getName();
        if (suffix.startsWith(SAP_PACKAGE_PREFIX) && (idx = (suffix = suffix.substring(SAP_PACKAGE_PREFIX.length())).lastIndexOf(46)) > 0) {
            suffix = suffix.substring(0, idx);
        }
        Category logger = Category.getCategory((String)(OPEN_SQL_LOG_PREFIX + suffix.replace('.', '/')));
        logger.setResourceBundleName(OpenSQLResourceAccessor.getResourceAccessor().getResourceBundleName());
        return logger;
    }

    public static Category getLogger(Object o) {
        return Syslog.getLogger(o.getClass());
    }

    public static void logError(Class c, String msgKey, Object[] msgArgs) {
        Syslog.getLogger(c).error(Location.getLocation((Class)c), (Object)msgKey, msgArgs, Syslog.formatMessage(msgKey, msgArgs));
    }

    public static void logError(Object o, String msgKey, Object[] msgArgs) {
        Syslog.logError(o.getClass(), msgKey, msgArgs);
    }

    public static void logWarning(Class c, String msgKey, Object[] msgArgs) {
        Syslog.getLogger(c).warning(Location.getLocation((Class)c), (Object)msgKey, msgArgs, Syslog.formatMessage(msgKey, msgArgs));
    }

    public static void logWarning(Object o, String msgKey, Object[] msgArgs) {
        Syslog.logWarning(o.getClass(), msgKey, msgArgs);
    }

    public static void log(int severity, Class c, String msgKey, Object[] msgArgs) {
        Syslog.getLogger(c).log(severity, Location.getLocation((Class)c), (Object)msgKey, msgArgs, Syslog.formatMessage(msgKey, msgArgs));
    }

    public static void log(int severity, Object o, String msgKey, Object[] msgArgs) {
        Syslog.log(severity, o.getClass(), msgKey, msgArgs);
    }

    public static void logThrowable(Class c, Throwable cause) {
        Syslog.logThrowable(c, "com.sap.sql_0019", new Object[]{cause.getClass().getName(), cause.getMessage()}, cause);
    }

    public static void logThrowable(Object o, Throwable cause) {
        Syslog.logThrowable(o.getClass(), cause);
    }

    public static void logThrowable(Class c, String msgKey, Object[] msgArgs, Throwable cause) {
        Syslog.getLogger(c).logThrowable(500, Location.getLocation((Class)c), (Object)msgKey, msgArgs, Syslog.formatMessage(msgKey, msgArgs), cause);
    }

    public static void logThrowable(Object o, String msgKey, Object[] msgArgs, Throwable cause) {
        Syslog.logThrowable(o.getClass(), msgKey, msgArgs, cause);
    }

    public static IBaseException logIBaseException(Class c, IBaseException e) {
        e.setLogSettings(Syslog.getLogger(c), 500, Location.getLocation((Class)c));
        e.log();
        Location.getLocation((Class)c).errorT(e.getNestedStackTraceString());
        return e;
    }

    public static IBaseException logIBaseException(Object o, IBaseException e) {
        return Syslog.logIBaseException(o.getClass(), e);
    }

    public static OpenSQLException logOpenSQLException(OpenSQLException e) {
        Syslog.logIBaseException(e.getCreatorClass(), (IBaseException)e);
        return e;
    }

    public static SQLException logSQLException(Class c, SQLException e) {
        return Syslog.logSQLException(c, e, null, null);
    }

    public static SQLException logSQLException(Class c, SQLException e, String connId) {
        return Syslog.logSQLException(c, e, connId, null);
    }

    public static SQLException logSQLException(Class c, SQLException e, String connId, String sql) {
        String key;
        Object[] args = new Object[5];
        args[0] = new Integer(e.getErrorCode());
        args[1] = e.getSQLState();
        args[2] = Syslog.getChainedMessage(e);
        if (sql != null) {
            args[3] = connId;
            args[4] = sql;
            key = "com.sap.sql_0003";
        } else if (connId != null) {
            args[3] = connId;
            key = "com.sap.sql_0002";
        } else {
            key = "com.sap.sql_0001";
        }
        Syslog.logError(c, key, args);
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        Location.getLocation((Class)c).errorT(sw.toString());
        return e;
    }

    public static SQLException logSQLException(Object o, SQLException e) {
        return Syslog.logSQLException(o.getClass(), e, null, null);
    }

    public static SQLException logSQLException(Object o, SQLException e, String connId) {
        return Syslog.logSQLException(o.getClass(), e, connId, null);
    }

    public static SQLException logSQLException(Object o, SQLException e, String connId, String sql) {
        return Syslog.logSQLException(o.getClass(), e, connId, sql);
    }

    private static String getChainedMessage(SQLException e) {
        SQLException next = e.getNextException();
        if (next == null) {
            return e.getMessage();
        }
        StringBuffer sb = new StringBuffer(e.getMessage());
        do {
            sb.append("\n=> (" + next.getErrorCode() + "," + next.getSQLState() + "," + next.getMessage() + ")");
        } while ((next = next.getNextException()) != null && sb.length() < 100000);
        return sb.toString();
    }

    private static String formatMessage(String msgKey, Object[] msgArgs) {
        LocalizableTextFormatter formatter = new LocalizableTextFormatter(OpenSQLResourceAccessor.getResourceAccessor(), msgKey, msgArgs);
        try {
            return formatter.format();
        }
        catch (LocalizationException e) {
            TRACE.errorT("Couldn't format message. Cause: " + e.getMessage());
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

