/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.log;

import com.sap.tc.logging.Location;
import com.sap.tc.logging.PropertiesConfigurator;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

public class DefaultLoggingConfigurationManager {
    private static Properties traceProps = DefaultLoggingConfigurationManager.setDefaultProps();
    private static String loggingPropertiesFileName = "opensql_logging.properties";
    private static Location SQLTraceLoc = Location.getLocation((String)"SQLTraceLogger");

    private DefaultLoggingConfigurationManager() {
    }

    public static void setDefault() {
        try {
            File f = new File(loggingPropertiesFileName);
            if (f.exists()) {
                traceProps.load(new FileInputStream(f));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        PropertiesConfigurator pc = new PropertiesConfigurator(traceProps);
        pc.configure();
    }

    public static void setTraceLevel(String severity) {
        traceProps.setProperty("com.severity", severity);
        PropertiesConfigurator pc = new PropertiesConfigurator(traceProps);
        pc.configure();
    }

    public static void setLogLevel(String severity) {
        traceProps.setProperty("/System.severity", severity);
        traceProps.setProperty("/Applications.severity", severity);
        PropertiesConfigurator pc = new PropertiesConfigurator(traceProps);
        pc.configure();
    }

    public static void SQLTrace(boolean on) {
        if (on) {
            SQLTraceLoc.setEffectiveSeverity(100);
        } else {
            SQLTraceLoc.setEffectiveSeverity(701);
        }
    }

    private static Properties setDefaultProps() {
        Properties defaultProps = new Properties();
        defaultProps.setProperty("log[defaultTrace]", "FileLog");
        defaultProps.setProperty("log[defaultTrace].pattern", "default.trc");
        defaultProps.setProperty("log[defaultTrace].formatter", "ListFormatter");
        defaultProps.setProperty("com.logs", "log[defaultTrace]");
        defaultProps.setProperty("com.severity", "NONE");
        defaultProps.setProperty("log[SQLTrace]", "FileLog");
        defaultProps.setProperty("log[SQLTrace].pattern", "sqltrace.xml");
        defaultProps.setProperty("log[SQLTrace].formatter", "com.sap.sql.trace.SQLTraceXMLFormatter");
        defaultProps.setProperty("SQLTraceLogger.logs", "log[SQLTrace]");
        defaultProps.setProperty("SQLTraceLogger.severity", "NONE");
        defaultProps.setProperty("/Applications.logs", "log[applicationsLog]");
        defaultProps.setProperty("log[applicationsLog].formatter", "ListFormatter");
        defaultProps.setProperty("log[applicationsLog].pattern", "applications.log");
        defaultProps.setProperty("log[applicationsLog]", "FileLog");
        defaultProps.setProperty("/Applications.severity", "INFO");
        defaultProps.setProperty("/System.logs", "log[systemLog]");
        defaultProps.setProperty("log[systemLog].pattern", "system.log");
        defaultProps.setProperty("log[systemLog].formatter", "ListFormatter");
        defaultProps.setProperty("log[systemLog]", "FileLog");
        defaultProps.setProperty("/System.severity", "INFO");
        return defaultProps;
    }
}

