/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.log;

import com.sap.sql.log.ExceptionType;
import java.sql.SQLException;
import java.util.HashMap;

public class CommonSQLException
extends SQLException {
    static final long serialVersionUID = 873129777525599050L;
    private static final HashMap PACKAGE_MAP = new HashMap(20);
    protected transient ExceptionType exceptionType;
    protected String className;
    protected String methodName;

    public CommonSQLException(String className, String methodName, ExceptionType type, String text) {
        super("" + className + "." + methodName + ": " + type + ": " + text);
        this.exceptionType = type;
        this.className = className;
        this.methodName = methodName;
    }

    public CommonSQLException(Class c, String reason, int errorCode) {
        this(reason, CommonSQLException.getPackageState(c), CommonSQLException.mapErrorCode(c, errorCode));
    }

    private CommonSQLException(String reason, String state, int errorCode) {
        super("OSQL-" + errorCode + ": " + reason, state, errorCode);
    }

    private static String getPackageName(Class c) {
        return c.getPackage().getName();
    }

    private static String getPackageState(Class c) {
        PackageDescriptor pd = (PackageDescriptor)PACKAGE_MAP.get(CommonSQLException.getPackageName(c));
        return pd != null ? pd.state : null;
    }

    private static int mapErrorCode(Class c, int errorCode) {
        PackageDescriptor pd = (PackageDescriptor)PACKAGE_MAP.get(CommonSQLException.getPackageName(c));
        return pd != null ? pd.minCode + errorCode : 0;
    }

    static {
        PACKAGE_MAP.put("com.sap.sql", new PackageDescriptor(1000000, 1000099, "SAP00"));
        PACKAGE_MAP.put("com.sap.sql.buffer", new PackageDescriptor(1000100, 1000199, "SAP01"));
        PACKAGE_MAP.put("com.sap.sql.catalog", new PackageDescriptor(1000200, 1000299, "SAP02"));
        PACKAGE_MAP.put("com.sap.sql.dbcatalog", new PackageDescriptor(1000300, 1000399, "SAP03"));
        PACKAGE_MAP.put("com.sap.sql.jdbc", new PackageDescriptor(1000400, 1000499, "SAP04"));
        PACKAGE_MAP.put("com.sap.sql.jdbc.common", new PackageDescriptor(1000500, 1000599, "SAP05"));
        PACKAGE_MAP.put("com.sap.sql.jdbc.dbds", new PackageDescriptor(1000600, 1000699, "SAP06"));
        PACKAGE_MAP.put("com.sap.sql.jdbc.direct", new PackageDescriptor(1000700, 1000799, "SAP07"));
        PACKAGE_MAP.put("com.sap.sql.jdbc.internal", new PackageDescriptor(1000800, 1000899, "SAP08"));
        PACKAGE_MAP.put("com.sap.sql.jdbc.stmtpool", new PackageDescriptor(1000900, 1000999, "SAP09"));
        PACKAGE_MAP.put("com.sap.sql.nametab", new PackageDescriptor(1001000, 1001099, "SAP10"));
        PACKAGE_MAP.put("com.sap.sql.sqlj", new PackageDescriptor(1001100, 1001199, "SAP11"));
        PACKAGE_MAP.put("com.sap.sql.sqlparser", new PackageDescriptor(1001200, 1001299, "SAP12"));
        PACKAGE_MAP.put("com.sap.sql.sync", new PackageDescriptor(1001300, 1001399, "SAP13"));
        PACKAGE_MAP.put("com.sap.sql.tablebuffer", new PackageDescriptor(1001400, 1001499, "SAP14"));
        PACKAGE_MAP.put("com.sap.sql.trace", new PackageDescriptor(1001500, 1001599, "SAP15"));
    }

    private static class PackageDescriptor {
        public int minCode;
        public int maxCode;
        public String state;

        public PackageDescriptor(int minCode, int maxCode, String state) {
            this.minCode = minCode;
            this.maxCode = maxCode;
            this.state = state;
        }
    }
}

