/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.sapdb;

import com.sap.sql.jdbc.basic.BasicDbPortingServices;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;

public class SapdbPortingServices
extends BasicDbPortingServices {
    public SapdbPortingServices(Connection connection) {
        super(connection);
    }

    public String getConnectionID() throws SQLException {
        return this.getUserName() + "@" + this.getDatabaseHost() + ":" + this.getDatabaseName();
    }

    public Timestamp getUTCTimestamp() throws SQLException {
        CallableStatement cs = this.connection.prepareCall("SELECT UTCDATE INTO ? FROM DUAL");
        cs.execute();
        if (cs.getUpdateCount() < 1) {
            throw new SQLException("Failed to get UTC timestamp on DB server");
        }
        Timestamp ts = cs.getTimestamp(1, this.utcCalendar);
        cs.close();
        return ts;
    }

    public String getDatabaseProductName() throws SQLException {
        return this.connection.getMetaData().getDatabaseProductName();
    }

    public String getDatabaseProductVersion() throws SQLException {
        return this.connection.getMetaData().getDatabaseProductVersion();
    }

    public String getUserName() throws SQLException {
        return this.connection.getMetaData().getUserName();
    }

    public String getSchemaName() throws SQLException {
        return this.getUserName();
    }

    public String getDatabaseName() throws SQLException {
        String dbName = null;
        CallableStatement cs = this.connection.prepareCall("SELECT SERVERDB INTO ? FROM DOMAIN.SERVERDBS");
        cs.execute();
        if (cs.getUpdateCount() > 0) {
            dbName = cs.getString(1);
        }
        cs.close();
        return dbName;
    }

    public String getDatabaseHost() throws SQLException {
        String dbHost = null;
        CallableStatement cs = this.connection.prepareCall("SELECT SERVERNODE INTO ? FROM DOMAIN.SERVERDBS");
        cs.execute();
        if (cs.getUpdateCount() > 0) {
            dbHost = cs.getString(1);
        }
        cs.close();
        return dbHost;
    }

    public int getVendorID() {
        return 6;
    }

    public Boolean isDatabaseKernel64Bit() throws SQLException {
        CallableStatement cs = this.connection.prepareCall("SELECT SUBSTRING(RUNTIMEENVIRONMENT, 2, 2) INTO ? FROM DOMAIN.VERSIONS");
        cs.execute();
        if (cs.getUpdateCount() < 1) {
            throw new SQLException("Failed to get RUNTIMEENVIRONMENT on DB server");
        }
        String dbBit = cs.getString(1);
        cs.close();
        return new Boolean(dbBit.equals("64"));
    }

    public boolean selectAllocatesResources(int transactionIsolationLevel) {
        return transactionIsolationLevel > 1;
    }
}

